/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.cli.deployer.DistributeCommandArgs;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.ConsoleReader;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.ServerConnection;
import org.apache.geronimo.deployment.plugin.jmx.JMXDeploymentManager;
import org.apache.geronimo.kernel.util.JarUtils;

public class CommandDistribute
extends AbstractCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProgressObject runCommand(DeploymentManager mgr, ConsoleReader out, boolean inPlace, Target[] tlist, File module, File plan) throws DeploymentException {
        if (inPlace) {
            if (!(mgr instanceof JMXDeploymentManager)) {
                throw new DeploymentSyntaxException("Target DeploymentManager is not a Geronimo one. \nCannot perform in-place deployment.");
            }
            JMXDeploymentManager jmxMgr = (JMXDeploymentManager)mgr;
            try {
                jmxMgr.setInPlace(true);
                ProgressObject progressObject = mgr.distribute(tlist, module, plan);
                return progressObject;
            }
            finally {
                jmxMgr.setInPlace(false);
            }
        }
        return mgr.distribute(tlist, module, plan);
    }

    protected String getAction() {
        return "Distributed";
    }

    @Override
    public void execute(ConsoleReader consoleReader, ServerConnection connection, CommandArgs commandArgs) throws DeploymentException {
        File test;
        if (!(commandArgs instanceof DistributeCommandArgs)) {
            throw new DeploymentSyntaxException("CommandArgs has the type [" + commandArgs.getClass() + "]; expected [" + DistributeCommandArgs.class + "]");
        }
        DistributeCommandArgs distributeCommandArgs = (DistributeCommandArgs)commandArgs;
        BooleanHolder inPlaceHolder = new BooleanHolder();
        inPlaceHolder.inPlace = distributeCommandArgs.isInPlace();
        List<String> targets = Arrays.asList(distributeCommandArgs.getTargets());
        String[] args = distributeCommandArgs.getArgs();
        File module = null;
        File plan = null;
        if (args.length > 0) {
            test = new File(args[0]);
            try {
                if (JarUtils.isJarFile((File)test) || test.isDirectory()) {
                    if (module != null) {
                        throw new DeploymentSyntaxException("Module and plan cannot both be JAR files or directories!");
                    }
                    module = test;
                } else {
                    if (plan != null) {
                        throw new DeploymentSyntaxException("Module or plan must be a JAR file or directory!");
                    }
                    plan = test;
                }
            }
            catch (IOException e) {
                throw new DeploymentException("File not found: " + args[0]);
            }
        }
        if (args.length > 1) {
            test = new File(args[1]);
            try {
                if (JarUtils.isJarFile((File)test) || test.isDirectory()) {
                    if (module != null) {
                        throw new DeploymentSyntaxException("Module and plan cannot both be JAR files or directories!");
                    }
                    module = test;
                } else {
                    if (plan != null) {
                        throw new DeploymentSyntaxException("Module or plan must be a JAR file or directory!");
                    }
                    plan = test;
                }
            }
            catch (IOException e) {
                throw new DeploymentException("File not found:" + args[1]);
            }
        }
        if (module != null) {
            module = module.getAbsoluteFile();
        }
        if (plan != null) {
            plan = plan.getAbsoluteFile();
        }
        try {
            this.executeOnline(connection, inPlaceHolder.inPlace, targets, consoleReader, module, plan);
        }
        catch (IOException e) {
            throw new DeploymentException("Could not write to output", (Throwable)e);
        }
    }

    private void executeOnline(ServerConnection connection, boolean inPlace, List targets, ConsoleReader out, File module, File plan) throws DeploymentException, IOException {
        TargetModuleID[] results;
        ProgressObject po;
        boolean multipleTargets;
        Target[] tlist;
        DeploymentManager mgr = connection.getDeploymentManager();
        if (targets.size() > 0) {
            tlist = CommandDistribute.identifyTargets(targets, mgr);
            multipleTargets = tlist.length > 1;
            po = this.runCommand(mgr, out, inPlace, tlist, module, plan);
            this.waitForProgress(out, po);
        } else {
            tlist = mgr.getTargets();
            if (null == tlist) {
                throw new IllegalStateException("No target to distribute to");
            }
            multipleTargets = (tlist = new Target[]{tlist[0]}).length > 1;
            po = this.runCommand(mgr, out, inPlace, tlist, module, plan);
            this.waitForProgress(out, po);
        }
        for (TargetModuleID result : results = po.getResultTargetModuleIDs()) {
            out.printString(DeployUtils.reformat(this.getAction() + " " + result.getModuleID() + (multipleTargets ? " to " + result.getTarget().getName() : "") + (result.getWebURL() == null || !this.getAction().equals("Deployed") ? "" : " @ " + result.getWebURL()), 4, 72));
            if (result.getChildTargetModuleID() == null) continue;
            for (int j = 0; j < result.getChildTargetModuleID().length; ++j) {
                TargetModuleID child = result.getChildTargetModuleID()[j];
                out.printString(DeployUtils.reformat("  `-> " + child.getModuleID() + (child.getWebURL() == null || !this.getAction().equals("Deployed") ? "" : " @ " + child.getWebURL()), 4, 72));
            }
        }
        if (po.getDeploymentStatus().isFailed()) {
            throw new DeploymentException("Operation failed: " + po.getDeploymentStatus().getMessage());
        }
    }

    private String[] processTargets(String[] args, List targets) {
        if (args.length >= 2 && args[0].equals("--targets")) {
            String value = args[1];
            StringTokenizer tok = new StringTokenizer(value, ";", false);
            while (tok.hasMoreTokens()) {
                targets.add(tok.nextToken());
            }
            String[] temp = new String[args.length - 2];
            System.arraycopy(args, 2, temp, 0, temp.length);
            args = temp;
        }
        return args;
    }

    private String[] processInPlace(String[] args, BooleanHolder inPlaceHolder) {
        if (args.length >= 2 && args[0].equals("--inPlace")) {
            inPlaceHolder.inPlace = true;
            String[] temp = new String[args.length - 1];
            System.arraycopy(args, 1, temp, 0, temp.length);
            args = temp;
        }
        return args;
    }

    private final class BooleanHolder {
        public boolean inPlace;

        private BooleanHolder() {
        }
    }
}

