/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import jline.ConsoleReader;
import org.apache.geronimo.cli.CLParserException;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.cli.deployer.DistributeCommandArgsImpl;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.FileUtils;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.ServerConnection;
import org.apache.geronimo.kernel.repository.Artifact;

public class CommandRedeploy
extends AbstractCommand {
    public void checkFirstArguement(File args) throws DeploymentException {
        if (!args.exists()) {
            throw new DeploymentSyntaxException("Module or plan file does not exist: " + args.getAbsolutePath());
        }
        if (!args.canRead()) {
            throw new DeploymentException("Cannot read file " + args.getAbsolutePath());
        }
    }

    protected String getAction() {
        return "Redeployed";
    }

    public String guessModuleId(List modules, ServerConnection connection, ConsoleReader consoleReader, File plan, File module, TargetModuleID[] allModules) throws DeploymentException {
        String moduleId = null;
        try {
            if (modules.size() == 0 && connection.isGeronimo()) {
                this.emit(consoleReader, "No ModuleID or TargetModuleID provided.  Attempting to guess based on the content of the " + (plan == null ? "archive" : "plan") + ".");
                try {
                    if (plan != null) {
                        moduleId = DeployUtils.extractModuleIdFromPlan((File)plan);
                        if (moduleId == null) {
                            String fileName = module == null ? plan.getName() : module.getName();
                            int pos = fileName.lastIndexOf(46);
                            String artifactId = pos > -1 ? module.getName().substring(0, pos) : module.getName();
                            moduleId = "default/" + artifactId + "_G_MASTER" + "//";
                            this.emit(consoleReader, "Unable to locate Geronimo deployment plan in archive.  Calculating default ModuleID from archive name.");
                        } else {
                            Artifact configId = null;
                            configId = Artifact.create((String)moduleId);
                            moduleId = configId.getGroupId() + "/" + configId.getArtifactId() + "_G_MASTER" + "/" + configId.getVersion() + "/" + configId.getType();
                        }
                    } else if (module != null) {
                        moduleId = DeployUtils.extractModuleIdFromArchive((File)module);
                        if (moduleId == null) {
                            int pos = module.getName().lastIndexOf(46);
                            String artifactId = pos > -1 ? module.getName().substring(0, pos) : module.getName();
                            moduleId = "default/" + artifactId + "_G_MASTER" + "//";
                            this.emit(consoleReader, "Unable to locate Geronimo deployment plan in archive.  Calculating default ModuleID from archive name.");
                        } else {
                            Artifact configId = null;
                            configId = Artifact.create((String)moduleId);
                            moduleId = configId.getGroupId() + "/" + configId.getArtifactId() + "_G_MASTER" + "/" + configId.getVersion() + "/" + configId.getType();
                        }
                    }
                }
                catch (IOException e) {
                    throw new DeploymentException("Unable to read input files: " + e.getMessage(), (Throwable)e);
                }
                if (moduleId != null) {
                    this.emit(consoleReader, "Attempting to use ModuleID '" + moduleId + "'");
                    modules.addAll(DeployUtils.identifyTargetModuleIDs((TargetModuleID[])allModules, (String)moduleId, (boolean)true));
                } else {
                    this.emit(consoleReader, "Unable to calculate a ModuleID from supplied module and/or plan.");
                }
            }
            if (modules.size() == 0) {
                throw new DeploymentSyntaxException("No ModuleID or TargetModuleID available.  Nothing to do.  Maybe you should add a ModuleID or TargetModuleID to the command line?");
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to read input files: " + e.getMessage(), (Throwable)e);
        }
        return moduleId;
    }

    public void execute(ConsoleReader consoleReader, ServerConnection connection, CommandArgs commandArgs) throws DeploymentException {
        ProgressObject po;
        block61: {
            DistributeCommandArgsImpl distributeCommandArgs = null;
            try {
                TargetModuleID[] allModules;
                String[] args = commandArgs.getArgs();
                if (args.length == 0) {
                    throw new DeploymentSyntaxException("Must specify a module or plan (or both) and optionally module IDs to replace");
                }
                DeploymentManager mgr = connection.getDeploymentManager();
                Target[] allTargets = mgr.getTargets();
                try {
                    allModules = mgr.getAvailableModules(null, allTargets);
                }
                catch (TargetException e) {
                    throw new DeploymentException("Unable to load modules from server", (Throwable)e);
                }
                if (args.length >= 3 && args[0].equalsIgnoreCase("--targets")) {
                    boolean multipleTargets;
                    Target[] tlist;
                    ArrayList modules = new ArrayList();
                    File test = null;
                    File test1 = null;
                    File module = null;
                    File plan = null;
                    test = new File(args[2]);
                    this.checkFirstArguement(test);
                    if (FileUtils.isJarFile((File)test) || test.isDirectory()) {
                        if (module != null) {
                            throw new DeploymentSyntaxException("Module and plan cannot both be JAR files or directories!");
                        }
                        module = test;
                    } else {
                        if (plan != null) {
                            throw new DeploymentSyntaxException("Module or plan must be a JAR file or directory!");
                        }
                        plan = test;
                    }
                    if (args.length >= 4) {
                        test1 = new File(args[3]);
                        if (test1.exists() && test1.canRead()) {
                            if (FileUtils.isJarFile((File)test1) || test1.isDirectory()) {
                                if (module != null) {
                                    throw new DeploymentSyntaxException("Module and plan cannot both be JAR files or directories!");
                                }
                                module = test1;
                            } else {
                                if (plan != null) {
                                    throw new DeploymentSyntaxException("Module or plan must be a JAR file or directory!");
                                }
                                plan = test1;
                            }
                        } else {
                            modules.addAll(DeployUtils.identifyTargetModuleIDs((TargetModuleID[])allModules, (String)args[3], (boolean)false));
                        }
                    }
                    if (module != null) {
                        module = module.getAbsoluteFile();
                    }
                    if (plan != null) {
                        plan = plan.getAbsoluteFile();
                    }
                    if (args.length >= 5) {
                        for (int i = 4; i < args.length; ++i) {
                            modules.addAll(DeployUtils.identifyTargetModuleIDs((TargetModuleID[])allModules, (String)args[i], (boolean)false));
                        }
                    }
                    try {
                        distributeCommandArgs = new DistributeCommandArgsImpl(args);
                    }
                    catch (CLParserException e) {
                        e.printStackTrace();
                    }
                    List<String> targets = Arrays.asList(distributeCommandArgs.getTargets());
                    if (targets.size() > 0) {
                        Target[] tlist2 = CommandRedeploy.identifyTargets(targets, mgr);
                    }
                    if (modules.size() == 0) {
                        String moduleId = this.guessModuleId(modules, connection, consoleReader, plan, module, allModules);
                        modules.addAll(DeployUtils.identifyTargetModuleIDs((TargetModuleID[])allModules, (String)moduleId, (boolean)false));
                    }
                    TargetModuleID[] ids = modules.toArray(new TargetModuleID[modules.size()]);
                    boolean multiple = CommandRedeploy.isMultipleTargets(ids);
                    po = mgr.undeploy(ids);
                    this.waitForProgress(consoleReader, po);
                    TargetModuleID[] done = po.getResultTargetModuleIDs();
                    if (targets.size() > 0) {
                        tlist = CommandRedeploy.identifyTargets(targets, mgr);
                        multipleTargets = tlist.length > 1;
                        po = mgr.distribute(tlist, module, plan);
                        this.waitForProgress(consoleReader, po);
                    } else {
                        tlist = mgr.getTargets();
                        if (null == tlist) {
                            throw new IllegalStateException("No target to distribute to");
                        }
                        multipleTargets = (tlist = new Target[]{tlist[0]}).length > 1;
                        po = mgr.distribute(tlist, module, plan);
                        this.waitForProgress(consoleReader, po);
                    }
                    if (po.getDeploymentStatus().isFailed()) {
                        throw new DeploymentException("Unable to redeploy " + (module == null ? plan.getName() : module.getName()) + ": " + po.getDeploymentStatus().getMessage());
                    }
                    po = mgr.start(po.getResultTargetModuleIDs());
                    this.waitForProgress(consoleReader, po);
                    TargetModuleID[] resultsDeployment = po.getResultTargetModuleIDs();
                    for (int i = 0; i < resultsDeployment.length; ++i) {
                        TargetModuleID result = resultsDeployment[i];
                        consoleReader.printString(DeployUtils.reformat("Deployed " + result.getModuleID() + (multipleTargets ? " to " + result.getTarget().getName() : "") + (result.getWebURL() == null || !this.getAction().equals("Deployed") ? "" : " @ " + result.getWebURL()), 4, 72));
                        if (result.getChildTargetModuleID() == null) continue;
                        for (int j = 0; j < result.getChildTargetModuleID().length; ++j) {
                            TargetModuleID child = result.getChildTargetModuleID()[j];
                            consoleReader.printString(DeployUtils.reformat("  `-> " + child.getModuleID() + (child.getWebURL() == null || !this.getAction().equals("Deployed") ? "" : " @ " + child.getWebURL()), 4, 72));
                        }
                    }
                    TargetModuleID[] results = po.getResultTargetModuleIDs();
                    for (int i = 0; i < results.length; ++i) {
                        TargetModuleID result = results[i];
                        consoleReader.printString(DeployUtils.reformat(this.getAction() + " " + result.getModuleID() + (multipleTargets ? " to " + result.getTarget().getName() : "") + (result.getWebURL() == null || !this.getAction().equals("Deployed") ? "" : " @ " + result.getWebURL()), 4, 72));
                        if (result.getChildTargetModuleID() == null) continue;
                        for (int j = 0; j < result.getChildTargetModuleID().length; ++j) {
                            TargetModuleID child = result.getChildTargetModuleID()[j];
                            consoleReader.printString(DeployUtils.reformat("  `-> " + child.getModuleID() + (child.getWebURL() == null || !this.getAction().equals("Deployed") ? "" : " @ " + child.getWebURL()), 4, 72));
                        }
                    }
                    if (po.getDeploymentStatus().isFailed()) {
                        throw new DeploymentException("Operation failed: " + po.getDeploymentStatus().getMessage());
                    }
                    break block61;
                }
                ArrayList modules = new ArrayList();
                File module = null;
                File plan = null;
                File test = new File(args[0]);
                if (!test.exists()) {
                    throw new DeploymentSyntaxException("Module or plan file does not exist: " + test.getAbsolutePath());
                }
                if (!test.canRead()) {
                    throw new DeploymentException("Cannot read file " + test.getAbsolutePath());
                }
                if (FileUtils.isJarFile((File)test) || test.isDirectory()) {
                    module = test;
                } else {
                    plan = test;
                }
                if (args.length > 1) {
                    test = new File(args[1]);
                    if (test.exists() && test.canRead() && !args[1].equals(args[0])) {
                        if (FileUtils.isJarFile((File)test) || test.isDirectory()) {
                            if (module != null) {
                                throw new DeploymentSyntaxException("Module and plan cannot both be JAR files or directories!");
                            }
                            module = test;
                        } else {
                            if (plan != null) {
                                throw new DeploymentSyntaxException("Module or plan must be a JAR file or directory!");
                            }
                            plan = test;
                        }
                    } else {
                        modules.addAll(DeployUtils.identifyTargetModuleIDs((TargetModuleID[])allModules, (String)args[1], (boolean)false));
                    }
                }
                for (int i = 2; i < args.length; ++i) {
                    modules.addAll(DeployUtils.identifyTargetModuleIDs((TargetModuleID[])allModules, (String)args[i], (boolean)false));
                }
                if (modules.size() == 0 && connection.isGeronimo()) {
                    this.emit(consoleReader, "No ModuleID or TargetModuleID provided.  Attempting to guess based on the content of the " + (plan == null ? "archive" : "plan") + ".");
                    String moduleId = null;
                    try {
                        if (plan != null) {
                            moduleId = DeployUtils.extractModuleIdFromPlan((File)plan);
                            if (moduleId == null) {
                                String fileName = module == null ? plan.getName() : module.getName();
                                int pos = fileName.lastIndexOf(46);
                                String artifactId = pos > -1 ? module.getName().substring(0, pos) : module.getName();
                                moduleId = "default/" + artifactId + "//";
                                this.emit(consoleReader, "Unable to locate Geronimo deployment plan in archive.  Calculating default ModuleID from archive name.");
                            }
                        } else if (module != null && (moduleId = DeployUtils.extractModuleIdFromArchive((File)module)) == null) {
                            int pos = module.getName().lastIndexOf(46);
                            String artifactId = pos > -1 ? module.getName().substring(0, pos) : module.getName();
                            moduleId = "default/" + artifactId + "//";
                            this.emit(consoleReader, "Unable to locate Geronimo deployment plan in archive.  Calculating default ModuleID from archive name.");
                        }
                    }
                    catch (IOException e) {
                        throw new DeploymentException("Unable to read input files: " + e.getMessage(), (Throwable)e);
                    }
                    if (moduleId != null) {
                        this.emit(consoleReader, "Attempting to use ModuleID '" + moduleId + "'");
                        modules.addAll(DeployUtils.identifyTargetModuleIDs((TargetModuleID[])allModules, (String)moduleId, (boolean)true));
                    } else {
                        this.emit(consoleReader, "Unable to calculate a ModuleID from supplied module and/or plan.");
                    }
                }
                if (modules.size() == 0) {
                    throw new DeploymentSyntaxException("No ModuleID or TargetModuleID available.  Nothing to do.  Maybe you should add a ModuleID or TargetModuleID to the command line?");
                }
                if (module != null) {
                    module = module.getAbsoluteFile();
                }
                if (plan != null) {
                    plan = plan.getAbsoluteFile();
                }
                TargetModuleID[] ids = modules.toArray(new TargetModuleID[modules.size()]);
                boolean multiple = CommandRedeploy.isMultipleTargets(ids);
                po = mgr.redeploy(ids, module, plan);
                this.waitForProgress(consoleReader, po);
                TargetModuleID[] done = po.getResultTargetModuleIDs();
                for (int i = 0; i < done.length; ++i) {
                    TargetModuleID id = done[i];
                    this.emit(consoleReader, "Redeployed " + id.getModuleID() + (multiple ? " on " + id.getTarget().getName() : "") + (id.getWebURL() == null ? "" : " @ " + id.getWebURL()));
                    if (id.getChildTargetModuleID() == null) continue;
                    for (int j = 0; j < id.getChildTargetModuleID().length; ++j) {
                        TargetModuleID child = id.getChildTargetModuleID()[j];
                        this.emit(consoleReader, "  `-> " + child.getModuleID() + (child.getWebURL() == null ? "" : " @ " + child.getWebURL()));
                    }
                }
            }
            catch (IOException e) {
                throw new DeploymentException("Could not write to console", (Throwable)e);
            }
        }
        if (po.getDeploymentStatus().isFailed()) {
            throw new DeploymentException("Operation failed: " + po.getDeploymentStatus().getMessage());
        }
    }
}

