/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.util.Set;
import javax.enterprise.deploy.spi.DeploymentManager;
import jline.ConsoleReader;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.ServerConnection;
import org.apache.geronimo.deployment.plugin.jmx.RemoteDeploymentManager;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.NoSuchOperationException;

public class CommandStatsQuery
extends AbstractCommand {
    public void execute(ConsoleReader consoleReader, ServerConnection connection, CommandArgs commandArgs) throws DeploymentException {
        String[] args = commandArgs.getArgs();
        if (args.length == 0) {
            throw new DeploymentException("Specify either to 'enable' or 'disable' stats query on Default Server.");
        }
        DeploymentManager dm = connection.getDeploymentManager();
        Kernel kernel = null;
        if (dm instanceof RemoteDeploymentManager) {
            kernel = ((RemoteDeploymentManager)dm).getKernel();
        }
        AbstractNameQuery nameQuery = new AbstractNameQuery("org.apache.geronimo.monitoring.MasterRemoteControlJMX");
        Set it = kernel.listGBeans(nameQuery);
        AbstractName gbeanName = (AbstractName)it.iterator().next();
        Integer running = 0;
        try {
            running = (Integer)kernel.invoke(gbeanName, "SnapshotStatus");
            if ("disable".equals(args[0])) {
                if (running == 1) {
                    Boolean status = (Boolean)kernel.invoke(gbeanName, "stopSnapshot");
                    consoleReader.printString(DeployUtils.reformat(status != false ? "Stats query snapshot is now disabled." : "Disabling Stats query snapashot failed.", 4, 72));
                } else {
                    consoleReader.printString(DeployUtils.reformat("Stats query snapshot is not running.", 4, 72));
                }
            } else if ("enable".equals(args[0])) {
                if (args.length == 1) {
                    consoleReader.printString(DeployUtils.reformat("Please specify snapshotDuration in minutes.", 4, 72));
                    return;
                }
                Long snapshotDuration = (long)Integer.parseInt(args[1]) * 60000L;
                if (running == 1) {
                    Long prevSnapshotDuration = (Long)kernel.invoke(gbeanName, "getSnapshotDuration");
                    if (prevSnapshotDuration.equals(snapshotDuration)) {
                        consoleReader.printString(DeployUtils.reformat("Stats query snapshot is already running with duration of " + snapshotDuration / 60000L + " min.", 4, 72));
                    } else {
                        kernel.invoke(gbeanName, "setSnapshotDuration", new Object[]{snapshotDuration}, new String[]{Long.class.getName()});
                        consoleReader.printString(DeployUtils.reformat("Stats query snapshot was already running with duration of " + prevSnapshotDuration / 60000L + " min. Now it is changed to " + snapshotDuration / 60000L + " min.", 4, 72));
                    }
                } else {
                    Boolean status = (Boolean)kernel.invoke(gbeanName, "startSnapshot", new Object[]{snapshotDuration}, new String[]{Long.class.getName()});
                    consoleReader.printString(DeployUtils.reformat(status != false ? "Stats query snapshot started successfully with snapshot duration of " + snapshotDuration / 60000L + " min." : "Enabling Stats query snapshot failed.", 4, 72));
                }
            }
        }
        catch (GBeanNotFoundException e) {
            throw new DeploymentException("Unable to find the gbean associated with monitoring.", (Throwable)e);
        }
        catch (NoSuchOperationException e) {
            throw new DeploymentException("Operation does not exist", (Throwable)e);
        }
        catch (InternalKernelException e) {
            throw new DeploymentException((Throwable)e);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }
}

