/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import jline.ConsoleReader;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.ServerConnection;

public class CommandStart
extends AbstractCommand {
    public void execute(ConsoleReader consoleReader, ServerConnection connection, CommandArgs commandArgs) throws DeploymentException {
        ProgressObject po = null;
        try {
            TargetModuleID[] allModules;
            String[] args = commandArgs.getArgs();
            DeploymentManager mgr = connection.getDeploymentManager();
            Target[] allTargets = mgr.getTargets();
            try {
                allModules = mgr.getAvailableModules(null, allTargets);
            }
            catch (TargetException e) {
                throw new DeploymentException("Unable to load module list from server", (Throwable)e);
            }
            ArrayList modules = new ArrayList();
            for (int i = 0; i < args.length; ++i) {
                modules.addAll(DeployUtils.identifyTargetModuleIDs((TargetModuleID[])allModules, (String)args[i], (boolean)false));
            }
            TargetModuleID[] ids = modules.toArray(new TargetModuleID[modules.size()]);
            boolean multiple = CommandStart.isMultipleTargets(ids);
            po = this.runCommand(consoleReader, mgr, ids);
            TargetModuleID[] done = po.getResultTargetModuleIDs();
            consoleReader.printNewline();
            for (int i = 0; i < done.length; ++i) {
                TargetModuleID childs;
                TargetModuleID id = done[i];
                consoleReader.printString(DeployUtils.reformat(this.getAction() + " " + id.getModuleID() + (multiple && id.getTarget() != null ? " on " + id.getTarget().getName() : "") + (id.getWebURL() == null || !this.getAction().equals("Started") ? "" : " @ " + id.getWebURL()), 4, 72));
                if (id.getChildTargetModuleID() != null) {
                    for (int j = 0; j < id.getChildTargetModuleID().length; ++j) {
                        TargetModuleID child = id.getChildTargetModuleID()[j];
                        consoleReader.printString(DeployUtils.reformat("  `-> " + child.getModuleID() + (child.getWebURL() == null || this.getAction().toLowerCase().indexOf("started") == -1 ? "" : " @ " + child.getWebURL()), 4, 72));
                    }
                    continue;
                }
                Iterator iterator = DeployUtils.identifyTargetModuleIDs((TargetModuleID[])allModules, (String)id.getModuleID(), (boolean)false).iterator();
                if (!iterator.hasNext() || (childs = (TargetModuleID)iterator.next()).getChildTargetModuleID() == null) continue;
                for (int j = 0; j < childs.getChildTargetModuleID().length; ++j) {
                    TargetModuleID child = childs.getChildTargetModuleID()[j];
                    consoleReader.printString(DeployUtils.reformat("  `-> " + child.getModuleID() + (child.getWebURL() == null || this.getAction().toLowerCase().indexOf("started") == -1 ? "" : " @ " + child.getWebURL()), 4, 72));
                }
            }
        }
        catch (IOException e) {
            throw new DeploymentException("could not write to console", (Throwable)e);
        }
        if (po.getDeploymentStatus().isFailed()) {
            throw new DeploymentException("Operation failed: " + po.getDeploymentStatus().getMessage());
        }
    }

    protected ProgressObject runCommand(ConsoleReader out, DeploymentManager mgr, TargetModuleID[] ids) {
        ProgressObject po = mgr.start(ids);
        this.waitForProgress(out, po);
        return po;
    }

    protected String getAction() {
        return "Started";
    }
}

