/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.File;
import java.io.IOException;
import javax.enterprise.deploy.spi.DeploymentManager;
import jline.ConsoleReader;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.ServerConnection;
import org.apache.geronimo.deployment.plugin.GeronimoDeploymentManager;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.system.plugin.DownloadResults;

public class CommandInstallCAR
extends AbstractCommand {
    public void execute(ConsoleReader consoleReader, ServerConnection connection, CommandArgs commandArgs) throws DeploymentException {
        DeploymentManager dmgr = connection.getDeploymentManager();
        if (dmgr instanceof GeronimoDeploymentManager) {
            try {
                GeronimoDeploymentManager mgr = (GeronimoDeploymentManager)dmgr;
                if (commandArgs.getArgs().length == 0) {
                    throw new DeploymentException("Must specify Plugin CAR file");
                }
                File carFile = new File(commandArgs.getArgs()[0]);
                if (!(carFile = carFile.getAbsoluteFile()).exists() || !carFile.canRead()) {
                    throw new DeploymentException("CAR file cannot be read: " + carFile.getAbsolutePath());
                }
                Object key = mgr.startInstall(carFile, null, false, null, null);
                long start = System.currentTimeMillis();
                DownloadResults results = CommandInstallCAR.showProgress(consoleReader, mgr, key);
                int time = (int)(System.currentTimeMillis() - start) / 1000;
                CommandInstallCAR.printResults(consoleReader, results, time);
            }
            catch (IOException e) {
                throw new DeploymentException("Cannot install plugin", (Throwable)e);
            }
        } else {
            throw new DeploymentException("Cannot install plugins using " + dmgr.getClass().getName() + " deployment manager");
        }
    }

    static DownloadResults showProgress(ConsoleReader consoleReader, GeronimoDeploymentManager mgr, Object key) throws IOException {
        DeployUtils.println("Checking for status every 1000ms:", 0, consoleReader);
        String last = null;
        while (true) {
            DownloadResults results;
            if ((results = mgr.checkOnInstall(key)).getCurrentFile() != null) {
                String status = results.getCurrentFilePercent() > -1 ? results.getCurrentMessage() + " (" + results.getCurrentFilePercent() + "%)" : results.getCurrentMessage();
                if (last == null || !last.equals(status)) {
                    last = status;
                    DeployUtils.println(status, 0, consoleReader);
                    consoleReader.flushConsole();
                }
            }
            if (results.isFinished()) {
                if (results.isFailed()) {
                    DeployUtils.println("Installation FAILED: " + results.getFailure().getMessage(), 0, consoleReader);
                }
                return results;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return results;
            }
        }
    }

    static void printResults(ConsoleReader consoleReader, DownloadResults results, int time) throws IOException, DeploymentException {
        consoleReader.printNewline();
        if (!results.isFailed()) {
            DeployUtils.println("**** Installation Complete!", 0, consoleReader);
            for (MissingDependencyException e : results.getSkippedPlugins()) {
                DeployUtils.println(e.getMessage(), 0, consoleReader);
            }
            for (Artifact uri : results.getDependenciesPresent()) {
                DeployUtils.println("Used existing: " + uri, 0, consoleReader);
            }
            for (Artifact uri : results.getDependenciesInstalled()) {
                DeployUtils.println("Installed new: " + uri, 0, consoleReader);
            }
            consoleReader.printNewline();
            if (results.getTotalDownloadBytes() > 0L && time > 0) {
                DeployUtils.println("Downloaded " + results.getTotalDownloadBytes() / 1024L + " kB in " + time + "s (" + results.getTotalDownloadBytes() / (long)(1024 * time) + " kB/s)", 0, consoleReader);
            }
        }
    }
}

