/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.LifecycleException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.config.SwitchablePersistentConfigurationList;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.MissingDependencyException;

public class OfflineDeployerStarter {
    private static final Artifact OFFLINE_DEPLOYER_ARTIFACT = new Artifact("org.apache.geronimo.framework", "offline-deployer", (String)null, "car");
    private final Kernel kernel;
    private final AbstractName onlineDeployerConfigurationManagerName;
    private final ConfigurationManager onlineDeployerConfigurationManager;
    private final Set<AbstractName> onlineDeployerConfigStores;

    public OfflineDeployerStarter(Kernel kernel) {
        if (null == kernel) {
            throw new IllegalArgumentException("kernel is required");
        }
        this.kernel = kernel;
        this.onlineDeployerConfigurationManagerName = ConfigurationUtil.getConfigurationManagerName((Kernel)kernel);
        this.onlineDeployerConfigurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
        this.onlineDeployerConfigStores = kernel.listGBeans(new AbstractNameQuery(ConfigurationStore.class.getName()));
    }

    public void start() throws DeploymentException {
        try {
            Artifact offlineDeployerArtifact = this.resolveOfflineDeployer();
            this.startOfflineConfiguration(offlineDeployerArtifact);
            this.startPersistentOfflineConfigurations(offlineDeployerArtifact);
            this.stopOfflineConfigurationManager();
            this.enablePersistentConfigurationTracking();
        }
        catch (Exception e) {
            throw new DeploymentException("Unexpected error. Cannot start offline-deployer", (Throwable)e);
        }
        this.onlineDeployerConfigurationManager.setOnline(false);
    }

    protected Artifact resolveOfflineDeployer() throws MissingDependencyException {
        ArtifactResolver artifactResolver = this.onlineDeployerConfigurationManager.getArtifactResolver();
        return artifactResolver.resolveInClassLoader(OFFLINE_DEPLOYER_ARTIFACT);
    }

    protected void enablePersistentConfigurationTracking() throws GBeanNotFoundException {
        SwitchablePersistentConfigurationList switchableList = (SwitchablePersistentConfigurationList)this.kernel.getGBean(SwitchablePersistentConfigurationList.class);
        switchableList.setOnline(true);
    }

    protected void stopOnlineConfigStores() throws GBeanNotFoundException {
        for (AbstractName configStoreName : this.onlineDeployerConfigStores) {
            this.kernel.stopGBean(configStoreName);
        }
    }

    protected void stopOfflineConfigurationManager() throws GBeanNotFoundException {
        Set names = this.kernel.listGBeans(new AbstractNameQuery(ConfigurationManager.class.getName()));
        for (AbstractName abstractName : names) {
            if (this.onlineDeployerConfigurationManagerName.equals((Object)abstractName)) continue;
            this.kernel.stopGBean(abstractName);
        }
    }

    protected void startPersistentOfflineConfigurations(Artifact offlineDeployerArtifact) throws Exception {
        AbstractNameQuery query = new AbstractNameQuery(offlineDeployerArtifact, Collections.EMPTY_MAP, Collections.singleton(PersistentConfigurationList.class.getName()));
        Set configLists = this.kernel.listGBeans(query);
        ArrayList configs = new ArrayList();
        for (AbstractName configListName : configLists) {
            configs.addAll((List)this.kernel.invoke(configListName, "restore"));
        }
        for (Artifact config : configs) {
            this.onlineDeployerConfigurationManager.loadConfiguration(config);
            this.onlineDeployerConfigurationManager.startConfiguration(config);
        }
    }

    protected void startOfflineConfiguration(Artifact offlineDeployerArtifact) throws NoSuchConfigException, LifecycleException {
        this.onlineDeployerConfigurationManager.loadConfiguration(offlineDeployerArtifact);
        this.onlineDeployerConfigurationManager.startConfiguration(offlineDeployerArtifact);
    }
}

