/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.jar.JarFile;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.apache.geronimo.cli.deployer.ConnectionParams;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.InputPrompt;
import org.apache.geronimo.deployment.cli.OfflineDeployerStarter;
import org.apache.geronimo.deployment.plugin.factories.AuthenticationFailedException;
import org.apache.geronimo.deployment.plugin.jmx.JMXDeploymentManager;
import org.apache.geronimo.deployment.plugin.jmx.LocalDeploymentManager;
import org.apache.geronimo.kernel.Kernel;

public class ServerConnection {
    private final DeploymentFactory geronimoDeploymentFactory;
    private DeploymentManager manager;
    private UsernamePasswordHandler handler;
    private DeployUtils.SavedAuthentication auth;
    private boolean logToSysErr;
    private boolean verboseMessages;

    public ServerConnection(ConnectionParams params, PrintWriter out, InputStream in, Kernel kernel, DeploymentFactory geronimoDeploymentFactory) throws DeploymentException {
        this(params, new DefaultUserPasswordHandler(in, out), kernel, geronimoDeploymentFactory);
    }

    public ServerConnection(ConnectionParams params, UsernamePasswordHandler handler, Kernel kernel, DeploymentFactory geronimoDeploymentFactory) throws DeploymentException {
        if (null == kernel) {
            throw new IllegalArgumentException("kernel is required");
        }
        this.geronimoDeploymentFactory = geronimoDeploymentFactory;
        this.handler = handler;
        String uri = params.getURI();
        String driver = params.getDriver();
        String user = params.getUser();
        String password = params.getPassword();
        String host = params.getHost();
        Integer port = params.getPort();
        this.verboseMessages = params.isVerbose();
        this.logToSysErr = params.isSyserr();
        boolean offline = params.isOffline();
        boolean secure = params.isSecure();
        if (driver != null && uri == null) {
            throw new DeploymentSyntaxException("A custom driver requires a custom URI");
        }
        if (host != null || port != null) {
            uri = DeployUtils.getConnectionURI(host, port, secure);
        }
        if (offline) {
            this.startOfflineDeployer(kernel);
            this.manager = new LocalDeploymentManager(kernel);
        } else {
            this.tryToConnect(uri, driver, user, password, secure);
        }
        if (this.manager == null) {
            throw new DeploymentException("Unexpected error; connection failed.");
        }
    }

    protected void startOfflineDeployer(Kernel kernel) throws DeploymentException {
        OfflineDeployerStarter offlineDeployerStarter = new OfflineDeployerStarter(kernel);
        offlineDeployerStarter.start();
    }

    public void close() throws DeploymentException {
        if (this.manager != null) {
            this.manager.release();
        }
    }

    Serializable getAuthentication() {
        return this.auth;
    }

    String getServerURI() {
        return this.auth == null ? null : this.auth.getURI();
    }

    private void tryToConnect(String argURI, String driver, String user, String password, boolean secure) throws DeploymentException {
        String useURI;
        DeploymentFactoryManager mgr = DeploymentFactoryManager.getInstance();
        if (driver != null) {
            this.loadDriver(driver, mgr);
        } else {
            mgr.registerDeploymentFactory(this.geronimoDeploymentFactory);
        }
        String string = useURI = argURI == null ? DeployUtils.getConnectionURI(null, null, secure) : argURI;
        if (user == null && password == null) {
            try {
                DeployUtils.SavedAuthentication savedAuthentication = DeployUtils.readSavedCredentials(useURI);
                if (savedAuthentication != null) {
                    user = savedAuthentication.getUser();
                    password = new String(savedAuthentication.getPassword());
                }
            }
            catch (IOException e) {
                System.out.println("Warning: " + e.getMessage());
            }
        }
        if (user == null || password == null) {
            try {
                if (user == null) {
                    user = this.handler.getUsername();
                }
                if (password == null) {
                    password = this.handler.getPassword();
                }
            }
            catch (IOException e) {
                throw new DeploymentException("Unable to prompt for login", (Throwable)e);
            }
        }
        try {
            this.manager = mgr.getDeploymentManager(useURI, user, password);
            this.auth = new DeployUtils.SavedAuthentication(useURI, user, password == null ? null : password.toCharArray());
        }
        catch (AuthenticationFailedException e) {
            throw new DeploymentException("Login Failed");
        }
        catch (DeploymentManagerCreationException e) {
            throw new DeploymentException("Unable to connect to server at " + useURI + " -- " + e.getMessage(), (Throwable)e);
        }
        if (this.manager instanceof JMXDeploymentManager) {
            JMXDeploymentManager deploymentManager = (JMXDeploymentManager)this.manager;
            deploymentManager.setLogConfiguration(this.logToSysErr, this.verboseMessages);
        }
    }

    private void loadDriver(String driver, DeploymentFactoryManager mgr) throws DeploymentException {
        File file = new File(driver);
        if (!(file.exists() && file.canRead() && DeployUtils.isJarFile((File)file))) {
            throw new DeploymentSyntaxException("Driver '" + file.getAbsolutePath() + "' is not a readable JAR file");
        }
        String className = null;
        try {
            JarFile jar = new JarFile(file);
            className = jar.getManifest().getMainAttributes().getValue("J2EE-DeploymentFactory-Implementation-Class");
            if (className == null) {
                throw new DeploymentException("The driver JAR " + file.getAbsolutePath() + " does not specify a J2EE-DeploymentFactory-Implementation-Class; cannot load driver.");
            }
            jar.close();
            DeploymentFactory factory = (DeploymentFactory)Class.forName(className).newInstance();
            mgr.registerDeploymentFactory(factory);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentSyntaxException("Unable to load driver class " + className + " from JAR " + file.getAbsolutePath(), e);
        }
    }

    public DeploymentManager getDeploymentManager() {
        return this.manager;
    }

    public boolean isGeronimo() {
        return this.manager.getClass().getName().startsWith("org.apache.geronimo.");
    }

    private static class DefaultUserPasswordHandler
    implements UsernamePasswordHandler {
        private PrintWriter out;
        private InputStream in;
        private InputPrompt prompt;

        public DefaultUserPasswordHandler(InputStream in, PrintWriter out) {
            this.out = out;
            this.in = in;
        }

        private void initPrompt() throws IOException {
            this.prompt = new InputPrompt(this.in, this.out);
        }

        public String getPassword() throws IOException {
            this.initPrompt();
            return this.prompt.getPassword("Password: ");
        }

        public String getUsername() throws IOException {
            this.initPrompt();
            return this.prompt.getInput("Username: ");
        }
    }

    public static interface UsernamePasswordHandler {
        public String getUsername() throws IOException;

        public String getPassword() throws IOException;
    }
}

