/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Properties;
import jline.ConsoleReader;
import org.apache.geronimo.crypto.EncryptionManager;
import org.apache.geronimo.deployment.plugin.ConfigIDExtractor;

public class DeployUtils
extends ConfigIDExtractor {
    private static final String DEFAULT_URI = "deployer:geronimo:jmx";
    private static final String DEFAULT_SECURE_URI = "deployer:geronimo:jmxs";
    private static final int DEFAULT_TERM_WIDTH = 256;

    public static String reformat(String source, int indent, int endCol) {
        if (endCol - indent < 10) {
            throw new IllegalArgumentException("This is ridiculous!");
        }
        StringBuffer buf = new StringBuffer((int)((double)source.length() * 1.1));
        String prefix = indent == 0 ? "" : DeployUtils.buildIndent(indent);
        try {
            String line;
            BufferedReader in = new BufferedReader(new StringReader(source));
            block2: while ((line = in.readLine()) != null) {
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                while (line.length() > 0) {
                    line = prefix + line;
                    if (line.length() > endCol) {
                        int pos = line.lastIndexOf(32, endCol);
                        if (pos < indent && (pos = line.indexOf(32, endCol)) < indent) {
                            pos = line.length();
                        }
                        buf.append(line.substring(0, pos)).append('\n');
                        if (pos >= line.length() - 1) continue block2;
                        line = line.substring(pos + 1);
                        continue;
                    }
                    buf.append(line).append("\n");
                    continue block2;
                }
            }
        }
        catch (IOException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"This should be impossible"))).initCause(e));
        }
        return buf.toString();
    }

    public static void println(String line, int indent, ConsoleReader consoleReader) throws IOException {
        String prefix;
        int endCol = consoleReader.getTermwidth();
        int start = consoleReader.getCursorBuffer().cursor;
        if (endCol == 0) {
            endCol = 256;
        }
        if (endCol - indent < 10) {
            throw new IllegalArgumentException("This is ridiculous!");
        }
        String string = prefix = indent == 0 ? "" : DeployUtils.buildIndent(indent);
        while (line.length() > 0) {
            if (start == 0) {
                line = prefix + line;
            }
            if (line.length() > endCol - start) {
                int pos = line.lastIndexOf(32, endCol - start);
                if (pos < indent && (pos = line.indexOf(32, endCol - start)) < indent) {
                    pos = line.length();
                }
                consoleReader.printString(line.substring(0, pos));
                consoleReader.printNewline();
                if (pos >= line.length() - 1) break;
                line = line.substring(pos + 1);
                start = 0;
                continue;
            }
            consoleReader.printString(line);
            consoleReader.printNewline();
            break;
        }
    }

    public static void printTo(String string, int col, ConsoleReader consoleReader) throws IOException {
        consoleReader.printString(string);
        for (int i = string.length(); i < col; ++i) {
            consoleReader.printString(" ");
        }
    }

    private static String buildIndent(int indent) {
        StringBuffer buf = new StringBuffer(indent);
        for (int i = 0; i < indent; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public static String getConnectionURI(String host, Integer port, boolean secure) {
        if (host == null) {
            host = "localhost";
        }
        if (port == null) {
            port = new Integer(1099);
        }
        String uri = secure ? DEFAULT_SECURE_URI : DEFAULT_URI;
        uri = uri + "://" + host + ":" + port;
        return uri;
    }

    public static SavedAuthentication readSavedCredentials(String uri) throws IOException {
        File authFile;
        SavedAuthentication auth = null;
        InputStream in = DeployUtils.class.getResourceAsStream("/.geronimo-deployer");
        if (in == null && (authFile = new File(System.getProperty("user.home"), ".geronimo-deployer")).exists() && authFile.canRead()) {
            try {
                in = new BufferedInputStream(new FileInputStream(authFile));
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        if (in != null) {
            try {
                Properties props = new Properties();
                props.load(in);
                String encrypted = props.getProperty("login." + uri);
                if (encrypted != null) {
                    if (encrypted.startsWith("{Plain}")) {
                        int pos = encrypted.indexOf("/");
                        String user = encrypted.substring(7, pos);
                        String password = encrypted.substring(pos + 1);
                        auth = new SavedAuthentication(uri, user, password.toCharArray());
                    } else {
                        Serializable o = EncryptionManager.decrypt((String)encrypted);
                        if (o == encrypted) {
                            throw new IOException("Unknown encryption used in saved login file");
                        }
                        auth = (SavedAuthentication)o;
                    }
                }
            }
            catch (IOException e) {
                throw new IOException("Unable to read authentication from saved login file: " + e.getMessage());
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return auth;
    }

    public static final class SavedAuthentication
    implements Serializable {
        private static final long serialVersionUID = -3127576258038677899L;
        private String uri;
        private String user;
        private char[] password;

        public SavedAuthentication(String uri, String user, char[] password) {
            this.uri = uri;
            this.user = user;
            this.password = password;
        }

        public String getURI() {
            return this.uri;
        }

        public String getUser() {
            return this.user;
        }

        public char[] getPassword() {
            return this.password;
        }
    }
}

