/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Version;
import org.apache.geronimo.kernel.util.BundleUtil;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.geronimo.kernel.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigIDExtractor {
    private static final Logger log = LoggerFactory.getLogger(ConfigIDExtractor.class);
    private static final String APPLICATION_SYMBOLICNAME = "Application-SymbolicName";
    private static final String APPLICATION_VERION = "Application-Version";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractModuleIdFromArchive(File module) throws IOException, DeploymentException {
        if (!module.canRead()) {
            throw new DeploymentException("Not a readable file (" + module.getAbsolutePath() + ")");
        }
        if (module.isDirectory()) {
            File target = new File(module, "WEB-INF/web.xml").canRead() || new File(module, "WEB-INF/geronimo-web.xml").canRead() ? new File(module, "WEB-INF/geronimo-web.xml") : (new File(module, "META-INF/application.xml").canRead() || new File(module, "META-INF/geronimo-application.xml").canRead() ? new File(module, "META-INF/geronimo-application.xml") : (new File(module, "META-INF/ejb-jar.xml").canRead() || new File(module, "META-INF/openejb-jar.xml").canRead() ? new File(module, "META-INF/openejb-jar.xml") : (new File(module, "META-INF/ra.xml").canRead() || new File(module, "META-INF/geronimo-ra.xml").canRead() ? new File(module, "META-INF/geronimo-ra.xml") : (new File(module, "META-INF/application-client.xml").canRead() || new File(module, "META-INF/geronimo-application-client.xml").canRead() ? new File(module, "META-INF/geronimo-application-client.xml") : (new File(module, "META-INF/APPLICATION.MF").canRead() ? new File(module, "META-INF/APPLICATION.MF") : new File(module, "META-INF/geronimo-service.xml"))))));
            if (target.canRead()) {
                Artifact artifact;
                BufferedReader in = new BufferedReader(new FileReader(target));
                String name = null;
                if (target.getName().endsWith("xml")) {
                    name = ConfigIDExtractor.extractModuleIdFromPlan(in);
                } else if (target.getName().endsWith("MF")) {
                    name = ConfigIDExtractor.extractModuleIdFromAPPLICATION_MF(new FileInputStream(target));
                }
                if (name != null && (artifact = Artifact.create((String)name)).getArtifactId() == null) {
                    name = new Artifact(artifact.getGroupId(), module.getName(), artifact.getVersion(), artifact.getType()).toString();
                }
                return name;
            }
        } else {
            if (!JarUtils.isZipFile((File)module)) {
                throw new DeploymentException(module.getAbsolutePath() + " is neither a JAR file nor a directory!");
            }
            JarFile input = new JarFile(module);
            try {
                JarEntry entry = input.getJarEntry("WEB-INF/web.xml") != null || input.getJarEntry("WEB-INF/geronimo-web.xml") != null ? input.getJarEntry("WEB-INF/geronimo-web.xml") : (input.getJarEntry("META-INF/application.xml") != null || input.getJarEntry("META-INF/geronimo-application.xml") != null ? input.getJarEntry("META-INF/geronimo-application.xml") : (input.getJarEntry("META-INF/ejb-jar.xml") != null || input.getJarEntry("META-INF/openejb-jar.xml") != null ? input.getJarEntry("META-INF/openejb-jar.xml") : (input.getJarEntry("META-INF/ra.xml") != null || input.getJarEntry("META-INF/geronimo-ra.xml") != null ? input.getJarEntry("META-INF/geronimo-ra.xml") : (input.getJarEntry("META-INF/application-client.xml") != null || input.getJarEntry("META-INF/geronimo-application-client.xml") != null ? input.getJarEntry("META-INF/geronimo-application-client.xml") : (input.getJarEntry("META-INF/APPLICATION.MF") != null ? input.getJarEntry("META-INF/APPLICATION.MF") : input.getJarEntry("META-INF/geronimo-service.xml"))))));
                if (entry != null) {
                    Artifact artifact;
                    BufferedReader in = new BufferedReader(new InputStreamReader(input.getInputStream(entry)));
                    String name = null;
                    if (entry.getName().endsWith("xml")) {
                        name = ConfigIDExtractor.extractModuleIdFromPlan(in);
                    } else if (entry.getName().endsWith("MF")) {
                        name = ConfigIDExtractor.extractModuleIdFromAPPLICATION_MF(input.getInputStream(entry));
                    }
                    if (name != null && (artifact = Artifact.create((String)name)).getArtifactId() == null) {
                        name = new Artifact(artifact.getGroupId(), module.getName(), artifact.getVersion(), artifact.getType()).toString();
                    }
                    String string = name;
                    return string;
                }
            }
            finally {
                input.close();
            }
        }
        return null;
    }

    public static String extractModuleIdFromPlan(File plan) throws IOException {
        if (plan.isDirectory() || !plan.canRead()) {
            throw new IllegalArgumentException(plan.getAbsolutePath() + " is not a readable XML file!");
        }
        BufferedReader in = new BufferedReader(new FileReader(plan));
        return ConfigIDExtractor.extractModuleIdFromPlan(in);
    }

    public static Collection<TargetModuleID> identifyTargetModuleIDs(TargetModuleID[] allModules, String name, boolean fromPlan) throws DeploymentException {
        Artifact artifact;
        LinkedList<TargetModuleID> list = new LinkedList<TargetModuleID>();
        int pos = name.indexOf(124);
        if (pos > -1) {
            String target = name.substring(0, pos);
            String module = name.substring(pos + 1);
            Artifact artifact2 = Artifact.create((String)module);
            artifact2 = new Artifact(artifact2.getGroupId() == null && fromPlan ? "default" : artifact2.getGroupId(), artifact2.getArtifactId(), fromPlan ? (Version)null : artifact2.getVersion(), artifact2.getType());
            for (int i = 0; i < allModules.length; ++i) {
                if (!allModules[i].getTarget().getName().equals(target) || !artifact2.matches(Artifact.create((String)allModules[i].getModuleID()))) continue;
                list.add(allModules[i]);
            }
        }
        if (!list.isEmpty()) {
            return list;
        }
        artifact = name.indexOf("/") > -1 ? new Artifact((artifact = Artifact.create((String)name)).getGroupId() == null && fromPlan ? "default" : artifact.getGroupId(), artifact.getArtifactId(), fromPlan ? (Version)null : artifact.getVersion(), artifact.getType()) : new Artifact(fromPlan ? "default" : null, name, (Version)null, null);
        for (int i = 0; i < allModules.length; ++i) {
            if (!artifact.matches(Artifact.create((String)allModules[i].getModuleID()))) continue;
            list.add(allModules[i]);
        }
        if (list.isEmpty()) {
            throw new DeploymentException(name + " does not appear to be a the name of a module " + "available on the selected server. Perhaps it has already been " + "stopped or undeployed?  If you're trying to specify a " + "TargetModuleID, use the syntax TargetName|ModuleName instead. " + "If you're not sure what's running, try the list-modules command.");
        }
        return list;
    }

    private static String extractModuleIdFromAPPLICATION_MF(InputStream in) throws IOException, DeploymentException {
        Manifest appMf = new Manifest(in);
        String artifactID = appMf.getMainAttributes().getValue(APPLICATION_SYMBOLICNAME);
        String artifactVersion = appMf.getMainAttributes().getValue(APPLICATION_VERION);
        if (artifactID == null || artifactVersion == null) {
            throw new DeploymentException("Could not determine artifact or version with APPLICATION.MF of your EBA application");
        }
        org.osgi.framework.Version version = new org.osgi.framework.Version(artifactVersion.trim());
        return new Artifact("application", artifactID.trim(), BundleUtil.getVersion((org.osgi.framework.Version)version), "eba").toString();
    }

    private static String extractModuleIdFromPlan(Reader plan) throws IOException {
        SAXParserFactory factory = XmlUtil.newSAXParserFactory();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            SAXParser parser = factory.newSAXParser();
            ConfigIdHandler handler = new ConfigIdHandler();
            parser.parse(new InputSource(plan), (DefaultHandler)handler);
            if (handler.formatIs10) {
                log.warn("Geronimo deployment plan uses Geronimo 1.0 syntax.  Please update to Geronimo 1.1 syntax when possible.");
            }
            String string = handler.configId;
            return string;
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException("Unable to read plan: " + e.getMessage()).initCause(e);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("Unable to read plan: " + e.getMessage()).initCause(e);
        }
        finally {
            plan.close();
        }
    }

    private static class ConfigIdHandler
    extends DefaultHandler {
        private String configId;
        private boolean inConfigId;
        private String groupId = "";
        private String artifactId = "";
        private String version = "";
        private String type = "";
        private String inElement = null;
        private Stack parent = new Stack();
        private boolean formatIs10 = false;
        private String defaultType;

        private ConfigIdHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.defaultType == null && uri != null && !uri.equals("")) {
                this.setDefaultType(uri);
            }
            if (this.inConfigId) {
                if (localName.equals("groupId") || localName.equals("artifactId") || localName.equals("version") || localName.equals("type")) {
                    this.inElement = localName;
                }
            } else if (this.parent.size() == 2 && localName.equals("moduleId")) {
                this.inConfigId = true;
            } else if (this.parent.size() == 0 && attributes.getIndex("moduleId") > -1) {
                this.configId = attributes.getValue("moduleId");
                this.formatIs10 = true;
            }
            this.parent.push(localName);
        }

        private void setDefaultType(String namespace) {
            this.defaultType = namespace.indexOf("web") > -1 ? "war" : (namespace.indexOf("openejb") > -1 ? "jar" : (namespace.indexOf("connector") > -1 ? "rar" : (namespace.indexOf("application-client") > -1 ? "jar" : (namespace.indexOf("application") > -1 ? "ear" : "car"))));
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inElement != null) {
                this.formatIs10 = false;
                if (this.inElement.equals("groupId")) {
                    this.groupId = this.groupId + new String(ch, start, length);
                } else if (this.inElement.equals("artifactId")) {
                    this.artifactId = this.artifactId + new String(ch, start, length);
                } else if (this.inElement.equals("version")) {
                    this.version = this.version + new String(ch, start, length);
                } else if (this.inElement.equals("type")) {
                    this.type = this.type + new String(ch, start, length);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.inElement = null;
            if (this.inConfigId && localName.equals("moduleId")) {
                this.inConfigId = false;
            }
            if (!this.parent.peek().equals(localName)) {
                throw new IllegalStateException("End of " + localName + " but expecting " + this.parent.peek());
            }
            this.parent.pop();
        }

        @Override
        public void endDocument() throws SAXException {
            if (!this.formatIs10) {
                if (this.type.equals("") && this.defaultType != null) {
                    this.type = this.defaultType;
                }
                this.configId = this.groupId + "/" + this.artifactId + "/" + this.version + "/" + this.type;
            }
            if (this.configId.equals("///")) {
                this.configId = null;
            }
        }
    }
}

