/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.jmx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.geronimo.deployment.plugin.jmx.ExtendedDeploymentManager;
import org.apache.geronimo.deployment.spi.ModuleConfigurer;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDeploymentManager
extends ExtendedDeploymentManager {
    private static final Logger log = LoggerFactory.getLogger(LocalDeploymentManager.class);
    private static final AbstractNameQuery CONFIGURER_QUERY = new AbstractNameQuery(ModuleConfigurer.class.getName());

    public LocalDeploymentManager(Kernel kernel) throws IOException {
        super(LocalDeploymentManager.loadModuleConfigurers(kernel));
        this.initialize(kernel);
    }

    private static Collection<ModuleConfigurer> loadModuleConfigurers(Kernel kernel) {
        ArrayList<ModuleConfigurer> moduleConfigurers = new ArrayList<ModuleConfigurer>();
        Set configurerNames = kernel.listGBeans(CONFIGURER_QUERY);
        for (AbstractName configurerName : configurerNames) {
            try {
                Object o = kernel.getGBean(configurerName);
                if (!(o instanceof ModuleConfigurer)) {
                    log.error("Gbean classloader: " + o.getClass().getClassLoader());
                    log.error("ModuleConfigurer classloader: " + ModuleConfigurer.class.getClassLoader());
                }
                ModuleConfigurer configurer = (ModuleConfigurer)o;
                moduleConfigurers.add(configurer);
            }
            catch (GBeanNotFoundException e) {
                log.warn("No gbean found for name returned in query : " + configurerName);
            }
        }
        return moduleConfigurers;
    }
}

