/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.local;

import java.io.File;
import java.io.InputStream;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.apache.geronimo.deployment.plugin.ConfigIDExtractor;
import org.apache.geronimo.deployment.plugin.TargetImpl;
import org.apache.geronimo.deployment.plugin.TargetModuleIDImpl;
import org.apache.geronimo.deployment.plugin.local.AbstractDeployCommand;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.LifecycleResults;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;

public class RedeployCommand
extends AbstractDeployCommand {
    private static final String[] IS_IN_PLACE_CONFIGURATION_SIG = new String[]{Artifact.class.getName()};
    private static final String IS_IN_PLACE_CONFIGURATION_METH = "isInPlaceConfiguration";
    private final TargetModuleID[] modules;

    public RedeployCommand(Kernel kernel, TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan) {
        super(CommandType.REDEPLOY, kernel, moduleArchive, deploymentPlan, null, null, null, false);
        this.modules = moduleIDList;
    }

    public RedeployCommand(Kernel kernel, TargetModuleID[] moduleIDList, InputStream moduleArchive, InputStream deploymentPlan) {
        super(CommandType.REDEPLOY, kernel, null, null, null, moduleArchive, deploymentPlan, true);
        this.modules = moduleIDList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.deployer == null) {
            return;
        }
        try {
            String extracted;
            if (this.spool) {
                if (this.moduleStream != null) {
                    this.moduleArchive = RedeployCommand.createTempFile(this.moduleType == null ? null : this.moduleType.getModuleExtension());
                    this.copyTo(this.moduleArchive, this.moduleStream);
                }
                if (this.deploymentStream != null) {
                    this.deploymentPlan = RedeployCommand.createTempFile(null);
                    this.copyTo(this.deploymentPlan, this.deploymentStream);
                }
            }
            Artifact configID = null;
            if (this.deploymentPlan != null) {
                extracted = ConfigIDExtractor.extractModuleIdFromPlan(this.deploymentPlan);
                if (extracted != null) {
                    configID = Artifact.create((String)extracted);
                }
            } else {
                extracted = ConfigIDExtractor.extractModuleIdFromArchive(this.moduleArchive);
                if (extracted != null) {
                    configID = Artifact.create((String)extracted);
                }
            }
            if (configID != null && configID.getGroupId() == null) {
                configID = new Artifact("default", configID.getArtifactId(), configID.getVersion(), configID.getType());
            }
            ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
            try {
                for (int i = 0; i < this.modules.length; ++i) {
                    TargetModuleIDImpl module = (TargetModuleIDImpl)this.modules[i];
                    Artifact artifact = Artifact.create((String)module.getModuleID());
                    if (configID != null && configID.isResolved()) {
                        if (configID.getGroupId().equals(artifact.getGroupId()) && configID.getArtifactId().equals(artifact.getArtifactId()) && configID.getVersion().equals((Object)artifact.getVersion())) {
                            this.redeploySameConfiguration(configurationManager, artifact, module.getTarget());
                            continue;
                        }
                        this.redeployUpdatedConfiguration(configurationManager, artifact, module.getTarget());
                        continue;
                    }
                    this.redeployUpdatedConfiguration(configurationManager, artifact, module.getTarget());
                }
            }
            finally {
                ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)configurationManager);
            }
            this.addWebURLs(this.kernel);
            this.complete("Completed");
        }
        catch (Throwable e) {
            this.doFail(e);
        }
        finally {
            if (this.spool) {
                if (this.moduleArchive != null) {
                    this.moduleArchive.delete();
                }
                if (this.deploymentPlan != null) {
                    this.deploymentPlan.delete();
                }
            }
        }
    }

    private void redeployUpdatedConfiguration(ConfigurationManager manager, Artifact previous, Target target) throws Exception, NoSuchConfigException {
        TargetImpl impl = (TargetImpl)target;
        AbstractName storeName = impl.getAbstractName();
        Boolean inPlaceConfiguration = (Boolean)this.kernel.invoke(storeName, IS_IN_PLACE_CONFIGURATION_METH, new Object[]{previous}, IS_IN_PLACE_CONFIGURATION_SIG);
        this.commandContext.setInPlace(inPlaceConfiguration);
        this.doDeploy(target, false);
        Artifact configID = Artifact.create((String)this.getResultTargetModuleIDs()[0].getModuleID());
        LifecycleResults results = manager.reloadConfiguration(previous, configID.getVersion());
        boolean newStarted = false;
        for (Artifact name : results.getStopped()) {
            this.updateStatus("Stopped " + name);
        }
        for (Artifact name : results.getUnloaded()) {
            this.updateStatus("Unloaded " + name);
        }
        for (Artifact name : results.getLoaded()) {
            this.updateStatus("Loaded " + name);
        }
        for (Artifact name : results.getStarted()) {
            this.updateStatus("Started " + name);
            if (!configID.matches(name)) continue;
            newStarted = true;
        }
        for (Artifact name : results.getFailed().keySet()) {
            this.updateStatus("Failed on " + name + ": " + results.getFailedCause(name).getMessage());
            this.doFail((Exception)results.getFailedCause(name));
        }
        if (results.getFailed().size() == 0 && !newStarted) {
            this.updateStatus("Note: new module was not started (probably because old module was not running).");
        }
    }

    private void redeploySameConfiguration(ConfigurationManager configurationManager, Artifact configID, Target target) throws Exception {
        Exception cause;
        if (!configID.isResolved()) {
            throw new IllegalStateException("Cannot redeploy same module when module ID is not fully resolved (" + configID + ")");
        }
        try {
            configurationManager.stopConfiguration(configID);
            this.updateStatus("Stopped " + configID);
        }
        catch (InternalKernelException e) {
            cause = (Exception)e.getCause();
            if (!(cause instanceof NoSuchConfigException)) {
                throw cause;
            }
        }
        catch (NoSuchConfigException e) {
            // empty catch block
        }
        try {
            configurationManager.unloadConfiguration(configID);
            this.updateStatus("Unloaded " + configID);
        }
        catch (InternalKernelException e) {
            cause = (Exception)e.getCause();
            if (!(cause instanceof NoSuchConfigException)) {
                throw cause;
            }
        }
        catch (NoSuchConfigException e) {
            // empty catch block
        }
        TargetImpl impl = (TargetImpl)target;
        AbstractName storeName = impl.getAbstractName();
        Boolean inPlaceConfiguration = (Boolean)this.kernel.invoke(storeName, IS_IN_PLACE_CONFIGURATION_METH, new Object[]{configID}, IS_IN_PLACE_CONFIGURATION_SIG);
        this.commandContext.setInPlace(inPlaceConfiguration);
        try {
            configurationManager.uninstallConfiguration(configID);
            this.updateStatus("Uninstalled " + configID);
        }
        catch (InternalKernelException e) {
            Exception cause2 = (Exception)e.getCause();
            if (cause2 instanceof NoSuchConfigException) {
                throw new IllegalStateException("Module " + configID + " is not installed!", cause2);
            }
            throw cause2;
        }
        catch (NoSuchConfigException e) {
            throw new IllegalStateException("Module " + configID + " is not installed!", e);
        }
        this.doDeploy(target, false);
        this.updateStatus("Deployed " + configID);
        configurationManager.loadConfiguration(configID);
        configurationManager.startConfiguration(configID);
        this.updateStatus("Started " + configID);
    }
}

