/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);
    public static final int DEFAULT_COPY_BUFFER_SIZE = 4096;

    public static void copy(InputStream in, OutputStream out) throws IOException {
        IOUtils.copy(in, out, 4096);
    }

    public static void copy(InputStream in, OutputStream out, int bufferSizeInBytes) throws IOException {
        IOUtils.copy(in, out, new byte[bufferSizeInBytes]);
    }

    public static void copy(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        int count;
        while ((count = in.read(buffer)) > 0) {
            out.write(buffer, 0, count);
        }
        out.flush();
    }

    public static void close(Closeable thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(InputStream inputStream) throws IOException {
        try {
            byte[] bytes;
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int count = inputStream.read(buffer);
            while (count >= 0) {
                out.write(buffer, 0, count);
                count = inputStream.read(buffer);
            }
            byte[] byArray = bytes = out.toByteArray();
            return byArray;
        }
        finally {
            IOUtils.close(inputStream);
        }
    }

    public static void flush(OutputStream thing) {
        if (thing != null) {
            try {
                thing.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void flush(Writer thing) {
        if (thing != null) {
            try {
                thing.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final class EmptyInputStream
    extends InputStream {
        @Override
        public int read() {
            return -1;
        }

        @Override
        public int read(byte[] b) {
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            return -1;
        }

        @Override
        public long skip(long n) {
            return 0L;
        }

        @Override
        public int available() {
            return 0;
        }

        @Override
        public void close() {
        }

        @Override
        public synchronized void mark(int readlimit) {
        }

        @Override
        public synchronized void reset() {
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

