/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.jmx;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.lifecycle.LifecycleAdapter;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.geronimo.system.jmx.JMXUtil;
import org.apache.geronimo.system.jmx.MBeanGBeanBridge;
import org.apache.geronimo.system.jmx.MBeanServerReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanServerKernelBridge
implements GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(MBeanServerKernelBridge.class);
    private static final AbstractNameQuery ALL = new AbstractNameQuery(null, Collections.EMPTY_MAP, Collections.EMPTY_SET);
    private final HashMap registry = new HashMap();
    private final Kernel kernel;
    private final MBeanServer mbeanServer;
    public static final GBeanInfo GBEAN_INFO;

    public MBeanServerKernelBridge(Kernel kernel, MBeanServerReference mbeanServerReference) {
        this(kernel, mbeanServerReference.getMBeanServer());
    }

    public MBeanServerKernelBridge(Kernel kernel, MBeanServer mbeanServer) {
        this.kernel = kernel;
        this.mbeanServer = mbeanServer;
    }

    @Override
    public void doStart() {
        this.kernel.getLifecycleMonitor().addLifecycleListener((LifecycleListener)new GBeanRegistrationListener(), ALL);
        Set<AbstractName> allNames = this.kernel.listGBeans(ALL);
        for (AbstractName abstractName : allNames) {
            this.register(abstractName);
        }
    }

    @Override
    public void doFail() {
        this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() {
        HashMap beans;
        MBeanServerKernelBridge mBeanServerKernelBridge = this;
        synchronized (mBeanServerKernelBridge) {
            beans = new HashMap(this.registry);
            this.registry.clear();
        }
        for (MBeanGBeanBridge mbeanGBeanBridge : beans.values()) {
            ObjectName objectName = mbeanGBeanBridge.getObjectName();
            try {
                this.mbeanServer.unregisterMBean(objectName);
            }
            catch (Exception e) {}
        }
    }

    public NotificationBroadcasterSupport getNotificationBroadcasterSupport(AbstractName abstractName) {
        MBeanGBeanBridge bridge = (MBeanGBeanBridge)this.registry.get(abstractName);
        return bridge == null ? null : bridge.getNotificationBroadcasterSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(AbstractName abstractName) {
        try {
            MBeanGBeanBridge mbeanGBeanBridge;
            MBeanServerKernelBridge mBeanServerKernelBridge = this;
            synchronized (mBeanServerKernelBridge) {
                if (this.registry.containsKey(abstractName)) {
                    return;
                }
                MBeanInfo mbeanInfo = JMXUtil.toMBeanInfo(this.kernel.getGBeanInfo(abstractName));
                mbeanGBeanBridge = new MBeanGBeanBridge(this.kernel, abstractName, abstractName.getObjectName(), mbeanInfo);
                this.registry.put(abstractName, mbeanGBeanBridge);
            }
            this.mbeanServer.registerMBean(mbeanGBeanBridge, mbeanGBeanBridge.getObjectName());
        }
        catch (GBeanNotFoundException e) {
        }
        catch (InstanceAlreadyExistsException e) {
        }
        catch (Exception e) {
            log.warn("Unable to register MBean shadow object for GBean", this.unwrapJMException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(AbstractName abstractName) {
        MBeanGBeanBridge mbeanGBeanBridge;
        MBeanServerKernelBridge mBeanServerKernelBridge = this;
        synchronized (mBeanServerKernelBridge) {
            mbeanGBeanBridge = (MBeanGBeanBridge)this.registry.remove(abstractName);
        }
        if (mbeanGBeanBridge != null) {
            try {
                this.mbeanServer.unregisterMBean(mbeanGBeanBridge.getObjectName());
            }
            catch (InstanceNotFoundException e) {
            }
            catch (Exception e) {
                log.warn("Unable to unregister MBean shadow object for GBean", this.unwrapJMException(e));
            }
        }
    }

    private Throwable unwrapJMException(Throwable cause) {
        while ((cause instanceof JMException || cause instanceof JMRuntimeException) && cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(MBeanServerKernelBridge.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addReference("MBeanServerReference", MBeanServerReference.class);
        infoFactory.setConstructor(new String[]{"kernel", "MBeanServerReference"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private class GBeanRegistrationListener
    extends LifecycleAdapter {
        private GBeanRegistrationListener() {
        }

        @Override
        public void loaded(AbstractName abstractName) {
            MBeanServerKernelBridge.this.register(abstractName);
        }

        @Override
        public void unloaded(AbstractName abstractName) {
            MBeanServerKernelBridge.this.unregister(abstractName);
        }
    }
}

