/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.DeploymentWatcher;
import org.apache.geronimo.kernel.config.EditableConfigurationManager;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.KernelConfigurationManager;
import org.apache.geronimo.kernel.config.ManageableAttributeStore;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactManager;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.xbean.osgi.bundle.util.BundleClassLoader;
import org.osgi.framework.BundleContext;

@GBean(j2eeType="ConfigurationManager")
public class EditableKernelConfigurationManager
extends KernelConfigurationManager
implements EditableConfigurationManager {
    private final AbstractNameQuery defaultStoreNameQuery;
    public static final String GBEAN_ATTR_DEFAULT_STORE_NAME_QUERY = "defaultStoreNameQuery";

    public EditableKernelConfigurationManager(@ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamAttribute(name="defaultStoreNameQuery") AbstractNameQuery defaultStoreNameQuery, @ParamReference(name="Stores", namingType="ConfigurationStore") Collection<ConfigurationStore> stores, @ParamReference(name="AttributeStore", namingType="AttributeStore") ManageableAttributeStore attributeStore, @ParamReference(name="PersistentConfigurationList") PersistentConfigurationList configurationList, @ParamReference(name="ArtifactManager", namingType="ArtifactManager") ArtifactManager artifactManager, @ParamReference(name="ArtifactResolver", namingType="ArtifactResolver") ArtifactResolver artifactResolver, @ParamReference(name="Repositories", namingType="Repository") Collection<ListableRepository> repositories, @ParamReference(name="Watchers") Collection<DeploymentWatcher> watchers, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext) {
        super(kernel, stores, attributeStore, configurationList, artifactManager, artifactResolver, repositories, watchers, bundleContext);
        this.defaultStoreNameQuery = defaultStoreNameQuery;
    }

    protected List getStoreList() {
        if (null == this.defaultStoreNameQuery) {
            return super.getStoreList();
        }
        ArrayList<ConfigurationStore> storeList = new ArrayList<ConfigurationStore>();
        for (ConfigurationStore configurationStore : this.stores) {
            if (this.defaultStoreNameQuery.matches(configurationStore.getAbstractName(), Collections.EMPTY_SET)) {
                storeList.add(0, configurationStore);
                continue;
            }
            storeList.add(configurationStore);
        }
        return storeList;
    }

    @Override
    public void addGBeanToConfiguration(Artifact configurationId, GBeanData gbean, boolean start) throws InvalidConfigException {
        Configuration configuration = this.getConfiguration(configurationId);
        try {
            configuration.addGBean(gbean);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new InvalidConfigException("Cound not add GBean " + gbean.getAbstractName() + " to configuration " + configurationId, e);
        }
        this.addGBeanToConfiguration(configuration, gbean, start);
    }

    @Override
    public void addGBeanToConfiguration(Artifact configurationId, String name, GBeanData gbean, boolean start) throws InvalidConfigException {
        Configuration configuration = this.getConfiguration(configurationId);
        try {
            configuration.addGBean(name, gbean);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new InvalidConfigException("Cound not add GBean " + gbean.getAbstractName() + " to configuration " + configurationId, e);
        }
        this.addGBeanToConfiguration(configuration, gbean, start);
    }

    private void addGBeanToConfiguration(Configuration configuration, GBeanData gbean, boolean start) throws InvalidConfigException {
        block15: {
            BundleClassLoader configurationClassLoader = new BundleClassLoader(configuration.getBundle());
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)configurationClassLoader);
                log.trace("Registering GBean " + gbean.getAbstractName());
                ConfigurationUtil.preprocessGBeanData(configuration.getAbstractName(), configuration, gbean);
                this.kernel.loadGBean(gbean, configuration.getBundleContext());
                if (!start) break block15;
                try {
                    this.kernel.startRecursiveGBean(gbean.getAbstractName());
                }
                catch (GBeanNotFoundException e) {
                    throw new InvalidConfigException("How could we not find a GBean that we just loaded ('" + gbean.getAbstractName() + "')?", e);
                }
            }
            catch (Exception e) {
                try {
                    configuration.removeGBean(gbean.getAbstractName());
                }
                catch (GBeanNotFoundException e1) {
                    // empty catch block
                }
                try {
                    this.kernel.stopGBean(gbean.getAbstractName());
                }
                catch (GBeanNotFoundException e1) {
                    // empty catch block
                }
                try {
                    this.kernel.unloadGBean(gbean.getAbstractName());
                }
                catch (GBeanNotFoundException e1) {
                    // empty catch block
                }
                if (e instanceof InvalidConfigException) {
                    throw (InvalidConfigException)e;
                }
                throw new InvalidConfigException("Cound not add GBean " + gbean.getAbstractName() + " to configuration " + configuration.getId(), e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        if (this.attributeStore != null) {
            this.attributeStore.addGBean(configuration.getId(), gbean, configuration.getBundle());
        }
    }

    @Override
    public void removeGBeanFromConfiguration(Artifact configurationId, AbstractName gbeanName) throws GBeanNotFoundException, InvalidConfigException {
        Configuration configuration = this.getConfiguration(configurationId);
        if (!configuration.containsGBean(gbeanName)) {
            throw new GBeanNotFoundException(gbeanName);
        }
        configuration.removeGBean(gbeanName);
        try {
            if (this.kernel.getGBeanState(gbeanName) == 1) {
                this.kernel.stopGBean(gbeanName);
            }
            this.kernel.unloadGBean(gbeanName);
        }
        catch (GBeanNotFoundException e) {
            // empty catch block
        }
        if (this.attributeStore != null) {
            this.attributeStore.setShouldLoad(configurationId, gbeanName, false);
        }
    }
}

