/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.common.propertyeditor;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.geronimo.common.propertyeditor.ArrayPropertyEditorAdapter;
import org.apache.geronimo.common.propertyeditor.BooleanEditor;
import org.apache.geronimo.common.propertyeditor.IntegerEditor;
import org.apache.geronimo.common.propertyeditor.PropertyEditorException;
import org.apache.geronimo.kernel.ClassLoading;
import org.osgi.framework.Bundle;

public class PropertyEditors {
    public static PropertyEditor findEditor(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            return editor;
        }
        if (type.isArray() && (editor = PropertyEditors.findEditor(type.getComponentType())) != null) {
            return new ArrayPropertyEditorAdapter(type.getComponentType(), editor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyEditor findEditor(String typeName, ClassLoader loader) throws ClassNotFoundException {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName is null");
        }
        Class type = null;
        try {
            type = ClassLoading.loadClass(typeName, loader);
        }
        catch (ClassNotFoundException e) {
            type = ClassLoading.loadClass(typeName + "$PropertyEditor", loader);
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            PropertyEditor propertyEditor = PropertyEditors.findEditor(type);
            return propertyEditor;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyEditor findEditor(String typeName, Bundle bundle) throws ClassNotFoundException {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName is null");
        }
        Class type = null;
        try {
            type = ClassLoading.loadClass(typeName, bundle);
        }
        catch (ClassNotFoundException e) {
            type = ClassLoading.loadClass(typeName + "$PropertyEditor", bundle);
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            PropertyEditor propertyEditor = PropertyEditors.findEditor(type);
            return propertyEditor;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public static PropertyEditor getEditor(Class type) {
        PropertyEditor editor = PropertyEditors.findEditor(type);
        if (editor == null) {
            throw new PropertyEditorException("No property editor for type: " + type);
        }
        return editor;
    }

    public static void registerEditor(Class type, Class editorType) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (editorType == null) {
            throw new IllegalArgumentException("editorType is null");
        }
        PropertyEditorManager.registerEditor(type, editorType);
    }

    public static void registerEditor(String typeName, String editorName) throws ClassNotFoundException {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName is null");
        }
        if (editorName == null) {
            throw new IllegalArgumentException("editorTypeName is null");
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class type = ClassLoading.loadClass(typeName, loader);
        Class editor = ClassLoading.loadClass(editorName, loader);
        PropertyEditors.registerEditor(type, editor);
    }

    public static List getEditorSearchPath() {
        String[] paths = PropertyEditorManager.getEditorSearchPath();
        ArrayList<String> pathList = new ArrayList<String>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            pathList.add(paths[i]);
        }
        return pathList;
    }

    public static void setEditorSearchPath(List path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        String[] elements = path.toArray(new String[path.size()]);
        PropertyEditorManager.setEditorSearchPath(elements);
    }

    public static void appendEditorSearchPath(List newNames) {
        if (newNames == null) {
            throw new IllegalArgumentException("names is null");
        }
        if (newNames.isEmpty()) {
            return;
        }
        List currentPath = PropertyEditors.getEditorSearchPath();
        currentPath.addAll(newNames);
        PropertyEditors.setEditorSearchPath(currentPath);
    }

    public static void appendEditorSearchPath(String[] newNames) {
        if (newNames == null) {
            throw new IllegalArgumentException("names is null");
        }
        if (newNames.length != 0) {
            PropertyEditors.appendEditorSearchPath(Arrays.asList(newNames));
        }
    }

    public static void appendEditorSearchPath(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("name is null");
        }
        List currentPath = PropertyEditors.getEditorSearchPath();
        currentPath.add(newName);
        PropertyEditors.setEditorSearchPath(currentPath);
    }

    static {
        PropertyEditors.appendEditorSearchPath("org.apache.geronimo.common.propertyeditor");
        PropertyEditorManager.registerEditor(Boolean.class, BooleanEditor.class);
        PropertyEditorManager.registerEditor(Integer.class, IntegerEditor.class);
    }
}

