/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.jmx;

import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.kernel.DependencyManager;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.NoSuchAttributeException;
import org.apache.geronimo.kernel.NoSuchOperationException;
import org.apache.geronimo.kernel.lifecycle.LifecycleMonitor;
import org.apache.geronimo.kernel.proxy.ProxyManager;
import org.apache.geronimo.system.jmx.JMXProxyManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class KernelDelegate
implements Kernel {
    private final MBeanServerConnection mbeanServer;
    private final ProxyManager proxyManager;

    public KernelDelegate(MBeanServerConnection mbeanServer) {
        this.mbeanServer = mbeanServer;
        this.proxyManager = new JMXProxyManager(this);
    }

    @Override
    public Date getBootTime() {
        return (Date)this.getKernelAttribute("bootTime");
    }

    @Override
    public String getKernelName() {
        return (String)this.getKernelAttribute("kernelName");
    }

    @Override
    public Naming getNaming() {
        return (Naming)this.getKernelAttribute("naming");
    }

    @Override
    @Deprecated
    public Object getGBean(ObjectName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            return this.invokeKernel("getGBean", new Object[]{name}, new String[]{ObjectName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public Object getGBean(AbstractName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            return this.invokeKernel("getGBean", new Object[]{name}, new String[]{AbstractName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public Object getGBean(String shortName) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            return this.invokeKernel("getGBean", new Object[]{shortName}, new String[]{String.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public <T> T getGBean(Class<T> type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        Set<AbstractName> set = this.listGBeans(new AbstractNameQuery(type.getName()));
        Iterator<AbstractName> i$ = set.iterator();
        if (i$.hasNext()) {
            AbstractName name = i$.next();
            return this.proxyManager.createProxy(name, type);
        }
        throw new GBeanNotFoundException("No implementation found for type " + type.getName(), null, set);
    }

    @Override
    public <T> T getGBean(String shortName, Class<T> type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            return (T)this.invokeKernel("getGBean", new Object[]{shortName, type}, new String[]{String.class.getName(), Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void loadGBean(GBeanData gbeanData, BundleContext bundleContext) throws GBeanAlreadyExistsException {
        try {
            this.invokeKernel("loadGBean", new Object[]{gbeanData, bundleContext}, new String[]{GBeanData.class.getName(), ClassLoader.class.getName()});
        }
        catch (GBeanAlreadyExistsException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void startGBean(AbstractName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            this.invokeKernel("startGBean", new Object[]{name}, new String[]{AbstractName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void startGBean(String shortName) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            this.invokeKernel("startGBean", new Object[]{shortName}, new String[]{String.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void startGBean(Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            this.invokeKernel("startGBean", new Object[]{type}, new String[]{Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void startGBean(String shortName, Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            this.invokeKernel("startGBean", new Object[]{shortName, type}, new String[]{String.class.getName(), Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void startRecursiveGBean(AbstractName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            this.invokeKernel("startRecursiveGBean", new Object[]{name}, new String[]{AbstractName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void startRecursiveGBean(String shortName) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            this.invokeKernel("startRecursiveGBean", new Object[]{shortName}, new String[]{String.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void startRecursiveGBean(Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            this.invokeKernel("startRecursiveGBean", new Object[]{type}, new String[]{Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void startRecursiveGBean(String shortName, Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            this.invokeKernel("startRecursiveGBean", new Object[]{shortName, type}, new String[]{String.class.getName(), Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public boolean isRunning(AbstractName name) {
        try {
            return (Boolean)this.invokeKernel("isRunning", new Object[]{name}, new String[]{AbstractName.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public boolean isRunning(String shortName) {
        try {
            return (Boolean)this.invokeKernel("isRunning", new Object[]{shortName}, new String[]{String.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public boolean isRunning(Class type) {
        try {
            return (Boolean)this.invokeKernel("isRunning", new Object[]{type}, new String[]{Class.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public boolean isRunning(String shortName, Class type) {
        try {
            return (Boolean)this.invokeKernel("isRunning", new Object[]{shortName, type}, new String[]{String.class.getName(), Class.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void stopGBean(AbstractName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            this.invokeKernel("stopGBean", new Object[]{name}, new String[]{AbstractName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void stopGBean(String shortName) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            this.invokeKernel("stopGBean", new Object[]{shortName}, new String[]{String.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void stopGBean(Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            this.invokeKernel("stopGBean", new Object[]{type}, new String[]{Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void stopGBean(String shortName, Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            this.invokeKernel("stopGBean", new Object[]{shortName, type}, new String[]{String.class.getName(), Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void unloadGBean(AbstractName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            this.invokeKernel("unloadGBean", new Object[]{name}, new String[]{AbstractName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void unloadGBean(String shortName) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            this.invokeKernel("unloadGBean", new Object[]{shortName}, new String[]{String.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void unloadGBean(Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            this.invokeKernel("unloadGBean", new Object[]{type}, new String[]{Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void unloadGBean(String shortName, Class type) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        try {
            this.invokeKernel("unloadGBean", new Object[]{shortName, type}, new String[]{String.class.getName(), Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    @Deprecated
    public int getGBeanState(ObjectName name) throws GBeanNotFoundException {
        try {
            return (Integer)this.invokeKernel("getGBeanState", new Object[]{name}, new String[]{ObjectName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public int getGBeanState(AbstractName name) throws GBeanNotFoundException {
        try {
            return (Integer)this.invokeKernel("getGBeanState", new Object[]{name}, new String[]{AbstractName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public int getGBeanState(String shortName) throws GBeanNotFoundException {
        try {
            return (Integer)this.invokeKernel("getGBeanState", new Object[]{shortName}, new String[]{String.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public int getGBeanState(Class type) throws GBeanNotFoundException {
        try {
            return (Integer)this.invokeKernel("getGBeanState", new Object[]{type}, new String[]{Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public int getGBeanState(String shortName, Class type) throws GBeanNotFoundException {
        try {
            return (Integer)this.invokeKernel("getGBeanState", new Object[]{shortName, type}, new String[]{String.class.getName(), Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public long getGBeanStartTime(AbstractName name) throws GBeanNotFoundException {
        try {
            return (Long)this.invokeKernel("getGBeanStartTime", new Object[]{name}, new String[]{AbstractName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public long getGBeanStartTime(String shortName) throws GBeanNotFoundException {
        try {
            return (Long)this.invokeKernel("getGBeanStartTime", new Object[]{shortName}, new String[]{String.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public long getGBeanStartTime(Class type) throws GBeanNotFoundException {
        try {
            return (Long)this.invokeKernel("getGBeanStartTime", new Object[]{type}, new String[]{Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public long getGBeanStartTime(String shortName, Class type) throws GBeanNotFoundException {
        try {
            return (Long)this.invokeKernel("getGBeanStartTime", new Object[]{shortName, type}, new String[]{String.class.getName(), Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    @Deprecated
    public Object getAttribute(ObjectName objectName, String attributeName) throws Exception {
        return this.invokeKernel("getAttribute", new Object[]{objectName, attributeName}, new String[]{ObjectName.class.getName(), String.class.getName()});
    }

    @Override
    public Object getAttribute(AbstractName abstractName, String attributeName) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        return this.invokeKernel("getAttribute", new Object[]{abstractName, attributeName}, new String[]{AbstractName.class.getName(), String.class.getName()});
    }

    @Override
    public Object getAttribute(String shortName, String attributeName) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        return this.invokeKernel("getAttribute", new Object[]{shortName, attributeName}, new String[]{String.class.getName(), String.class.getName()});
    }

    @Override
    public Object getAttribute(Class type, String attributeName) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        return this.invokeKernel("getAttribute", new Object[]{type, attributeName}, new String[]{Class.class.getName(), String.class.getName()});
    }

    @Override
    public Object getAttribute(String shortName, Class type, String attributeName) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        return this.invokeKernel("getAttribute", new Object[]{shortName, type, attributeName}, new String[]{String.class.getName(), Class.class.getName(), String.class.getName()});
    }

    @Override
    public void setAttribute(AbstractName abstractName, String attributeName, Object attributeValue) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        this.invokeKernel("setAttribute", new Object[]{abstractName, attributeName, attributeValue}, new String[]{AbstractName.class.getName(), String.class.getName(), Object.class.getName()});
    }

    @Override
    public void setAttribute(String shortName, String attributeName, Object attributeValue) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        this.invokeKernel("setAttribute", new Object[]{shortName, attributeName, attributeValue}, new String[]{String.class.getName(), String.class.getName(), Object.class.getName()});
    }

    @Override
    public void setAttribute(Class type, String attributeName, Object attributeValue) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        this.invokeKernel("setAttribute", new Object[]{type, attributeName, attributeValue}, new String[]{Class.class.getName(), String.class.getName(), Object.class.getName()});
    }

    @Override
    public void setAttribute(String shortName, Class type, String attributeName, Object attributeValue) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        this.invokeKernel("setAttribute", new Object[]{shortName, type, attributeName, attributeValue}, new String[]{String.class.getName(), Class.class.getName(), String.class.getName(), Object.class.getName()});
    }

    @Override
    @Deprecated
    public Object invoke(ObjectName objectName, String methodName) throws Exception {
        return this.invokeKernel("invoke", new Object[]{objectName, methodName}, new String[]{ObjectName.class.getName(), String.class.getName()});
    }

    @Override
    public Object invoke(AbstractName abstractName, String methodName) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invokeKernel("invoke", new Object[]{abstractName, methodName}, new String[]{AbstractName.class.getName(), String.class.getName()});
    }

    @Override
    public Object invoke(String shortName, String methodName) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invokeKernel("invoke", new Object[]{shortName, methodName}, new String[]{String.class.getName(), String.class.getName()});
    }

    @Override
    public Object invoke(Class type, String methodName) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invokeKernel("invoke", new Object[]{type, methodName}, new String[]{Class.class.getName(), String.class.getName()});
    }

    @Override
    public Object invoke(String shortName, Class type, String methodName) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invokeKernel("invoke", new Object[]{shortName, type, methodName}, new String[]{String.class.getName(), Class.class.getName(), String.class.getName()});
    }

    @Override
    @Deprecated
    public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] types) throws Exception {
        return this.invokeKernel("invoke", new Object[]{objectName, methodName, args, types}, new String[]{ObjectName.class.getName(), String.class.getName(), Object[].class.getName(), String[].class.getName()});
    }

    @Override
    public String getStateReason(AbstractName abstractName) {
        try {
            return (String)this.invokeKernel("getStateReason", new Object[]{abstractName}, new String[]{AbstractName.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public Object invoke(AbstractName abstractName, String methodName, Object[] args, String[] types) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invokeKernel("invoke", new Object[]{abstractName, methodName, args, types}, new String[]{AbstractName.class.getName(), String.class.getName(), Object[].class.getName(), String[].class.getName()});
    }

    @Override
    public Object invoke(String shortName, String methodName, Object[] args, String[] types) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invokeKernel("invoke", new Object[]{shortName, methodName, args, types}, new String[]{String.class.getName(), String.class.getName(), Object[].class.getName(), String[].class.getName()});
    }

    @Override
    public Object invoke(Class type, String methodName, Object[] args, String[] types) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invokeKernel("invoke", new Object[]{type, methodName, args, types}, new String[]{Class.class.getName(), String.class.getName(), Object[].class.getName(), String[].class.getName()});
    }

    @Override
    public Object invoke(String shortName, Class type, String methodName, Object[] args, String[] types) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invokeKernel("invoke", new Object[]{shortName, type, methodName, args, types}, new String[]{String.class.getName(), Class.class.getName(), String.class.getName(), Object[].class.getName(), String[].class.getName()});
    }

    @Override
    public boolean isLoaded(AbstractName name) {
        try {
            return (Boolean)this.invokeKernel("isLoaded", new Object[]{name}, new String[]{AbstractName.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public boolean isLoaded(String shortName) {
        try {
            return (Boolean)this.invokeKernel("isLoaded", new Object[]{shortName}, new String[]{String.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public boolean isLoaded(Class type) {
        try {
            return (Boolean)this.invokeKernel("isLoaded", new Object[]{type}, new String[]{Class.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public boolean isLoaded(String shortName, Class type) {
        try {
            return (Boolean)this.invokeKernel("isLoaded", new Object[]{shortName, type}, new String[]{String.class.getName(), Class.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    @Deprecated
    public GBeanInfo getGBeanInfo(ObjectName name) throws GBeanNotFoundException {
        try {
            return (GBeanInfo)this.invokeKernel("getGBeanInfo", new Object[]{name}, new String[]{ObjectName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public GBeanInfo getGBeanInfo(AbstractName name) throws GBeanNotFoundException {
        try {
            return (GBeanInfo)this.invokeKernel("getGBeanInfo", new Object[]{name}, new String[]{AbstractName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public GBeanInfo getGBeanInfo(String shortName) throws GBeanNotFoundException {
        try {
            return (GBeanInfo)this.invokeKernel("getGBeanInfo", new Object[]{shortName}, new String[]{String.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public GBeanInfo getGBeanInfo(Class type) throws GBeanNotFoundException {
        try {
            return (GBeanInfo)this.invokeKernel("getGBeanInfo", new Object[]{type}, new String[]{Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public GBeanInfo getGBeanInfo(String shortName, Class type) throws GBeanNotFoundException {
        try {
            return (GBeanInfo)this.invokeKernel("getGBeanInfo", new Object[]{shortName, type}, new String[]{String.class.getName(), Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    @Deprecated
    public Set<AbstractName> listGBeans(ObjectName pattern) {
        try {
            return (Set)this.invokeKernel("listGBeans", new Object[]{pattern}, new String[]{ObjectName.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public Set<AbstractName> listGBeans(Set patterns) {
        try {
            return (Set)this.invokeKernel("listGBeans", new Object[]{patterns}, new String[]{Set.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void registerShutdownHook(Runnable hook) {
        try {
            this.invokeKernel("registerShutdownHook", new Object[]{hook}, new String[]{Runnable.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void unregisterShutdownHook(Runnable hook) {
        try {
            this.invokeKernel("unregisterShutdownHook", new Object[]{hook}, new String[]{Runnable.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.invokeKernel("shutdown", new Object[0], new String[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public Bundle getBundleFor(AbstractName name) throws GBeanNotFoundException {
        try {
            return (Bundle)this.invokeKernel("getBundleFor", new Object[]{name}, new String[]{AbstractName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public Bundle getBundleFor(String shortName) throws GBeanNotFoundException {
        try {
            return (Bundle)this.invokeKernel("getBundleFor", new Object[]{shortName}, new String[]{String.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public Bundle getBundleFor(Class type) throws GBeanNotFoundException {
        try {
            return (Bundle)this.invokeKernel("getBundleFor", new Object[]{type}, new String[]{Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public Bundle getBundleFor(String shortName, Class type) throws GBeanNotFoundException {
        try {
            return (Bundle)this.invokeKernel("getBundleFor", new Object[]{shortName, type}, new String[]{String.class.getName(), Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public GBeanData getGBeanData(AbstractName name) throws GBeanNotFoundException, InternalKernelException {
        try {
            return (GBeanData)this.invokeKernel("getGBeanData", new Object[]{name}, new String[]{AbstractName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public GBeanData getGBeanData(String shortName) throws GBeanNotFoundException, InternalKernelException {
        try {
            return (GBeanData)this.invokeKernel("getGBeanData", new Object[]{shortName}, new String[]{String.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public GBeanData getGBeanData(Class type) throws GBeanNotFoundException, InternalKernelException {
        try {
            return (GBeanData)this.invokeKernel("getGBeanData", new Object[]{type}, new String[]{Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public GBeanData getGBeanData(String shortName, Class type) throws GBeanNotFoundException, InternalKernelException {
        try {
            return (GBeanData)this.invokeKernel("getGBeanData", new Object[]{shortName, type}, new String[]{String.class.getName(), Class.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public AbstractName getAbstractNameFor(Object service) {
        AbstractName name = this.proxyManager.getProxyTarget(service);
        if (name != null) {
            return name;
        }
        try {
            return (AbstractName)this.invokeKernel("getAbstractNameFor", new Object[]{service}, new String[]{Object.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public String getShortNameFor(Object service) {
        AbstractName name = this.getAbstractNameFor(service);
        return (String)name.getName().get("name");
    }

    @Override
    public boolean isRunning() {
        return (Boolean)this.getKernelAttribute("running");
    }

    @Override
    public Set<AbstractName> listGBeans(AbstractNameQuery query) {
        try {
            return (Set)this.invokeKernel("listGBeans", new Object[]{query}, new String[]{AbstractNameQuery.class.getName()});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalKernelException(e);
        }
    }

    @Override
    public DependencyManager getDependencyManager() {
        throw new UnsupportedOperationException("Dependency manager is not accessable by way of a remote connection");
    }

    @Override
    public LifecycleMonitor getLifecycleMonitor() {
        throw new UnsupportedOperationException("Lifecycle monitor is not accessable by way of a remote connection");
    }

    @Override
    public ProxyManager getProxyManager() {
        return this.proxyManager;
    }

    @Override
    public void boot() throws Exception {
        throw new UnsupportedOperationException("A remote kernel can not be booted");
    }

    private Object getKernelAttribute(String attributeName) {
        try {
            return this.mbeanServer.getAttribute(Kernel.KERNEL, attributeName);
        }
        catch (Exception e) {
            Throwable cause = this.unwrapJMException(e);
            if (cause instanceof InstanceNotFoundException) {
                throw new InternalKernelException("Kernel is not loaded", cause);
            }
            if (cause instanceof AttributeNotFoundException) {
                throw new InternalKernelException("KernelDelegate is out of synch with Kernel", cause);
            }
            throw new InternalKernelException(cause);
        }
    }

    private Object invokeKernel(String methodName, Object[] args, String[] types) throws Exception {
        if (args != null && types != null && args.length != types.length) {
            throw new IllegalArgumentException("Call to " + methodName + " has " + args.length + " arguments but " + types.length + " argument classes!");
        }
        try {
            return this.mbeanServer.invoke(Kernel.KERNEL, methodName, args, types);
        }
        catch (Exception e) {
            Throwable cause = this.unwrapJMException(e);
            if (cause instanceof InstanceNotFoundException) {
                throw new InternalKernelException("Kernel is not loaded", cause);
            }
            if (cause instanceof NoSuchMethodException) {
                StringBuffer buf = new StringBuffer("KernelDelegate is out of synch with Kernel on ");
                buf.append(methodName).append("(");
                if (types != null) {
                    for (int i = 0; i < types.length; ++i) {
                        String type = types[i];
                        if (i > 0) {
                            buf.append(",");
                        }
                        buf.append(type);
                    }
                }
                buf.append(")");
                throw new InternalKernelException(buf.toString());
            }
            if (cause instanceof JMException) {
                throw new InternalKernelException(cause);
            }
            if (cause instanceof JMRuntimeException) {
                throw new InternalKernelException(cause);
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new InternalKernelException("Unknown throwable", cause);
        }
    }

    private Throwable unwrapJMException(Throwable cause) {
        while ((cause instanceof JMException || cause instanceof JMRuntimeException) && cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }
}

