/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.controllers;

import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.internal.exceptions.EntityExistsException;
import org.apache.geode.management.internal.exceptions.EntityNotFoundException;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ManagementControllerAdvice {
    private static final Logger logger = LogService.getLogger();

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ClusterManagementResult> internalError(Exception e) {
        logger.error(e.getMessage(), (Throwable)e);
        return new ResponseEntity((Object)new ClusterManagementResult(ClusterManagementResult.StatusCode.ERROR, e.getMessage()), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={EntityExistsException.class})
    public ResponseEntity<ClusterManagementResult> entityExists(Exception e) {
        return new ResponseEntity((Object)new ClusterManagementResult(ClusterManagementResult.StatusCode.ENTITY_EXISTS, e.getMessage()), HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={EntityNotFoundException.class})
    public ResponseEntity<ClusterManagementResult> entityNotFound(Exception e) {
        return new ResponseEntity((Object)new ClusterManagementResult(ClusterManagementResult.StatusCode.ENTITY_NOT_FOUND, e.getMessage()), HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={AuthenticationFailedException.class, AuthenticationException.class})
    public ResponseEntity<ClusterManagementResult> unauthorized(Exception e) {
        return new ResponseEntity((Object)new ClusterManagementResult(ClusterManagementResult.StatusCode.UNAUTHENTICATED, e.getMessage()), HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={NotAuthorizedException.class, SecurityException.class})
    public ResponseEntity<ClusterManagementResult> forbidden(Exception e) {
        return new ResponseEntity((Object)new ClusterManagementResult(ClusterManagementResult.StatusCode.UNAUTHORIZED, e.getMessage()), HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<ClusterManagementResult> badRequest(IllegalArgumentException e) {
        return new ResponseEntity((Object)new ClusterManagementResult(ClusterManagementResult.StatusCode.ILLEGAL_ARGUMENT, e.getMessage()), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<ClusterManagementResult> handleException(AccessDeniedException cause) {
        return new ResponseEntity((Object)new ClusterManagementResult(ClusterManagementResult.StatusCode.UNAUTHORIZED, cause.getMessage()), HttpStatus.FORBIDDEN);
    }
}

