/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.swagger;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import java.util.EventListener;
import java.util.HashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.apache.geode.management.internal.rest.security.GeodeAuthenticationProvider;
import org.springdoc.core.GroupedOpenApi;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SpringDocConfiguration;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.core.SwaggerUiOAuthProperties;
import org.springdoc.webmvc.core.MultipleOpenApiSupportConfiguration;
import org.springdoc.webmvc.core.SpringDocWebMvcConfiguration;
import org.springdoc.webmvc.ui.SwaggerUiHome;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@PropertySource(value={"classpath:swagger-management.properties"})
@EnableWebMvc
@Configuration(value="swaggerConfigManagement")
@ComponentScan(basePackages={"org.springdoc"}, excludeFilters={@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, classes={SwaggerUiHome.class})})
public class SwaggerConfig
implements WebApplicationInitializer {
    @Autowired
    private GeodeAuthenticationProvider authProvider;

    public void onStartup(ServletContext servletContext) throws ServletException {
        AnnotationConfigWebApplicationContext context = this.getContext();
        servletContext.addListener((EventListener)new ContextLoaderListener((WebApplicationContext)context));
        ServletRegistration.Dynamic dispatcher = servletContext.addServlet("geode", (Servlet)new DispatcherServlet((WebApplicationContext)context));
        dispatcher.setLoadOnStartup(1);
        dispatcher.addMapping(new String[]{"/*"});
    }

    private AnnotationConfigWebApplicationContext getContext() {
        AnnotationConfigWebApplicationContext context = new AnnotationConfigWebApplicationContext();
        context.scan(new String[]{"org.apache.geode.management.internal.rest"});
        context.register(new Class[]{this.getClass(), org.springdoc.webmvc.ui.SwaggerConfig.class, SwaggerUiConfigProperties.class, SwaggerUiOAuthProperties.class, SpringDocWebMvcConfiguration.class, MultipleOpenApiSupportConfiguration.class, SpringDocConfiguration.class, SpringDocConfigProperties.class, JacksonAutoConfiguration.class});
        return context;
    }

    @Bean
    public GroupedOpenApi api() {
        return GroupedOpenApi.builder().group("management-api").pathsToMatch(new String[]{"/**"}).build();
    }

    @Bean
    public OpenAPI apiInfo() {
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("authTokenEnabled", Boolean.toString(this.authProvider.isAuthTokenEnabled()));
        return new OpenAPI().info(new Info().title("Apache Geode Management REST API").description("REST API to manage Geode. This is experimental. All request/response formats are subject to change.").version("v1").extensions(extensions).termsOfService("http://www.apache.org/licenses/").license(new License().name("Apache License, version 2.0").url("http://www.apache.org/licenses/")).contact(new Contact().name("the Apache Geode Community").url("http://geode.apache.org").email("user@geode.apache.org")));
    }
}

