/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import org.apache.geode.management.api.ClusterManagementGetResult;
import org.apache.geode.management.api.ClusterManagementRealizationResult;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.Pdx;
import org.apache.geode.management.internal.rest.controllers.AbstractManagementController;
import org.apache.geode.management.runtime.PdxInfo;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="pdxManagement")
@RequestMapping(value={"/v1"})
public class PdxManagementController
extends AbstractManagementController {
    @Operation(summary="configure pdx")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Bad request."), @ApiResponse(responseCode="409", description="Pdx already configured."), @ApiResponse(responseCode="500", description="Internal error.")})
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'MANAGE')")
    @PostMapping(value={"/configurations/pdx"})
    public ResponseEntity<ClusterManagementResult> configurePdx(@RequestBody Pdx pdxType) {
        ClusterManagementRealizationResult result = this.clusterManagementService.create((AbstractConfiguration)pdxType);
        return new ResponseEntity((Object)result, HttpStatus.CREATED);
    }

    @Operation(summary="get pdx")
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ')")
    @GetMapping(value={"/configurations/pdx"})
    public ClusterManagementGetResult<Pdx, PdxInfo> getPDX() {
        return this.clusterManagementService.get((AbstractConfiguration)new Pdx());
    }

    @Operation(summary="update pdx")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Bad request."), @ApiResponse(responseCode="500", description="Internal error.")})
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'MANAGE')")
    @PutMapping(value={"/configurations/pdx"})
    public ResponseEntity<ClusterManagementResult> updatePdx(@RequestBody Pdx pdxType) {
        ClusterManagementRealizationResult result = this.clusterManagementService.update((AbstractConfiguration)pdxType);
        return new ResponseEntity((Object)result, HttpStatus.CREATED);
    }

    @Operation(summary="delete pdx")
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'MANAGE')")
    @DeleteMapping(value={"/configurations/pdx"})
    public ClusterManagementResult deletePDX() {
        return this.clusterManagementService.delete((AbstractConfiguration)new Pdx());
    }
}

