/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.controllers;

import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.management.api.ClusterManagementException;
import org.apache.geode.management.api.ClusterManagementListResult;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.configuration.MemberConfig;
import org.apache.geode.management.internal.rest.controllers.AbstractManagementController;
import org.apache.geode.management.runtime.MemberInformation;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="members")
@RequestMapping(value={"/experimental"})
public class MemberManagementController
extends AbstractManagementController {
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/members/{id}"})
    public ResponseEntity<ClusterManagementListResult<MemberConfig, MemberInformation>> getMember(@PathVariable(name="id") String id) {
        MemberConfig config = new MemberConfig();
        config.setId(id);
        ClusterManagementListResult result = this.clusterManagementService.list((CacheElement)config);
        if (result.getRuntimeResult().size() == 0) {
            throw new ClusterManagementException(new ClusterManagementResult(ClusterManagementResult.StatusCode.ENTITY_NOT_FOUND, "Member '" + config.getId() + "' does not exist."));
        }
        return new ResponseEntity((Object)result, result.isSuccessful() ? HttpStatus.OK : HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/members"})
    public ResponseEntity<ClusterManagementListResult<MemberConfig, MemberInformation>> listMembers(@RequestParam(required=false) String id, @RequestParam(required=false) String group) {
        ClusterManagementListResult result;
        MemberConfig filter = new MemberConfig();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            filter.setId(id);
        }
        return new ResponseEntity((Object)result, (result = this.clusterManagementService.list((CacheElement)filter)).isSuccessful() ? HttpStatus.OK : HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

