/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.rest.controllers;

import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.GatewayReceiverConfig;
import org.apache.geode.management.api.ClusterManagementListResult;
import org.apache.geode.management.api.ClusterManagementRealizationResult;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.internal.rest.controllers.AbstractManagementController;
import org.apache.geode.management.runtime.GatewayReceiverInfo;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="gatewayManagement")
@RequestMapping(value={"/experimental"})
public class GatewayManagementController
extends AbstractManagementController {
    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/gateways/receivers"})
    @ResponseBody
    public ClusterManagementListResult<GatewayReceiverConfig, GatewayReceiverInfo> listGatewayReceivers(@RequestParam(required=false) String group) {
        GatewayReceiverConfig filter = new GatewayReceiverConfig();
        if (StringUtils.isNotBlank((CharSequence)group)) {
            filter.setGroup(group);
        }
        return this.clusterManagementService.list((CacheElement)filter);
    }

    @PreAuthorize(value="@securityService.authorize('CLUSTER', 'MANAGE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/gateways/receivers"})
    public ResponseEntity<ClusterManagementResult> createGatewayReceiver(@RequestBody GatewayReceiverConfig gatewayReceiverConfig) {
        ClusterManagementRealizationResult result;
        return new ResponseEntity((Object)result, (result = this.clusterManagementService.create((CacheElement)gatewayReceiverConfig)).isSuccessful() ? HttpStatus.CREATED : HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

