/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.rest.internal.web.util;

import org.apache.geode.internal.lang.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class NumberUtils {
    public static boolean isNumeric(String value) {
        value = String.valueOf(value).trim();
        for (char chr : value.toCharArray()) {
            if (Character.isDigit(chr)) continue;
            return false;
        }
        return true;
    }

    public static Long longValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return NumberUtils.parseLong(String.valueOf(value));
    }

    public static Long parseLong(String value) {
        try {
            return Long.parseLong(StringUtils.trimAllWhitespace((String)value));
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }

    public static boolean isPrimitiveOrWrapper(Class<?> klass) {
        return Byte.class.equals(klass) || Byte.TYPE.equals(klass) || Short.class.equals(klass) || Short.TYPE.equals(klass) || Integer.class.equals(klass) || Integer.TYPE.equals(klass) || Long.class.equals(klass) || Long.TYPE.equals(klass) || Float.class.equals(klass) || Float.TYPE.equals(klass) || Double.class.equals(klass) || Double.TYPE.equals(klass) || Boolean.class.equals(klass) || Boolean.TYPE.equals(klass) || String.class.equals(klass);
    }

    public static boolean isPrimitiveOrObject(String type) {
        return "byte".equalsIgnoreCase(type) || "short".equalsIgnoreCase(type) || "int".equalsIgnoreCase(type) || "long".equalsIgnoreCase(type) || "float".equalsIgnoreCase(type) || "double".equalsIgnoreCase(type) || "boolean".equalsIgnoreCase(type) || "string".equalsIgnoreCase(type);
    }

    public static boolean isValuePrimitiveType(Object value) {
        return Byte.class.equals((Object)ClassUtils.getClass((Object)value)) || Short.class.equals((Object)ClassUtils.getClass((Object)value)) || Integer.class.equals((Object)ClassUtils.getClass((Object)value)) || Long.class.equals((Object)ClassUtils.getClass((Object)value)) || Float.class.equals((Object)ClassUtils.getClass((Object)value)) || Double.class.equals((Object)ClassUtils.getClass((Object)value)) || Boolean.class.equals((Object)ClassUtils.getClass((Object)value)) || String.class.equals((Object)ClassUtils.getClass((Object)value));
    }
}

