/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.locator.wan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.cache.client.internal.locator.wan.LocatorHelper;
import org.apache.geode.cache.client.internal.locator.wan.LocatorJoinMessage;
import org.apache.geode.cache.client.internal.locator.wan.LocatorMembershipListener;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorJoinRequest;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorJoinResponse;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorPingRequest;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorPingResponse;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorRequest;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorResponse;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.internal.CopyOnWriteHashSet;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class LocatorMembershipListenerImpl
implements LocatorMembershipListener {
    private ConcurrentMap<Integer, Set<DistributionLocatorId>> allLocatorsInfo = new ConcurrentHashMap<Integer, Set<DistributionLocatorId>>();
    private ConcurrentMap<Integer, Set<String>> allServerLocatorsInfo = new ConcurrentHashMap<Integer, Set<String>>();
    private static final Logger logger = LogService.getLogger();
    private DistributionConfig config;
    private TcpClient tcpClient = new TcpClient();
    private int port;

    public void setPort(int port) {
        this.port = port;
    }

    public void setConfig(DistributionConfig config) {
        this.config = config;
    }

    public void locatorJoined(final int distributedSystemId, final DistributionLocatorId locator, final DistributionLocatorId sourceLocator) {
        Thread distributeLocator = new Thread(new Runnable(){

            @Override
            public void run() {
                ConcurrentMap<Integer, Set<DistributionLocatorId>> remoteLocators = LocatorMembershipListenerImpl.this.getAllLocatorsInfo();
                ArrayList<DistributionLocatorId> locatorsToRemove = new ArrayList<DistributionLocatorId>();
                String localLocator = LocatorMembershipListenerImpl.this.config.getStartLocator();
                DistributionLocatorId localLocatorId = null;
                localLocatorId = localLocator.equals("") ? new DistributionLocatorId(LocatorMembershipListenerImpl.this.port, LocatorMembershipListenerImpl.this.config.getBindAddress()) : new DistributionLocatorId(localLocator);
                locatorsToRemove.add(localLocatorId);
                locatorsToRemove.add(locator);
                locatorsToRemove.add(sourceLocator);
                HashMap localCopy = new HashMap();
                for (Map.Entry entry : remoteLocators.entrySet()) {
                    CopyOnWriteHashSet value = new CopyOnWriteHashSet((Set)entry.getValue());
                    localCopy.put(entry.getKey(), value);
                }
                for (Map.Entry entry : localCopy.entrySet()) {
                    for (DistributionLocatorId removeLocId : locatorsToRemove) {
                        if (!((Set)entry.getValue()).contains(removeLocId)) continue;
                        ((Set)entry.getValue()).remove(removeLocId);
                    }
                    for (DistributionLocatorId value : (Set)entry.getValue()) {
                        block8: {
                            try {
                                LocatorMembershipListenerImpl.this.tcpClient.requestToServer(value.getHost(), (Object)new LocatorJoinMessage(distributedSystemId, locator, localLocatorId, ""), 1000, false);
                            }
                            catch (Exception e) {
                                if (!logger.isDebugEnabled()) break block8;
                                logger.debug("Locator Membership listener could not exchange locator information {}:{} with {}:{}", new Object[]{locator.getHostName(), locator.getPort(), value.getHostName(), value.getPort()});
                            }
                        }
                        try {
                            LocatorMembershipListenerImpl.this.tcpClient.requestToServer(locator.getHost(), (Object)new LocatorJoinMessage((Integer)entry.getKey(), value, localLocatorId, ""), 1000, false);
                        }
                        catch (Exception e) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Locator Membership listener could not exchange locator information {}:{} with {}:{}", new Object[]{value.getHostName(), value.getPort(), locator.getHostName(), locator.getPort()});
                        }
                    }
                }
            }
        });
        distributeLocator.setDaemon(true);
        distributeLocator.start();
    }

    public Object handleRequest(Object request) {
        Object response = null;
        if (request instanceof RemoteLocatorJoinRequest) {
            response = this.updateAllLocatorInfo((RemoteLocatorJoinRequest)request);
        } else if (request instanceof LocatorJoinMessage) {
            response = this.informAboutRemoteLocators((LocatorJoinMessage)((Object)request));
        } else if (request instanceof RemoteLocatorPingRequest) {
            response = this.getPingResponse((RemoteLocatorPingRequest)request);
        } else if (request instanceof RemoteLocatorRequest) {
            response = this.getRemoteLocators((RemoteLocatorRequest)request);
        }
        return response;
    }

    private synchronized Object updateAllLocatorInfo(RemoteLocatorJoinRequest request) {
        int distributedSystemId = request.getDistributedSystemId();
        DistributionLocatorId locator = request.getLocator();
        LocatorHelper.addLocator(distributedSystemId, locator, this, null);
        return new RemoteLocatorJoinResponse(this.getAllLocatorsInfo());
    }

    private Object getPingResponse(RemoteLocatorPingRequest request) {
        return new RemoteLocatorPingResponse();
    }

    private Object informAboutRemoteLocators(LocatorJoinMessage request) {
        int distributedSystemId = request.getDistributedSystemId();
        DistributionLocatorId locator = request.getLocator();
        DistributionLocatorId sourceLocatorId = request.getSourceLocator();
        LocatorHelper.addLocator(distributedSystemId, locator, this, sourceLocatorId);
        return null;
    }

    private Object getRemoteLocators(RemoteLocatorRequest request) {
        int dsId = request.getDsId();
        Set<String> locators = this.getRemoteLocatorInfo(dsId);
        return new RemoteLocatorResponse(locators);
    }

    public Set<String> getRemoteLocatorInfo(int dsId) {
        return (Set)this.allServerLocatorsInfo.get(dsId);
    }

    public ConcurrentMap<Integer, Set<DistributionLocatorId>> getAllLocatorsInfo() {
        return this.allLocatorsInfo;
    }

    public ConcurrentMap<Integer, Set<String>> getAllServerLocatorsInfo() {
        return this.allServerLocatorsInfo;
    }

    public void clearLocatorInfo() {
        this.allLocatorsInfo.clear();
        this.allServerLocatorsInfo.clear();
    }
}

