/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.internal.AvailablePort;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheServer;
import org.apache.geode.internal.cache.wan.GatewayReceiverException;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class GatewayReceiverImpl
implements GatewayReceiver {
    private static final Logger logger = LogService.getLogger();
    private final InternalCache cache;
    private final String hostnameForSenders;
    private final int startPort;
    private final int endPort;
    private final int maximumTimeBetweenPings;
    private final int socketBufferSize;
    private final boolean manualStart;
    private final List<GatewayTransportFilter> gatewayTransportFilters;
    private final String bindAddress;
    private final Function<Integer, Boolean> isPortAvailableFunction;
    private final Function<PortRange, Integer> getRandomAvailablePortInRangeFunction;
    private volatile int port;
    private volatile InternalCacheServer receiverServer;

    GatewayReceiverImpl(InternalCache cache, int startPort, int endPort, int maximumTimeBetweenPings, int socketBufferSize, String bindAddress, List<GatewayTransportFilter> gatewayTransportFilters, String hostnameForSenders, boolean manualStart) {
        this(cache, startPort, endPort, maximumTimeBetweenPings, socketBufferSize, bindAddress, gatewayTransportFilters, hostnameForSenders, manualStart, port -> AvailablePort.isPortAvailable((int)port, (int)0, (InetAddress)AvailablePort.getAddress((int)0)), portRange -> AvailablePort.getRandomAvailablePortInRange((int)((PortRange)portRange).startPort, (int)((PortRange)portRange).endPort, (int)0));
    }

    @VisibleForTesting
    GatewayReceiverImpl(InternalCache cache, int startPort, int endPort, int maximumTimeBetweenPings, int socketBufferSize, String bindAddress, List<GatewayTransportFilter> gatewayTransportFilters, String hostnameForSenders, boolean manualStart, boolean isPortAvailableResult, int getRandomAvailablePortInRangeResult) {
        this(cache, startPort, endPort, maximumTimeBetweenPings, socketBufferSize, bindAddress, gatewayTransportFilters, hostnameForSenders, manualStart, port -> isPortAvailableResult, portRange -> getRandomAvailablePortInRangeResult);
    }

    private GatewayReceiverImpl(InternalCache cache, int startPort, int endPort, int maximumTimeBetweenPings, int socketBufferSize, String bindAddress, List<GatewayTransportFilter> gatewayTransportFilters, String hostnameForSenders, boolean manualStart, Function<Integer, Boolean> isPortAvailableFunction, Function<PortRange, Integer> getRandomAvailablePortInRangeFunction) {
        this.cache = cache;
        this.hostnameForSenders = hostnameForSenders;
        this.startPort = startPort;
        this.endPort = endPort;
        this.maximumTimeBetweenPings = maximumTimeBetweenPings;
        this.socketBufferSize = socketBufferSize;
        this.bindAddress = bindAddress;
        this.gatewayTransportFilters = gatewayTransportFilters;
        this.manualStart = manualStart;
        this.isPortAvailableFunction = isPortAvailableFunction;
        this.getRandomAvailablePortInRangeFunction = getRandomAvailablePortInRangeFunction;
    }

    public String getHostnameForSenders() {
        return this.hostnameForSenders;
    }

    public String getHost() {
        if (this.receiverServer != null) {
            return this.receiverServer.getExternalAddress();
        }
        if (this.hostnameForSenders != null && !this.hostnameForSenders.isEmpty()) {
            return this.hostnameForSenders;
        }
        if (this.bindAddress != null && !this.bindAddress.isEmpty()) {
            return this.bindAddress;
        }
        try {
            return SocketCreator.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Could not get host name", e);
        }
    }

    public List<GatewayTransportFilter> getGatewayTransportFilters() {
        return this.gatewayTransportFilters;
    }

    public int getMaximumTimeBetweenPings() {
        return this.maximumTimeBetweenPings;
    }

    public int getPort() {
        return this.port;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public int getEndPort() {
        return this.endPort;
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public boolean isManualStart() {
        return this.manualStart;
    }

    public CacheServer getServer() {
        return this.receiverServer;
    }

    private boolean tryToStart(int port) {
        if (!this.isPortAvailableFunction.apply(port).booleanValue()) {
            return false;
        }
        InternalCacheServer cacheServer = this.receiverServer;
        cacheServer.setPort(port);
        cacheServer.setSocketBufferSize(this.socketBufferSize);
        cacheServer.setMaximumTimeBetweenPings(this.maximumTimeBetweenPings);
        if (this.hostnameForSenders != null && !this.hostnameForSenders.isEmpty()) {
            cacheServer.setHostnameForClients(this.hostnameForSenders);
        }
        cacheServer.setBindAddress(this.bindAddress);
        cacheServer.setGroups(new String[]{"__recv__group"});
        try {
            cacheServer.start();
            this.port = port;
            return true;
        }
        catch (IOException e) {
            logger.info("Failed to create server socket on {}[{}]", (Object)this.bindAddress, (Object)port);
            return false;
        }
    }

    public void start() {
        int loopStartPort;
        if (this.receiverServer == null) {
            this.receiverServer = this.cache.addGatewayReceiverServer((GatewayReceiver)this);
        }
        if (this.receiverServer.isRunning()) {
            logger.warn("Gateway Receiver is already running");
            return;
        }
        int port = loopStartPort = this.getPortToStart();
        while (!this.tryToStart(port)) {
            port = port == this.endPort && this.startPort != this.endPort ? this.startPort : ++port;
            if (port != loopStartPort && port <= this.endPort) continue;
            throw new GatewayReceiverException("No available free port found in the given range (" + this.startPort + "-" + this.endPort + ")");
        }
        logger.info("The GatewayReceiver started on port : {}", (Object)this.port);
        InternalDistributedSystem system = this.cache.getInternalDistributedSystem();
        system.handleResourceEvent(ResourceEvent.GATEWAYRECEIVER_START, (Object)this);
    }

    private int getPortToStart() {
        int randomPort = this.startPort == this.endPort ? this.startPort : this.getRandomAvailablePortInRangeFunction.apply(new PortRange(this.startPort, this.endPort));
        return randomPort;
    }

    public void stop() {
        if (!this.isRunning()) {
            throw new GatewayReceiverException("Gateway Receiver is not running");
        }
        this.receiverServer.stop();
    }

    public void destroy() {
        logger.info("Destroying Gateway Receiver: {}", (Object)this);
        if (this.receiverServer == null) {
            this.cache.removeGatewayReceiver((GatewayReceiver)this);
        } else {
            if (this.receiverServer.isRunning()) {
                throw new GatewayReceiverException("Gateway Receiver is running and needs to be stopped first");
            }
            this.cache.removeGatewayReceiver((GatewayReceiver)this);
            this.cache.removeGatewayReceiverServer(this.receiverServer);
        }
        InternalDistributedSystem system = this.cache.getInternalDistributedSystem();
        system.handleResourceEvent(ResourceEvent.GATEWAYRECEIVER_DESTROY, (Object)this);
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public boolean isRunning() {
        if (this.receiverServer != null) {
            return this.receiverServer.isRunning();
        }
        return false;
    }

    public String toString() {
        return "Gateway Receiver" + "@" + Integer.toHexString(this.hashCode()) + "'; port=" + this.getPort() + "; bindAddress=" + this.getBindAddress() + "'; hostnameForSenders=" + this.getHostnameForSenders() + "; maximumTimeBetweenPings=" + this.getMaximumTimeBetweenPings() + "; socketBufferSize=" + this.getSocketBufferSize() + "; isManualStart=" + this.isManualStart() + "; group=" + Arrays.toString(new String[]{"__recv__group"}) + "]";
    }

    private static class PortRange {
        private final int startPort;
        private final int endPort;

        private PortRange(int startPort, int endPort) {
            this.startPort = startPort;
            this.endPort = endPort;
        }
    }
}

