/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.locator.wan;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.cache.client.internal.locator.wan.LocatorHelper;
import org.apache.geode.cache.client.internal.locator.wan.LocatorMembershipListener;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorJoinRequest;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorJoinResponse;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorPingRequest;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorPingResponse;
import org.apache.geode.distributed.internal.WanLocatorDiscoverer;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.tcp.ConnectionException;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class LocatorDiscovery {
    private static final Logger logger = LogService.getLogger();
    private WanLocatorDiscoverer discoverer;
    private DistributionLocatorId locatorId;
    private LocatorMembershipListener locatorListener;
    RemoteLocatorJoinRequest request;
    TcpClient locatorClient;
    public static final int WAN_LOCATOR_CONNECTION_RETRY_ATTEMPT = Integer.getInteger("WANLocator.CONNECTION_RETRY_ATTEMPT", 50000);
    public static final int WAN_LOCATOR_CONNECTION_INTERVAL = Integer.getInteger("WANLocator.CONNECTION_INTERVAL", 10000);
    public static final int WAN_LOCATOR_PING_INTERVAL = Integer.getInteger("WANLocator.PING_INTERVAL", 10000);
    private final ConcurrentHashMap<DistributionLocatorId, long[]> failureLogInterval = new ConcurrentHashMap();
    private static final int FAILURE_MAP_MAXSIZE = Integer.getInteger("gemfire.GatewaySender.FAILURE_MAP_MAXSIZE", 1000000);
    private static final int FAILURE_LOG_MAX_INTERVAL = Integer.getInteger("gemfire.LocatorDiscovery.FAILURE_LOG_MAX_INTERVAL", 300000);

    public LocatorDiscovery(WanLocatorDiscoverer discoverer, DistributionLocatorId locator, RemoteLocatorJoinRequest request, LocatorMembershipListener locatorListener) {
        this.discoverer = discoverer;
        this.locatorId = locator;
        this.request = request;
        this.locatorListener = locatorListener;
        this.locatorClient = new TcpClient();
    }

    public boolean skipFailureLogging(DistributionLocatorId locatorId) {
        boolean skipLogging = false;
        if (this.failureLogInterval.size() < FAILURE_MAP_MAXSIZE) {
            long[] logInterval = this.failureLogInterval.get(locatorId);
            if (logInterval == null) {
                logInterval = this.failureLogInterval.putIfAbsent(locatorId, new long[]{System.currentTimeMillis(), 1000L});
            }
            if (logInterval != null) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - logInterval[0] < logInterval[1]) {
                    skipLogging = true;
                } else {
                    logInterval[0] = currentTime;
                    if (logInterval[1] <= (long)(FAILURE_LOG_MAX_INTERVAL / 2)) {
                        logInterval[1] = logInterval[1] * 2L;
                    }
                }
            }
        }
        return skipLogging;
    }

    private WanLocatorDiscoverer getDiscoverer() {
        return this.discoverer;
    }

    private void exchangeLocalLocators() {
        int retryAttempt = 1;
        while (!this.getDiscoverer().isStopped()) {
            try {
                RemoteLocatorJoinResponse response = (RemoteLocatorJoinResponse)this.locatorClient.requestToServer(this.locatorId.getHost(), (Object)this.request, WanLocatorDiscoverer.WAN_LOCATOR_CONNECTION_TIMEOUT, true);
                if (response == null) continue;
                LocatorHelper.addExchangedLocators(response.getLocators(), this.locatorListener);
                logger.info("Locator discovery task exchanged locator information {} with {}: {}.", new Object[]{this.request.getLocator(), this.locatorId, response.getLocators()});
                break;
            }
            catch (IOException ioe) {
                if (retryAttempt == WAN_LOCATOR_CONNECTION_RETRY_ATTEMPT) {
                    ConnectionException coe = new ConnectionException("Not able to connect to local locator after " + WAN_LOCATOR_CONNECTION_RETRY_ATTEMPT + " retry attempts", (Throwable)ioe);
                    logger.fatal(String.format("Locator discovery task could not exchange locator information %s with %s after %s retry attempts.", this.request.getLocator(), this.locatorId, retryAttempt), (Throwable)coe);
                    break;
                }
                if (this.skipFailureLogging(this.locatorId)) {
                    logger.warn("Locator discovery task could not exchange locator information {} with {} after {} retry attempts. Retrying in {} ms.", new Object[]{this.request.getLocator(), this.locatorId, retryAttempt, WAN_LOCATOR_CONNECTION_INTERVAL});
                }
                try {
                    Thread.sleep(WAN_LOCATOR_CONNECTION_INTERVAL);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ++retryAttempt;
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.fatal("Locator discovery task encountred unexpected exception", (Throwable)classNotFoundException);
                break;
            }
        }
    }

    public void exchangeRemoteLocators() {
        int retryAttempt = 1;
        DistributionLocatorId remoteLocator = this.locatorId;
        block6: while (!this.getDiscoverer().isStopped()) {
            try {
                RemoteLocatorJoinResponse response = (RemoteLocatorJoinResponse)this.locatorClient.requestToServer(remoteLocator.getHost(), (Object)this.request, WanLocatorDiscoverer.WAN_LOCATOR_CONNECTION_TIMEOUT, true);
                if (response == null) continue;
                LocatorHelper.addExchangedLocators(response.getLocators(), this.locatorListener);
                logger.info("Locator discovery task exchanged locator information {} with {}: {}.", new Object[]{this.request.getLocator(), this.locatorId, response.getLocators()});
                RemoteLocatorPingRequest pingRequest = new RemoteLocatorPingRequest("");
                while (true) {
                    Thread.sleep(WAN_LOCATOR_PING_INTERVAL);
                    RemoteLocatorPingResponse pingResponse = (RemoteLocatorPingResponse)this.locatorClient.requestToServer(remoteLocator.getHost(), (Object)pingRequest, WanLocatorDiscoverer.WAN_LOCATOR_CONNECTION_TIMEOUT, true);
                    if (pingResponse == null) continue block6;
                }
            }
            catch (IOException ioe) {
                if (retryAttempt == WAN_LOCATOR_CONNECTION_RETRY_ATTEMPT) {
                    logger.fatal(String.format("Locator discovery task could not exchange locator information %s with %s after %s retry attempts.", this.request.getLocator(), remoteLocator, retryAttempt), (Throwable)ioe);
                    break;
                }
                if (this.skipFailureLogging(remoteLocator)) {
                    logger.warn("Locator discovery task could not exchange locator information {} with {} after {} retry attempts. Retrying in {} ms.", new Object[]{this.request.getLocator(), remoteLocator, retryAttempt, WAN_LOCATOR_CONNECTION_INTERVAL});
                }
                try {
                    Thread.sleep(WAN_LOCATOR_CONNECTION_INTERVAL);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ++retryAttempt;
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.fatal("Locator discovery task encountred unexpected exception", (Throwable)classNotFoundException);
                break;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public class RemoteLocatorDiscovery
    implements Runnable {
        @Override
        public void run() {
            LocatorDiscovery.this.exchangeRemoteLocators();
        }
    }

    public class LocalLocatorDiscovery
    implements Runnable {
        @Override
        public void run() {
            LocatorDiscovery.this.exchangeLocalLocators();
        }
    }
}

