/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.net.SocketTimeoutException;
import java.util.List;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionImpl;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.MessageStats;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.wan.BatchException70;
import org.apache.geode.internal.cache.wan.GatewaySenderEventCallbackArgument;
import org.apache.geode.internal.cache.wan.GatewaySenderEventImpl;
import org.apache.geode.internal.cache.wan.GatewaySenderEventRemoteDispatcher;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class GatewaySenderBatchOp {
    private static final Logger logger = LogService.getLogger();

    public static void executeOn(Connection con, ExecutablePool pool, List events, int batchId, boolean isRetry) {
        GatewaySenderGFEBatchOpImpl op = null;
        op = Version.GFE_651.compareTo(con.getWanSiteVersion()) >= 0 ? new GatewaySenderGFEBatchOpImpl(events, batchId, con.getDistributedSystemId(), isRetry) : new GatewaySenderGFEBatchOpImpl(events, batchId, con.getDistributedSystemId(), isRetry);
        pool.executeOn(con, (Op)op, true);
    }

    public static Object executeOn(Connection con, ExecutablePool pool) {
        GatewaySenderGFEBatchOpImpl op = new GatewaySenderGFEBatchOpImpl();
        return pool.executeOn(con, (Op)op, true);
    }

    private GatewaySenderBatchOp() {
    }

    static class GatewaySenderGFEBatchOpImpl
    extends AbstractOp {
        public GatewaySenderGFEBatchOpImpl(List events, int batchId, int dsId, boolean isRetry) {
            super(104, GatewaySenderGFEBatchOpImpl.calcPartCount(events));
            boolean removeFromQueueOnException = true;
            if (isRetry) {
                this.getMessage().setIsRetry();
            }
            this.getMessage().addIntPart(events.size());
            this.getMessage().addIntPart(batchId);
            this.getMessage().addIntPart(dsId);
            this.getMessage().addBytesPart(new byte[]{removeFromQueueOnException ? (byte)1 : 0});
            for (GatewaySenderEventImpl event : events) {
                int action = event.getAction();
                this.getMessage().addIntPart(action);
                byte posDupByte = (byte)(event.getPossibleDuplicate() ? 1 : 0);
                this.getMessage().addBytesPart(new byte[]{posDupByte});
                if (action < 0 || action > 3) continue;
                String regionName = event.getRegionPath();
                EventID eventId = event.getEventId();
                Object key = event.getKey();
                GatewaySenderEventCallbackArgument callbackArg = event.getSenderCallbackArgument();
                this.getMessage().addStringPart(regionName);
                this.getMessage().addObjPart((Object)eventId);
                this.getMessage().addStringOrObjPart(key);
                if (action < 2) {
                    byte[] value = event.getSerializedValue();
                    byte valueIsObject = event.getValueIsObject();
                    this.getMessage().addRawPart(value, valueIsObject == 1);
                }
                if (callbackArg == null) {
                    this.getMessage().addBytesPart(new byte[]{0});
                } else {
                    this.getMessage().addBytesPart(new byte[]{1});
                    this.getMessage().addObjPart((Object)callbackArg);
                }
                this.getMessage().addLongPart(event.getVersionTimeStamp());
            }
        }

        public GatewaySenderGFEBatchOpImpl() {
            super(104, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object attempt(Connection cnx) throws Exception {
            if (this.getMessage().getNumberOfParts() == 0) {
                return this.attemptRead(cnx);
            }
            this.failed = true;
            this.timedOut = false;
            long start = this.startAttempt(cnx.getStats());
            try {
                try {
                    this.attemptSend(cnx);
                    this.failed = false;
                }
                finally {
                    this.endSendAttempt(cnx.getStats(), start);
                }
            }
            finally {
                this.endAttempt(cnx.getStats(), start);
            }
            return this.failed;
        }

        private Object attemptRead(Connection cnx) throws Exception {
            this.failed = true;
            try {
                Object result = this.attemptReadResponse(cnx);
                this.failed = false;
                return result;
            }
            catch (SocketTimeoutException ste) {
                this.failed = false;
                this.timedOut = true;
                throw ste;
            }
            catch (Exception e) {
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object attemptReadResponse(Connection cnx) throws Exception {
            Message msg = this.createResponseMessage();
            if (msg != null) {
                msg.setComms(cnx.getSocket(), cnx.getInputStream(), cnx.getOutputStream(), ((ConnectionImpl)cnx).getCommBufferForAsyncRead(), (MessageStats)cnx.getStats());
                if (msg instanceof ChunkedMessage) {
                    try {
                        Object object = this.processResponse(msg, cnx);
                        return object;
                    }
                    finally {
                        msg.unsetComms();
                        this.processSecureBytes(cnx, msg);
                    }
                }
                try {
                    msg.recv();
                }
                finally {
                    msg.unsetComms();
                    this.processSecureBytes(cnx, msg);
                }
                return this.processResponse(msg, cnx);
            }
            return null;
        }

        private static int calcPartCount(List events) {
            int numberOfParts = 4;
            for (GatewaySenderEventImpl event : events) {
                numberOfParts += event.getNumberOfParts();
            }
            return numberOfParts;
        }

        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        protected boolean needsUserId() {
            return false;
        }

        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Object processResponse(Message msg) throws Exception {
            GatewaySenderEventRemoteDispatcher.GatewayAck ack = null;
            try {
                switch (msg.getMessageType()) {
                    case 6: {
                        Part part0 = msg.getPart(0);
                        if (part0.isBytes() && part0.getLength() == 1 && part0.getSerializedForm()[0] == 0) {
                            return ack;
                        } else {
                            int batchId = part0.getInt();
                            int numEvents = msg.getPart(1).getInt();
                            ack = new GatewaySenderEventRemoteDispatcher.GatewayAck(batchId, numEvents);
                            return ack;
                        }
                    }
                    case 2: {
                        Part part0 = msg.getPart(0);
                        Object obj = part0.getObject();
                        if (obj instanceof List) {
                            List l = (List)part0.getObject();
                            logger.info("We got an exception from the GatewayReceiver. MessageType : {} obj :{}", (Object)msg.getMessageType(), obj);
                            BatchException70 be = new BatchException70(l);
                            ack = new GatewaySenderEventRemoteDispatcher.GatewayAck(be, ((BatchException70)l.get(0)).getBatchId());
                            return ack;
                        } else {
                            if (!(obj instanceof Throwable)) return ack;
                            String s = ": While reading Ack from receiver " + ((Throwable)obj).getMessage();
                            throw new ServerOperationException(s, (Throwable)obj);
                        }
                    }
                    default: {
                        throw new InternalGemFireError(LocalizedStrings.Op_UNKNOWN_MESSAGE_TYPE_0.toLocalizedString(new Object[]{msg.getMessageType()}));
                    }
                }
            }
            finally {
                msg.clear();
            }
        }

        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        protected long startAttempt(ConnectionStats stats) {
            return stats.startGatewayBatch();
        }

        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGatewayBatchSend(start, this.hasFailed());
        }

        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGatewayBatch(start, this.hasTimedOut(), this.hasFailed());
        }

        public boolean isGatewaySenderOp() {
            return true;
        }
    }
}

