/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.parallel;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.pooling.ConnectionDestroyedException;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderConfigurationException;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventDispatcher;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventRemoteDispatcher;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderException;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderStats;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class RemoteParallelGatewaySenderEventProcessor
extends ParallelGatewaySenderEventProcessor {
    private static final Logger logger = LogService.getLogger();

    protected RemoteParallelGatewaySenderEventProcessor(AbstractGatewaySender sender) {
        super(sender);
    }

    protected RemoteParallelGatewaySenderEventProcessor(AbstractGatewaySender sender, Set<Region> userRegions, int id, int nDispatcher) {
        super(sender, userRegions, id, nDispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebalance() {
        GatewaySenderStats statistics = this.sender.getStatistics();
        long startTime = statistics.startLoadBalance();
        try {
            GatewaySenderEventRemoteDispatcher remoteDispatcher;
            if (this.dispatcher.isRemoteDispatcher() && (remoteDispatcher = (GatewaySenderEventRemoteDispatcher)this.dispatcher).isConnectedToRemote()) {
                remoteDispatcher.stopAckReaderThread();
                remoteDispatcher.destroyConnection();
            }
        }
        finally {
            statistics.endLoadBalance(startTime);
        }
    }

    public void initializeEventDispatcher() {
        if (logger.isDebugEnabled()) {
            logger.debug(" Creating the GatewayEventRemoteDispatcher");
        }
        if (this.sender.getRemoteDSId() != -1) {
            this.dispatcher = new GatewaySenderEventRemoteDispatcher((AbstractGatewaySenderEventProcessor)this);
        }
    }

    private boolean shouldSendVersionEvents(GatewaySenderEventDispatcher disp) throws GatewaySenderException {
        try {
            short remoteSiteVersion;
            GatewaySenderEventRemoteDispatcher remoteDispatcher = (GatewaySenderEventRemoteDispatcher)disp;
            Connection conn = remoteDispatcher.getConnection(false);
            if (conn != null && Version.GFE_701.compareTo(remoteSiteVersion = conn.getWanSiteVersion()) <= 0) {
                return true;
            }
        }
        catch (GatewaySenderException e) {
            block7: {
                Throwable cause = e.getCause();
                if (cause instanceof IOException || e instanceof GatewaySenderConfigurationException || cause instanceof ConnectionDestroyedException) {
                    try {
                        int sleepInterval = GatewaySender.CONNECTION_RETRY_INTERVAL;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Sleeping for {} milliseconds", (Object)sleepInterval);
                        }
                        Thread.sleep(sleepInterval);
                    }
                    catch (InterruptedException ie) {
                        if (!logger.isDebugEnabled()) break block7;
                        logger.debug(ie.getMessage(), (Throwable)ie);
                    }
                }
            }
            throw e;
        }
        return false;
    }
}

