/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.parallel;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.EntryOperation;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisee;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ResourceEvent;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.UpdateAttributesProcessor;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.AbstractRemoteGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderAdvisor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderAttributes;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.cache.wan.parallel.RemoteConcurrentParallelGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class ParallelGatewaySenderImpl
extends AbstractRemoteGatewaySender {
    private static final Logger logger = LogService.getLogger();
    final ThreadGroup loggerGroup = LoggingThreadGroup.createThreadGroup((String)"Remote Site Discovery Logger Group", (Logger)logger);

    public ParallelGatewaySenderImpl() {
        this.isParallel = true;
    }

    public ParallelGatewaySenderImpl(Cache cache, GatewaySenderAttributes attrs) {
        super(cache, attrs);
    }

    public void start() {
        this.getLifeCycleLock().writeLock().lock();
        try {
            String locators;
            if (this.isRunning()) {
                logger.warn((Message)LocalizedMessage.create((StringId)LocalizedStrings.GatewaySender_SENDER_0_IS_ALREADY_RUNNING, (Object)this.getId()));
                return;
            }
            if (this.remoteDSId != -1 && (locators = ((GemFireCacheImpl)this.cache).getDistributedSystem().getConfig().getLocators()).length() == 0) {
                throw new IllegalStateException(LocalizedStrings.AbstractGatewaySender_LOCATOR_SHOULD_BE_CONFIGURED_BEFORE_STARTING_GATEWAY_SENDER.toLocalizedString());
            }
            this.eventProcessor = new RemoteConcurrentParallelGatewaySenderEventProcessor(this);
            this.eventProcessor.start();
            this.waitForRunningStatus();
            if (!this.isAsyncEventQueue()) {
                ((GemFireCacheImpl)this.getCache()).getPdxRegistry().gatewaySenderStarted((GatewaySender)this);
            }
            new UpdateAttributesProcessor((DistributionAdvisee)this).distribute(false);
            InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
            system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_START, (Object)this);
            logger.info((Message)LocalizedMessage.create((StringId)LocalizedStrings.ParallelGatewaySenderImpl_STARTED__0, (Object)((Object)this)));
            this.enqueueTempEvents();
        }
        finally {
            this.getLifeCycleLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.getLifeCycleLock().writeLock().lock();
        try {
            if (!this.isRunning()) {
                return;
            }
            AbstractGatewaySenderEventProcessor ev = this.eventProcessor;
            if (ev != null && !ev.isStopped()) {
                ev.stopProcessing();
            }
            this.stompProxyDead();
            for (AsyncEventListener listener : this.listeners) {
                listener.close();
            }
            ((ConcurrentParallelGatewaySenderQueue)this.eventProcessor.getQueue()).cleanUp();
            logger.info((Message)LocalizedMessage.create((StringId)LocalizedStrings.GatewayImpl_STOPPED__0, (Object)((Object)this)));
            InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
            system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_STOP, (Object)this);
            this.clearTempEventsAfterSenderStopped();
        }
        finally {
            this.getLifeCycleLock().writeLock().unlock();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ParallelGatewaySender{");
        sb.append("id=" + this.getId());
        sb.append(",remoteDsId=" + this.getRemoteDSId());
        sb.append(",isRunning =" + this.isRunning());
        sb.append("}");
        return sb.toString();
    }

    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof GatewaySenderAdvisor.GatewaySenderProfile);
        GatewaySenderAdvisor.GatewaySenderProfile pf = (GatewaySenderAdvisor.GatewaySenderProfile)profile;
        pf.Id = this.getId();
        pf.remoteDSId = this.getRemoteDSId();
        pf.isRunning = this.isRunning();
        pf.isPrimary = this.isPrimary();
        pf.isParallel = true;
        pf.isBatchConflationEnabled = this.isBatchConflationEnabled();
        pf.isPersistenceEnabled = this.isPersistenceEnabled();
        pf.alertThreshold = this.getAlertThreshold();
        pf.manualStart = this.isManualStart();
        pf.dispatcherThreads = this.getDispatcherThreads();
        pf.orderPolicy = this.getOrderPolicy();
        for (GatewayEventFilter filter : this.getGatewayEventFilters()) {
            pf.eventFiltersClassNames.add(filter.getClass().getName());
        }
        for (GatewayEventFilter filter : this.getGatewayTransportFilters()) {
            pf.transFiltersClassNames.add(filter.getClass().getName());
        }
        for (AsyncEventListener listener : this.getAsyncEventListeners()) {
            pf.senderEventListenerClassNames.add(listener.getClass().getName());
        }
        pf.isDiskSynchronous = this.isDiskSynchronous();
    }

    protected void setModifiedEventId(EntryEventImpl clonedEvent) {
        int bucketId = -1;
        bucketId = clonedEvent.getRegion() instanceof DistributedRegion ? PartitionedRegionHelper.getHashKey((Object)clonedEvent.getKey(), (int)this.getMaxParallelismForReplicatedRegion()) : PartitionedRegionHelper.getHashKey((EntryOperation)clonedEvent);
        EventID originalEventId = clonedEvent.getEventId();
        long originatingThreadId = ThreadIdentifier.getRealThreadID((long)originalEventId.getThreadID());
        long newThreadId = ThreadIdentifier.createFakeThreadIDForParallelGSPrimaryBucket((int)bucketId, (long)originatingThreadId, (int)this.getEventIdIndex());
        EventID newEventId = new EventID(originalEventId.getMembershipID(), newThreadId, originalEventId.getSequenceID(), bucketId);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Generated event id for event with key={}, bucketId={}, original event id={}, threadId={}, new event id={}, newThreadId={}", (Object)this, clonedEvent.getKey(), (Object)bucketId, (Object)originalEventId, (Object)originatingThreadId, (Object)newEventId, (Object)newThreadId);
        }
        clonedEvent.setEventId(newEventId);
    }
}

