/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization.filter;

import java.util.function.BooleanSupplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.internal.lang.SystemProperty;
import org.apache.geode.internal.serialization.filter.FilterConfiguration;
import org.apache.geode.internal.serialization.filter.GlobalSerialFilterConfiguration;
import org.apache.geode.internal.serialization.filter.GlobalSerialFilterConfigurationFactory;
import org.apache.geode.internal.serialization.filter.ObjectInputFilterUtils;
import org.apache.geode.internal.serialization.filter.SerializableObjectConfig;

public class SystemPropertyGlobalSerialFilterConfigurationFactory
implements GlobalSerialFilterConfigurationFactory {
    private final boolean enabled;

    public SystemPropertyGlobalSerialFilterConfigurationFactory() {
        this(ObjectInputFilterUtils::supportsObjectInputFilter);
    }

    SystemPropertyGlobalSerialFilterConfigurationFactory(BooleanSupplier supportsObjectInputFilter) {
        this(supportsObjectInputFilter.getAsBoolean() && StringUtils.isBlank((CharSequence)System.getProperty("jdk.serialFilter")) && SystemProperty.getProductBooleanProperty((String)"enableGlobalSerialFilter").orElse(false) != false);
    }

    private SystemPropertyGlobalSerialFilterConfigurationFactory(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public FilterConfiguration create(SerializableObjectConfig serializableObjectConfig) {
        if (this.enabled) {
            return new GlobalSerialFilterConfiguration(serializableObjectConfig);
        }
        return new NullFilterConfiguration();
    }

    private static class NullFilterConfiguration
    implements FilterConfiguration {
        private NullFilterConfiguration() {
        }

        @Override
        public boolean configure() {
            return false;
        }
    }
}

