/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.data;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.remote.JMXConnector;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.tools.pulse.internal.data.DataBrowser;
import org.apache.geode.tools.pulse.internal.data.IClusterUpdater;
import org.apache.geode.tools.pulse.internal.data.JMXDataUpdater;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Cluster
extends Thread {
    private static final int POLL_INTERVAL = 5000;
    public static final int MAX_SAMPLE_SIZE = 180;
    public static final int ALERTS_MAX_SIZE = 1000;
    public static final int PAGE_ALERTS_MAX_SIZE = 100;
    private static final Logger logger = LogManager.getLogger();
    private final ResourceBundle resourceBundle = Repository.get().getResourceBundle();
    private String jmxUserName;
    private String serverName;
    private String port;
    private JMXConnector jmxConnector;
    private int stale = 0;
    private double loadPerSec;
    private CountDownLatch clusterHasBeenInitialized;
    private IClusterUpdater updater = null;
    private DataBrowser dataBrowser = null;
    private int memberCount;
    private long clientConnectionCount;
    private int locatorCount;
    private int totalRegionCount;
    private long totalHeapSize = 0L;
    private long totalRegionEntryCount;
    private int currentQueryCount;
    private long totalBytesOnDisk;
    private double diskReadsRate;
    private double diskWritesRate;
    private double writePerSec;
    private double readPerSec;
    private double queriesPerSec;
    private int avgDiskStorage;
    private int avgDiskWritesRate;
    private int runningFunctionCount;
    private long registeredCQCount;
    private int subscriptionCount;
    private int serverCount;
    private int txnCommittedCount;
    private int txnRollbackCount;
    private long usedHeapSize = 0L;
    private long garbageCollectionCount = 0L;
    private int clusterId;
    private int notificationPageNumber = 1;
    private boolean connectedFlag;
    private String connectionErrorMsg = "";
    private Set<String> deletedMembers = new HashSet<String>();
    private Map<String, List<Member>> physicalToMember = new HashMap<String, List<Member>>();
    private Map<String, Member> membersHMap = new HashMap<String, Member>();
    private Set<String> deletedRegions = new HashSet<String>();
    private Map<String, Region> clusterRegionMap = new ConcurrentHashMap<String, Region>();
    private List<Alert> alertsList = new ArrayList<Alert>();
    private CircularFifoBuffer totalBytesOnDiskTrend = new CircularFifoBuffer(180);
    private CircularFifoBuffer throughoutWritesTrend = new CircularFifoBuffer(180);
    private CircularFifoBuffer throughoutReadsTrend = new CircularFifoBuffer(180);
    private CircularFifoBuffer writePerSecTrend = new CircularFifoBuffer(180);
    private CircularFifoBuffer readPerSecTrend = new CircularFifoBuffer(180);
    private CircularFifoBuffer queriesPerSecTrend = new CircularFifoBuffer(180);
    private CircularFifoBuffer memoryUsageTrend = new CircularFifoBuffer(180);
    private CircularFifoBuffer garbageCollectionTrend = new CircularFifoBuffer(180);
    private long previousJVMPauseCount = 0L;
    private HashMap<String, Boolean> wanInformation = new HashMap();
    private Map<String, Statement> clusterStatementMap = new ConcurrentHashMap<String, Statement>();
    public static final int CLUSTER_STAT_TOTAL_BYTES_ON_DISK = 0;
    public static final int CLUSTER_STAT_THROUGHPUT_WRITES = 1;
    public static final int CLUSTER_STAT_THROUGHPUT_READS = 2;
    public static final int CLUSTER_STAT_WRITES_PER_SECOND = 3;
    public static final int CLUSTER_STAT_READ_PER_SECOND = 4;
    public static final int CLUSTER_STAT_QUERIES_PER_SECOND = 5;
    public static final int CLUSTER_STAT_MEMORY_USAGE = 6;
    public static final int CLUSTER_STAT_GARBAGE_COLLECTION = 7;
    public static long LAST_UPDATE_TIME = 0L;
    private boolean stopUpdates = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getStatisticTrend(int trendId) {
        Object[] returnArray = null;
        switch (trendId) {
            case 0: {
                CircularFifoBuffer circularFifoBuffer = this.totalBytesOnDiskTrend;
                synchronized (circularFifoBuffer) {
                    returnArray = this.totalBytesOnDiskTrend.toArray();
                    break;
                }
            }
            case 2: {
                CircularFifoBuffer circularFifoBuffer = this.throughoutReadsTrend;
                synchronized (circularFifoBuffer) {
                    returnArray = this.throughoutReadsTrend.toArray();
                    break;
                }
            }
            case 1: {
                CircularFifoBuffer circularFifoBuffer = this.throughoutWritesTrend;
                synchronized (circularFifoBuffer) {
                    returnArray = this.throughoutWritesTrend.toArray();
                    break;
                }
            }
            case 3: {
                CircularFifoBuffer circularFifoBuffer = this.writePerSecTrend;
                synchronized (circularFifoBuffer) {
                    returnArray = this.writePerSecTrend.toArray();
                    break;
                }
            }
            case 4: {
                CircularFifoBuffer circularFifoBuffer = this.readPerSecTrend;
                synchronized (circularFifoBuffer) {
                    returnArray = this.readPerSecTrend.toArray();
                    break;
                }
            }
            case 5: {
                CircularFifoBuffer circularFifoBuffer = this.queriesPerSecTrend;
                synchronized (circularFifoBuffer) {
                    returnArray = this.queriesPerSecTrend.toArray();
                    break;
                }
            }
            case 6: {
                CircularFifoBuffer circularFifoBuffer = this.memoryUsageTrend;
                synchronized (circularFifoBuffer) {
                    returnArray = this.memoryUsageTrend.toArray();
                    break;
                }
            }
            case 7: {
                CircularFifoBuffer circularFifoBuffer = this.garbageCollectionTrend;
                synchronized (circularFifoBuffer) {
                    returnArray = this.garbageCollectionTrend.toArray();
                    break;
                }
            }
        }
        return returnArray;
    }

    public Cluster() {
    }

    public Cluster(String host, String port, String userName) {
        this.serverName = host;
        this.port = port;
        this.jmxUserName = userName;
        this.updater = new JMXDataUpdater(this.serverName, port, this);
        this.clusterHasBeenInitialized = new CountDownLatch(1);
    }

    public void waitForInitialization(long timeout, TimeUnit unit) throws InterruptedException {
        this.clusterHasBeenInitialized.await(timeout, unit);
    }

    @Override
    public void run() {
        try {
            while (!this.stopUpdates) {
                try {
                    this.stale = !this.updateData() ? ++this.stale : 0;
                }
                catch (Exception e) {
                    logger.info("Exception Occurred while updating cluster data : ", (Throwable)e);
                }
                this.clusterHasBeenInitialized.countDown();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    logger.info("InterruptedException Occurred : ", (Throwable)e);
                }
            }
            logger.info("{} :: {}:{}", (Object)this.resourceBundle.getString("LOG_MSG_STOP_THREAD_UPDATES"), (Object)this.serverName, (Object)this.port);
        }
        finally {
            this.clusterHasBeenInitialized.countDown();
        }
    }

    private boolean updateData() {
        logger.debug("{} :: {}:{}", (Object)this.resourceBundle.getString("LOG_MSG_CLUSTER_DATA_IS_UPDATING"), (Object)this.serverName, (Object)this.port);
        return this.updater.updateData();
    }

    public void stopThread() {
        this.stopUpdates = true;
        try {
            this.join();
        }
        catch (InterruptedException e) {
            logger.info("InterruptedException occurred while stoping cluster thread : ", (Throwable)e);
        }
    }

    public Map<String, Member> getMembersHMap() {
        return this.membersHMap;
    }

    public void setMembersHMap(HashMap<String, Member> membersHMap) {
        this.membersHMap = membersHMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Boolean> getWanInformation() {
        Map wanMap = null;
        HashMap<String, Boolean> hashMap = this.wanInformation;
        synchronized (hashMap) {
            wanMap = (Map)this.wanInformation.clone();
        }
        return wanMap;
    }

    public Map<String, Boolean> getWanInformationObject() {
        return this.wanInformation;
    }

    public void setWanInformation(HashMap<String, Boolean> wanInformation) {
        this.wanInformation = wanInformation;
    }

    public String getJmxUserName() {
        return this.jmxUserName;
    }

    public String getConnectionErrorMsg() {
        return this.connectionErrorMsg;
    }

    public void setConnectionErrorMsg(String connectionErrorMsg) {
        this.connectionErrorMsg = connectionErrorMsg;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean isConnectedFlag() {
        return this.connectedFlag;
    }

    public void setConnectedFlag(boolean connectedFlag) {
        this.connectedFlag = connectedFlag;
    }

    public String getPort() {
        return this.port;
    }

    public int getStale() {
        return this.stale;
    }

    public double getWritePerSec() {
        return this.writePerSec;
    }

    public void setWritePerSec(double writePerSec) {
        this.writePerSec = writePerSec;
    }

    public double getReadPerSec() {
        return this.readPerSec;
    }

    public void setReadPerSec(double readPerSec) {
        this.readPerSec = readPerSec;
    }

    public double getQueriesPerSec() {
        return this.queriesPerSec;
    }

    public void setQueriesPerSec(double queriesPerSec) {
        this.queriesPerSec = queriesPerSec;
    }

    public double getLoadPerSec() {
        return this.loadPerSec;
    }

    public void setLoadPerSec(double loadPerSec) {
        this.loadPerSec = loadPerSec;
    }

    public int getNotificationPageNumber() {
        return this.notificationPageNumber;
    }

    public void setNotificationPageNumber(int notificationPageNumber) {
        this.notificationPageNumber = notificationPageNumber;
    }

    public void setStale(int stale) {
        this.stale = stale;
    }

    public boolean isStopUpdates() {
        return this.stopUpdates;
    }

    public void setStopUpdates(boolean stopUpdates) {
        this.stopUpdates = stopUpdates;
    }

    public long getUsedHeapSize() {
        return this.usedHeapSize;
    }

    public void setUsedHeapSize(long usedHeapSize) {
        this.usedHeapSize = usedHeapSize;
    }

    public int getServerCount() {
        return this.serverCount;
    }

    public void setServerCount(int serverCount) {
        this.serverCount = serverCount;
    }

    public int getTxnCommittedCount() {
        return this.txnCommittedCount;
    }

    public void setTxnCommittedCount(int txnCommittedCount) {
        this.txnCommittedCount = txnCommittedCount;
    }

    public int getTxnRollbackCount() {
        return this.txnRollbackCount;
    }

    public void setTxnRollbackCount(int txnRollbackCount) {
        this.txnRollbackCount = txnRollbackCount;
    }

    public int getRunningFunctionCount() {
        return this.runningFunctionCount;
    }

    public long getRegisteredCQCount() {
        return this.registeredCQCount;
    }

    public int getSubscriptionCount() {
        return this.subscriptionCount;
    }

    public void setSubscriptionCount(int subscriptionCount) {
        this.subscriptionCount = subscriptionCount;
    }

    public void setRegisteredCQCount(long registeredCQCount) {
        this.registeredCQCount = registeredCQCount;
    }

    public void setRunningFunctionCount(int runningFunctionCount) {
        this.runningFunctionCount = runningFunctionCount;
    }

    public Map<String, Region> getClusterRegions() {
        return this.clusterRegionMap;
    }

    public Region getClusterRegion(String regionFullPath) {
        return this.clusterRegionMap.get(regionFullPath);
    }

    public void setClusterRegions(Map<String, Region> clusterRegionMap) {
        this.clusterRegionMap = clusterRegionMap;
    }

    public Map<String, Statement> getClusterStatements() {
        return this.clusterStatementMap;
    }

    public void setClusterStatements(Map<String, Statement> clusterStatementMap) {
        this.clusterStatementMap = clusterStatementMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Alert[] getAlertsList() {
        Alert[] list = null;
        List<Alert> list2 = this.alertsList;
        synchronized (list2) {
            list = new Alert[this.alertsList.size()];
            list = this.alertsList.toArray(list);
        }
        return list;
    }

    public void setAlertsList(List<Alert> alertsList) {
        this.alertsList = alertsList;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public Set<String> getDeletedMembers() {
        return this.deletedMembers;
    }

    public void setDeletedMembers(Set<String> deletedMembers) {
        this.deletedMembers = deletedMembers;
    }

    public Set<String> getDeletedRegions() {
        return this.deletedRegions;
    }

    public void setDeletedRegions(Set<String> deletedRegions) {
        this.deletedRegions = deletedRegions;
    }

    public Map<String, List<Member>> getPhysicalToMember() {
        Map<String, List<Member>> ptom = null;
        ptom = this.physicalToMember;
        return ptom;
    }

    public void setPhysicalToMember(HashMap<String, List<Member>> physicalToMember) {
        this.physicalToMember = physicalToMember;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public void setMemberCount(int memberCount) {
        this.memberCount = memberCount;
    }

    public long getClientConnectionCount() {
        return this.clientConnectionCount;
    }

    public void setClientConnectionCount(long clientConnectionCount) {
        this.clientConnectionCount = clientConnectionCount;
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(int clusterId) {
        this.clusterId = clusterId;
    }

    public int getLocatorCount() {
        return this.locatorCount;
    }

    public void setLocatorCount(int locatorCount) {
        this.locatorCount = locatorCount;
    }

    public int getTotalRegionCount() {
        return this.totalRegionCount;
    }

    public void setTotalRegionCount(int totalRegionCount) {
        this.totalRegionCount = totalRegionCount;
    }

    public long getTotalHeapSize() {
        return this.totalHeapSize;
    }

    public void setTotalHeapSize(long totalHeapSize) {
        this.totalHeapSize = totalHeapSize;
    }

    public long getTotalRegionEntryCount() {
        return this.totalRegionEntryCount;
    }

    public void setTotalRegionEntryCount(long totalRegionEntryCount) {
        this.totalRegionEntryCount = totalRegionEntryCount;
    }

    public int getCurrentQueryCount() {
        return this.currentQueryCount;
    }

    public void setCurrentQueryCount(int currentQueryCount) {
        this.currentQueryCount = currentQueryCount;
    }

    public long getTotalBytesOnDisk() {
        return this.totalBytesOnDisk;
    }

    public void setTotalBytesOnDisk(long totalBytesOnDisk) {
        this.totalBytesOnDisk = totalBytesOnDisk;
    }

    public double getDiskReadsRate() {
        return this.diskReadsRate;
    }

    public void setDiskReadsRate(double diskReadsRate) {
        this.diskReadsRate = diskReadsRate;
    }

    public double getDiskWritesRate() {
        return this.diskWritesRate;
    }

    public void setDiskWritesRate(double diskWritesRate) {
        this.diskWritesRate = diskWritesRate;
    }

    public int getAvgDiskStorage() {
        return this.avgDiskStorage;
    }

    public void setAvgDiskStorage(int avgDiskStorage) {
        this.avgDiskStorage = avgDiskStorage;
    }

    public int getAvgDiskWritesRate() {
        return this.avgDiskWritesRate;
    }

    public void setAvgDiskWritesRate(int avgDiskWritesRate) {
        this.avgDiskWritesRate = avgDiskWritesRate;
    }

    public CircularFifoBuffer getWritePerSecTrend() {
        return this.writePerSecTrend;
    }

    public void setWritePerSecTrend(CircularFifoBuffer writePerSecTrend) {
        this.writePerSecTrend = writePerSecTrend;
    }

    public long getGarbageCollectionCount() {
        return this.garbageCollectionCount;
    }

    public void setGarbageCollectionCount(long garbageCollectionCount) {
        this.garbageCollectionCount = garbageCollectionCount;
    }

    public CircularFifoBuffer getTotalBytesOnDiskTrend() {
        return this.totalBytesOnDiskTrend;
    }

    public void setTotalBytesOnDiskTrend(CircularFifoBuffer totalBytesOnDiskTrend) {
        this.totalBytesOnDiskTrend = totalBytesOnDiskTrend;
    }

    public CircularFifoBuffer getThroughoutWritesTrend() {
        return this.throughoutWritesTrend;
    }

    public void setThroughoutWritesTrend(CircularFifoBuffer throughoutWritesTrend) {
        this.throughoutWritesTrend = throughoutWritesTrend;
    }

    public CircularFifoBuffer getThroughoutReadsTrend() {
        return this.throughoutReadsTrend;
    }

    public void setThroughoutReadsTrend(CircularFifoBuffer throughoutReadsTrend) {
        this.throughoutReadsTrend = throughoutReadsTrend;
    }

    public CircularFifoBuffer getReadPerSecTrend() {
        return this.readPerSecTrend;
    }

    public void setReadPerSecTrend(CircularFifoBuffer readPerSecTrend) {
        this.readPerSecTrend = readPerSecTrend;
    }

    public CircularFifoBuffer getQueriesPerSecTrend() {
        return this.queriesPerSecTrend;
    }

    public void setQueriesPerSecTrend(CircularFifoBuffer queriesPerSecTrend) {
        this.queriesPerSecTrend = queriesPerSecTrend;
    }

    public CircularFifoBuffer getMemoryUsageTrend() {
        return this.memoryUsageTrend;
    }

    public void setMemoryUsageTrend(CircularFifoBuffer memoryUsageTrend) {
        this.memoryUsageTrend = memoryUsageTrend;
    }

    public CircularFifoBuffer getGarbageCollectionTrend() {
        return this.garbageCollectionTrend;
    }

    public void setGarbageCollectionTrend(CircularFifoBuffer garbageCollectionSamples) {
        this.garbageCollectionTrend = garbageCollectionSamples;
    }

    public long getPreviousJVMPauseCount() {
        return this.previousJVMPauseCount;
    }

    public void setPreviousJVMPauseCount(long previousJVMPauseCount) {
        this.previousJVMPauseCount = previousJVMPauseCount;
    }

    public DataBrowser getDataBrowser() {
        if (this.dataBrowser == null) {
            this.dataBrowser = new DataBrowser();
        }
        return this.dataBrowser;
    }

    public void setDataBrowser(DataBrowser dataBrowser) {
        this.dataBrowser = dataBrowser;
    }

    public ObjectNode executeQuery(String queryText, String members, int limit) {
        return this.updater.executeQuery(queryText, members, limit);
    }

    public ArrayNode getQueryHistoryByUserId(String userId) {
        return this.getDataBrowser().getQueryHistoryByUserId(userId);
    }

    public boolean addQueryInHistory(String queryText, String userName) {
        return this.getDataBrowser().addQueryInHistory(queryText, userName);
    }

    public boolean deleteQueryById(String userId, String queryId) {
        return this.getDataBrowser().deleteQueryById(userId, queryId);
    }

    public void connectToGemFire(String password) {
        this.jmxConnector = this.updater.connect(this.getJmxUserName(), password);
        if (this.jmxConnector != null) {
            this.start();
            try {
                this.waitForInitialization(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public JMXConnector getJMXConnector() {
        return this.jmxConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAlerts(int alertType, boolean isClearAll) {
        ArrayList<Alert> toDelete = new ArrayList<Alert>();
        if (alertType == -1) {
            List<Alert> list = this.alertsList;
            synchronized (list) {
                if (isClearAll) {
                    this.alertsList.clear();
                    this.setNotificationPageNumber(1);
                } else {
                    for (int i = 0; i < this.alertsList.size(); ++i) {
                        Alert alert = this.alertsList.get(i);
                        if (!alert.isAcknowledged()) continue;
                        toDelete.add(alert);
                    }
                    this.alertsList.removeAll(toDelete);
                    toDelete.clear();
                }
            }
        }
        List<Alert> list = this.alertsList;
        synchronized (list) {
            for (int i = 0; i < this.alertsList.size(); ++i) {
                Alert alert = this.alertsList.get(i);
                if (alert.getSeverity() != alertType) continue;
                if (isClearAll) {
                    toDelete.add(alert);
                    continue;
                }
                if (!alert.isAcknowledged()) continue;
                toDelete.add(alert);
            }
            this.alertsList.removeAll(toDelete);
            toDelete.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeAlert(int alertId) {
        List<Alert> list = this.alertsList;
        synchronized (list) {
            for (Alert alert : this.alertsList) {
                if (alert.getId() != alertId) continue;
                alert.setAcknowledged(true);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlert(Alert alert) {
        List<Alert> list = this.alertsList;
        synchronized (list) {
            this.alertsList.add(alert);
            if (this.alertsList.size() > 1000) {
                this.alertsList.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Member getMember(String memberKey) {
        Member member = null;
        Map<String, Member> map = this.membersHMap;
        synchronized (map) {
            member = this.membersHMap.get(memberKey);
        }
        return member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Member[] getMembers() {
        Member[] members = null;
        Map<String, Member> map = this.membersHMap;
        synchronized (map) {
            members = new Member[this.membersHMap.size()];
            members = this.membersHMap.values().toArray(members);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement[] getStatements() {
        Statement[] statements = null;
        Map<String, Statement> map = this.clusterStatementMap;
        synchronized (map) {
            statements = new Statement[this.clusterStatementMap.size()];
            statements = this.clusterStatementMap.values().toArray(statements);
        }
        return statements;
    }

    public void removeClusterRegion(String regionFullPath) {
        this.clusterRegionMap.remove(regionFullPath);
    }

    public void addClusterRegion(String regionFullPath, Region region) {
        this.clusterRegionMap.put(regionFullPath, region);
    }

    public void removeClusterStatement(String name) {
        this.clusterStatementMap.remove(name);
    }

    public void addClusterStatement(String name, Statement stmt) {
        this.clusterStatementMap.put(name, stmt);
    }

    public static class AsyncEventQueue {
        private String id;
        private boolean primary;
        private boolean parallel;
        private int batchSize;
        private long batchTimeInterval;
        private boolean batchConflationEnabled;
        private String asyncEventListener;
        private int eventQueueSize;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean getPrimary() {
            return this.primary;
        }

        public void setPrimary(boolean primary) {
            this.primary = primary;
        }

        public boolean isParallel() {
            return this.parallel;
        }

        public void setParallel(boolean parallel) {
            this.parallel = parallel;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(int batchSize) {
            this.batchSize = batchSize;
        }

        public long getBatchTimeInterval() {
            return this.batchTimeInterval;
        }

        public void setBatchTimeInterval(long batchTimeInterval) {
            this.batchTimeInterval = batchTimeInterval;
        }

        public boolean isBatchConflationEnabled() {
            return this.batchConflationEnabled;
        }

        public void setBatchConflationEnabled(boolean batchConflationEnabled) {
            this.batchConflationEnabled = batchConflationEnabled;
        }

        public String getAsyncEventListener() {
            return this.asyncEventListener;
        }

        public void setAsyncEventListener(String asyncEventListener) {
            this.asyncEventListener = asyncEventListener;
        }

        public int getEventQueueSize() {
            return this.eventQueueSize;
        }

        public void setEventQueueSize(int eventQueueSize) {
            this.eventQueueSize = eventQueueSize;
        }
    }

    public static class GatewaySender {
        private double linkThroughput;
        private String id;
        private int queueSize;
        private Boolean status;
        private boolean primary;
        private boolean senderType;
        private int batchSize;
        private boolean persistenceEnabled;
        private int remoteDSId;
        private int eventsExceedingAlertThreshold;

        public double getLinkThroughput() {
            return this.linkThroughput;
        }

        public void setLinkThroughput(double linkThroughput) {
            this.linkThroughput = linkThroughput;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }

        public Boolean getStatus() {
            return this.status;
        }

        public void setStatus(Boolean status) {
            this.status = status;
        }

        public boolean getPrimary() {
            return this.primary;
        }

        public void setPrimary(boolean primary) {
            this.primary = primary;
        }

        public boolean getSenderType() {
            return this.senderType;
        }

        public void setSenderType(boolean senderType) {
            this.senderType = senderType;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(int batchSize) {
            this.batchSize = batchSize;
        }

        public boolean getPersistenceEnabled() {
            return this.persistenceEnabled;
        }

        public void setPersistenceEnabled(boolean persistenceEnabled) {
            this.persistenceEnabled = persistenceEnabled;
        }

        public int getRemoteDSId() {
            return this.remoteDSId;
        }

        public void setRemoteDSId(int remoteDSId) {
            this.remoteDSId = remoteDSId;
        }

        public int getEventsExceedingAlertThreshold() {
            return this.eventsExceedingAlertThreshold;
        }

        public void setEventsExceedingAlertThreshold(int eventsExceedingAlertThreshold) {
            this.eventsExceedingAlertThreshold = eventsExceedingAlertThreshold;
        }
    }

    public static class GatewayReceiver {
        private int listeningPort;
        private double linkThroughput;
        private long avgBatchProcessingTime;
        private String id;
        private int queueSize;
        private Boolean status;
        private int batchSize;

        public int getListeningPort() {
            return this.listeningPort;
        }

        public void setListeningPort(int listeningPort) {
            this.listeningPort = listeningPort;
        }

        public double getLinkThroughput() {
            return this.linkThroughput;
        }

        public void setLinkThroughput(double linkThroughput) {
            this.linkThroughput = linkThroughput;
        }

        public long getAvgBatchProcessingTime() {
            return this.avgBatchProcessingTime;
        }

        public void setAvgBatchProcessingTime(long avgBatchProcessingTime) {
            this.avgBatchProcessingTime = avgBatchProcessingTime;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }

        public Boolean getStatus() {
            return this.status;
        }

        public void setStatus(Boolean status) {
            this.status = status;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(int batchSize) {
            this.batchSize = batchSize;
        }
    }

    public static class Client {
        private String id;
        private String name;
        private String host;
        private int queueSize;
        private double cpuUsage;
        private long uptime;
        private int threads;
        private int gets;
        private int puts;
        private int cpus;
        private int clientCQCount;
        private long processCpuTime;
        private String status;
        private boolean isConnected = false;
        private boolean isSubscriptionEnabled = false;

        public String getId() {
            return this.id;
        }

        public int getGets() {
            return this.gets;
        }

        public int getPuts() {
            return this.puts;
        }

        public int getClientCQCount() {
            return this.clientCQCount;
        }

        public void setClientCQCount(int clientCQCount) {
            this.clientCQCount = clientCQCount;
        }

        public boolean isSubscriptionEnabled() {
            return this.isSubscriptionEnabled;
        }

        public void setSubscriptionEnabled(boolean isSubscriptionEnabled) {
            this.isSubscriptionEnabled = isSubscriptionEnabled;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }

        public double getCpuUsage() {
            return this.cpuUsage;
        }

        public void setCpuUsage(double cpuUsage) {
            this.cpuUsage = cpuUsage;
        }

        public void setGets(int gets) {
            this.gets = gets;
        }

        public void setPuts(int puts) {
            this.puts = puts;
        }

        public long getUptime() {
            return this.uptime;
        }

        public void setUptime(long uptime) {
            this.uptime = uptime;
        }

        public int getThreads() {
            return this.threads;
        }

        public void setThreads(int threads) {
            this.threads = threads;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public int getCpus() {
            return this.cpus;
        }

        public void setCpus(int cpus) {
            this.cpus = cpus;
        }

        public long getProcessCpuTime() {
            return this.processCpuTime;
        }

        public void setProcessCpuTime(long processCpuTime) {
            this.processCpuTime = processCpuTime;
        }

        public boolean isConnected() {
            return this.isConnected;
        }

        public void setConnected(boolean isConnected) {
            this.isConnected = isConnected;
        }
    }

    public static class Alert {
        public static final int SEVERE = 0;
        public static final int ERROR = 1;
        public static final int WARNING = 2;
        public static final int INFO = 3;
        public static AtomicInteger ALERT_ID_CTR = new AtomicInteger();
        private int id;
        private Date timestamp;
        private int severity;
        private String memberName;
        private String description;
        private boolean isAcknowledged;
        private String iso8601Ts;
        private static DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");

        public String getIso8601Ts() {
            return this.iso8601Ts;
        }

        public void setIso8601Ts(String iso8601Ts) {
            this.iso8601Ts = iso8601Ts;
        }

        public boolean isAcknowledged() {
            return this.isAcknowledged;
        }

        public void setAcknowledged(boolean isAcknowledged) {
            this.isAcknowledged = isAcknowledged;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.iso8601Ts = Alert.formatToISOTimestamp(timestamp);
        }

        public int getSeverity() {
            return this.severity;
        }

        public void setSeverity(int severity) {
            this.severity = severity;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public void setMemberName(String memberName) {
            this.memberName = memberName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public static int nextID() {
            return ALERT_ID_CTR.incrementAndGet();
        }

        public static String formatToISOTimestamp(Date date) {
            TimeZone tz = TimeZone.getTimeZone("UTC");
            df.setTimeZone(tz);
            return df.format(date);
        }
    }

    public static class Region {
        private String fullPath;
        private double diskReadsRate;
        private double diskWritesRate;
        private double getsRate;
        private double putsRate;
        private double lruEvictionRate;
        private String regionType;
        private long systemRegionEntryCount;
        private int memberCount;
        private String name;
        private boolean persistentEnabled;
        private long entrySize;
        private boolean wanEnabled;
        private int emptyNode;
        private long diskUsage;
        private String scope;
        private String diskStoreName;
        private boolean diskSynchronous;
        private boolean enableOffHeapMemory;
        private String compressionCodec = "";
        private List<String> memberName = new ArrayList<String>();
        private List<RegionOnMember> regionOnMembers = new ArrayList<RegionOnMember>();
        private CircularFifoBuffer getsPerSecTrend = new CircularFifoBuffer(180);
        private CircularFifoBuffer putsPerSecTrend = new CircularFifoBuffer(180);
        private CircularFifoBuffer diskReadsPerSecTrend = new CircularFifoBuffer(180);
        private CircularFifoBuffer diskWritesPerSecTrend = new CircularFifoBuffer(180);
        public static final int REGION_STAT_GETS_PER_SEC_TREND = 0;
        public static final int REGION_STAT_PUTS_PER_SEC_TREND = 1;
        public static final int REGION_STAT_DISK_READS_PER_SEC_TREND = 3;
        public static final int REGION_STAT_DISK_WRITES_PER_SEC_TREND = 4;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getRegionStatisticTrend(int trendId) {
            Object[] returnArray = null;
            switch (trendId) {
                case 0: {
                    CircularFifoBuffer circularFifoBuffer = this.getsPerSecTrend;
                    synchronized (circularFifoBuffer) {
                        returnArray = this.getsPerSecTrend.toArray();
                        break;
                    }
                }
                case 1: {
                    CircularFifoBuffer circularFifoBuffer = this.putsPerSecTrend;
                    synchronized (circularFifoBuffer) {
                        returnArray = this.putsPerSecTrend.toArray();
                        break;
                    }
                }
                case 3: {
                    CircularFifoBuffer circularFifoBuffer = this.diskReadsPerSecTrend;
                    synchronized (circularFifoBuffer) {
                        returnArray = this.diskReadsPerSecTrend.toArray();
                        break;
                    }
                }
                case 4: {
                    CircularFifoBuffer circularFifoBuffer = this.diskWritesPerSecTrend;
                    synchronized (circularFifoBuffer) {
                        returnArray = this.diskWritesPerSecTrend.toArray();
                        break;
                    }
                }
            }
            return returnArray;
        }

        public boolean isDiskSynchronous() {
            return this.diskSynchronous;
        }

        public void setDiskSynchronous(boolean diskSynchronous) {
            this.diskSynchronous = diskSynchronous;
        }

        public String getDiskStoreName() {
            return this.diskStoreName;
        }

        public void setDiskStoreName(String diskStoreName) {
            this.diskStoreName = diskStoreName;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public int getEmptyNode() {
            return this.emptyNode;
        }

        public void setEmptyNode(int emptyNode) {
            this.emptyNode = emptyNode;
        }

        public long getDiskUsage() {
            return this.diskUsage;
        }

        public void setDiskUsage(long diskUsage) {
            this.diskUsage = diskUsage;
        }

        public void setEntrySize(long entrySize) {
            this.entrySize = entrySize;
        }

        public boolean getWanEnabled() {
            return this.wanEnabled;
        }

        public void setWanEnabled(boolean wanEnabled) {
            this.wanEnabled = wanEnabled;
        }

        public boolean getPersistentEnabled() {
            return this.persistentEnabled;
        }

        public void setPersistentEnabled(boolean persistentEnabled) {
            this.persistentEnabled = persistentEnabled;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public long getEntrySize() {
            return this.entrySize;
        }

        public List<String> getMemberName() {
            return this.memberName;
        }

        public void setMemberName(List<String> memberName) {
            this.memberName = memberName;
        }

        public String getFullPath() {
            return this.fullPath;
        }

        public void setFullPath(String fullPath) {
            this.fullPath = fullPath;
        }

        public double getDiskReadsRate() {
            return this.diskReadsRate;
        }

        public void setDiskReadsRate(double diskReadsRate) {
            this.diskReadsRate = diskReadsRate;
        }

        public double getDiskWritesRate() {
            return this.diskWritesRate;
        }

        public void setDiskWritesRate(double diskWritesRate) {
            this.diskWritesRate = diskWritesRate;
        }

        public CircularFifoBuffer getDiskReadsPerSecTrend() {
            return this.diskReadsPerSecTrend;
        }

        public void setDiskReadsPerSecTrend(CircularFifoBuffer diskReadsPerSecTrend) {
            this.diskReadsPerSecTrend = diskReadsPerSecTrend;
        }

        public CircularFifoBuffer getDiskWritesPerSecTrend() {
            return this.diskWritesPerSecTrend;
        }

        public void setDiskWritesPerSecTrend(CircularFifoBuffer diskWritesPerSecTrend) {
            this.diskWritesPerSecTrend = diskWritesPerSecTrend;
        }

        public double getGetsRate() {
            return this.getsRate;
        }

        public void setGetsRate(double getsRate) {
            this.getsRate = getsRate;
        }

        public double getLruEvictionRate() {
            return this.lruEvictionRate;
        }

        public void setLruEvictionRate(double lruEvictionRate) {
            this.lruEvictionRate = lruEvictionRate;
        }

        public String getRegionType() {
            return this.regionType;
        }

        public void setRegionType(String regionType) {
            this.regionType = regionType;
        }

        public long getSystemRegionEntryCount() {
            return this.systemRegionEntryCount;
        }

        public void setSystemRegionEntryCount(long systemRegionEntryCount) {
            this.systemRegionEntryCount = systemRegionEntryCount;
        }

        public int getMemberCount() {
            return this.memberCount;
        }

        public void setMemberCount(int memberCount) {
            this.memberCount = memberCount;
        }

        public double getPutsRate() {
            return this.putsRate;
        }

        public void setPutsRate(double putsRate) {
            this.putsRate = putsRate;
        }

        public CircularFifoBuffer getGetsPerSecTrend() {
            return this.getsPerSecTrend;
        }

        public void setGetsPerSecTrend(CircularFifoBuffer getsPerSecTrend) {
            this.getsPerSecTrend = getsPerSecTrend;
        }

        public CircularFifoBuffer getPutsPerSecTrend() {
            return this.putsPerSecTrend;
        }

        public void setPutsPerSecTrend(CircularFifoBuffer putsPerSecTrend) {
            this.putsPerSecTrend = putsPerSecTrend;
        }

        public boolean isEnableOffHeapMemory() {
            return this.enableOffHeapMemory;
        }

        public void setEnableOffHeapMemory(boolean enableOffHeapMemory) {
            this.enableOffHeapMemory = enableOffHeapMemory;
        }

        public String getCompressionCodec() {
            return this.compressionCodec;
        }

        public void setCompressionCodec(String compressionCodec) {
            this.compressionCodec = compressionCodec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RegionOnMember[] getRegionOnMembers() {
            RegionOnMember[] regionOnMembers = null;
            List<RegionOnMember> list = this.regionOnMembers;
            synchronized (list) {
                regionOnMembers = new RegionOnMember[this.regionOnMembers.size()];
                regionOnMembers = this.regionOnMembers.toArray(regionOnMembers);
            }
            return regionOnMembers;
        }

        public void setRegionOnMembers(List<RegionOnMember> regionOnMembers) {
            this.regionOnMembers = regionOnMembers;
        }
    }

    public static class RegionOnMember {
        public static final int REGION_ON_MEMBER_STAT_GETS_PER_SEC_TREND = 0;
        public static final int REGION_ON_MEMBER_STAT_PUTS_PER_SEC_TREND = 1;
        public static final int REGION_ON_MEMBER_STAT_DISK_READS_PER_SEC_TREND = 3;
        public static final int REGION_ON_MEMBER_STAT_DISK_WRITES_PER_SEC_TREND = 4;
        private String regionFullPath;
        private String memberName;
        private long entrySize;
        private long entryCount;
        private double getsRate;
        private double putsRate;
        private double diskGetsRate;
        private double diskPutsRate;
        private int localMaxMemory;
        private CircularFifoBuffer getsPerSecTrend = new CircularFifoBuffer(180);
        private CircularFifoBuffer putsPerSecTrend = new CircularFifoBuffer(180);
        private CircularFifoBuffer diskReadsPerSecTrend = new CircularFifoBuffer(180);
        private CircularFifoBuffer diskWritesPerSecTrend = new CircularFifoBuffer(180);

        public long getEntrySize() {
            return this.entrySize;
        }

        public void setEntrySize(long entrySize) {
            this.entrySize = entrySize;
        }

        public long getEntryCount() {
            return this.entryCount;
        }

        public void setEntryCount(long entryCount) {
            this.entryCount = entryCount;
        }

        public double getPutsRate() {
            return this.putsRate;
        }

        public void setPutsRate(double putsRate) {
            this.putsRate = putsRate;
        }

        public double getGetsRate() {
            return this.getsRate;
        }

        public void setGetsRate(double getsRate) {
            this.getsRate = getsRate;
        }

        public double getDiskGetsRate() {
            return this.diskGetsRate;
        }

        public void setDiskGetsRate(double diskGetsRate) {
            this.diskGetsRate = diskGetsRate;
        }

        public double getDiskPutsRate() {
            return this.diskPutsRate;
        }

        public void setDiskPutsRate(double diskPutsRate) {
            this.diskPutsRate = diskPutsRate;
        }

        public int getLocalMaxMemory() {
            return this.localMaxMemory;
        }

        public void setLocalMaxMemory(int localMaxMemory) {
            this.localMaxMemory = localMaxMemory;
        }

        public CircularFifoBuffer getGetsPerSecTrend() {
            return this.getsPerSecTrend;
        }

        public void setGetsPerSecTrend(CircularFifoBuffer getsPerSecTrend) {
            this.getsPerSecTrend = getsPerSecTrend;
        }

        public CircularFifoBuffer getPutsPerSecTrend() {
            return this.putsPerSecTrend;
        }

        public void setPutsPerSecTrend(CircularFifoBuffer putsPerSecTrend) {
            this.putsPerSecTrend = putsPerSecTrend;
        }

        public CircularFifoBuffer getDiskReadsPerSecTrend() {
            return this.diskReadsPerSecTrend;
        }

        public void setDiskReadsPerSecTrend(CircularFifoBuffer diskReadsPerSecTrend) {
            this.diskReadsPerSecTrend = diskReadsPerSecTrend;
        }

        public CircularFifoBuffer getDiskWritesPerSecTrend() {
            return this.diskWritesPerSecTrend;
        }

        public void setDiskWritesPerSecTrend(CircularFifoBuffer diskWritesPerSecTrend) {
            this.diskWritesPerSecTrend = diskWritesPerSecTrend;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getRegionOnMemberStatisticTrend(int trendId) {
            Object[] returnArray = null;
            switch (trendId) {
                case 0: {
                    CircularFifoBuffer circularFifoBuffer = this.getsPerSecTrend;
                    synchronized (circularFifoBuffer) {
                        returnArray = this.getsPerSecTrend.toArray();
                        break;
                    }
                }
                case 1: {
                    CircularFifoBuffer circularFifoBuffer = this.putsPerSecTrend;
                    synchronized (circularFifoBuffer) {
                        returnArray = this.putsPerSecTrend.toArray();
                        break;
                    }
                }
                case 3: {
                    CircularFifoBuffer circularFifoBuffer = this.diskReadsPerSecTrend;
                    synchronized (circularFifoBuffer) {
                        returnArray = this.diskReadsPerSecTrend.toArray();
                        break;
                    }
                }
                case 4: {
                    CircularFifoBuffer circularFifoBuffer = this.diskWritesPerSecTrend;
                    synchronized (circularFifoBuffer) {
                        returnArray = this.diskWritesPerSecTrend.toArray();
                        break;
                    }
                }
            }
            return returnArray;
        }

        public String getRegionFullPath() {
            return this.regionFullPath;
        }

        public void setRegionFullPath(String regionFullPath) {
            this.regionFullPath = regionFullPath;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public void setMemberName(String memberName) {
            this.memberName = memberName;
        }
    }

    public static class Statement {
        private String queryDefn;
        private long numTimesCompiled;
        private long numExecution;
        private long numExecutionsInProgress;
        private long numTimesGlobalIndexLookup;
        private long numRowsModified;
        private long parseTime;
        private long bindTime;
        private long optimizeTime;
        private long routingInfoTime;
        private long generateTime;
        private long totalCompilationTime;
        private long executionTime;
        private long projectionTime;
        private long totalExecutionTime;
        private long rowsModificationTime;
        private long qNNumRowsSeen;
        private long qNMsgSendTime;
        private long qNMsgSerTime;
        private long qNRespDeSerTime;

        public static String[] getGridColumnNames() {
            String[] colNames = new String[]{"Query", "NumExecution", "TotalExecutionTime(ns)", "NumExecutionsInProgress", "NumTimesCompiled", "NumTimesGlobalIndexLookup", "NumRowsModified", "ParseTime(ms)", "BindTime(ms)", "OptimizeTime(ms)", "RoutingInfoTime(ms)", "GenerateTime(ms)", "TotalCompilationTime(ms)", "ExecutionTime(ns)", "ProjectionTime(ns)", "RowsModificationTime(ns)", "QNNumRowsSeen", "QNMsgSendTime(ns)", "QNMsgSerTime(ns)", "QNRespDeSerTime(ns)"};
            return colNames;
        }

        public static String[] getGridColumnAttributes() {
            String[] colAttributes = new String[]{"Query", "NumExecution", "TotalExecutionTime", "NumExecutionsInProgress", "NumTimesCompiled", "NumTimesGlobalIndexLookup", "NumRowsModified", "ParseTime", "BindTime", "OptimizeTime", "RoutingInfoTime", "GenerateTime", "TotalCompilationTime", "ExecutionTime", "ProjectionTime", "RowsModificationTime", "QNNumRowsSeen", "QNMsgSendTime", "QNMsgSerTime", "QNRespDeSerTime"};
            return colAttributes;
        }

        public static int[] getGridColumnWidths() {
            int[] colWidths = new int[]{300, 150, 160, 180, 150, 200, 150, 130, 130, 160, 140, 180, 170, 160, 130, 190, 170, 170, 170, 200};
            return colWidths;
        }

        public String getQueryDefinition() {
            return this.queryDefn;
        }

        public void setQueryDefinition(String queryDefn) {
            this.queryDefn = queryDefn;
        }

        public long getNumTimesCompiled() {
            return this.numTimesCompiled;
        }

        public void setNumTimesCompiled(long numTimesCompiled) {
            this.numTimesCompiled = numTimesCompiled;
        }

        public long getNumExecution() {
            return this.numExecution;
        }

        public void setNumExecution(long numExecution) {
            this.numExecution = numExecution;
        }

        public long getNumExecutionsInProgress() {
            return this.numExecutionsInProgress;
        }

        public void setNumExecutionsInProgress(long numExecutionsInProgress) {
            this.numExecutionsInProgress = numExecutionsInProgress;
        }

        public long getNumTimesGlobalIndexLookup() {
            return this.numTimesGlobalIndexLookup;
        }

        public void setNumTimesGlobalIndexLookup(long numTimesGlobalIndexLookup) {
            this.numTimesGlobalIndexLookup = numTimesGlobalIndexLookup;
        }

        public long getNumRowsModified() {
            return this.numRowsModified;
        }

        public void setNumRowsModified(long numRowsModified) {
            this.numRowsModified = numRowsModified;
        }

        public long getParseTime() {
            return this.parseTime;
        }

        public void setParseTime(long parseTime) {
            this.parseTime = parseTime;
        }

        public long getBindTime() {
            return this.bindTime;
        }

        public void setBindTime(long bindTime) {
            this.bindTime = bindTime;
        }

        public long getOptimizeTime() {
            return this.optimizeTime;
        }

        public void setOptimizeTime(long optimizeTime) {
            this.optimizeTime = optimizeTime;
        }

        public long getRoutingInfoTime() {
            return this.routingInfoTime;
        }

        public void setRoutingInfoTime(long routingInfoTime) {
            this.routingInfoTime = routingInfoTime;
        }

        public long getGenerateTime() {
            return this.generateTime;
        }

        public void setGenerateTime(long generateTime) {
            this.generateTime = generateTime;
        }

        public long getTotalCompilationTime() {
            return this.totalCompilationTime;
        }

        public void setTotalCompilationTime(long totalCompilationTime) {
            this.totalCompilationTime = totalCompilationTime;
        }

        public long getExecutionTime() {
            return this.executionTime;
        }

        public void setExecutionTime(long executionTime) {
            this.executionTime = executionTime;
        }

        public long getProjectionTime() {
            return this.projectionTime;
        }

        public void setProjectionTime(long projectionTime) {
            this.projectionTime = projectionTime;
        }

        public long getTotalExecutionTime() {
            return this.totalExecutionTime;
        }

        public void setTotalExecutionTime(long totalExecutionTime) {
            this.totalExecutionTime = totalExecutionTime;
        }

        public long getRowsModificationTime() {
            return this.rowsModificationTime;
        }

        public void setRowsModificationTime(long rowsModificationTime) {
            this.rowsModificationTime = rowsModificationTime;
        }

        public long getqNNumRowsSeen() {
            return this.qNNumRowsSeen;
        }

        public void setqNNumRowsSeen(long qNNumRowsSeen) {
            this.qNNumRowsSeen = qNNumRowsSeen;
        }

        public long getqNMsgSendTime() {
            return this.qNMsgSendTime;
        }

        public void setqNMsgSendTime(long qNMsgSendTime) {
            this.qNMsgSendTime = qNMsgSendTime;
        }

        public long getqNMsgSerTime() {
            return this.qNMsgSerTime;
        }

        public void setqNMsgSerTime(long qNMsgSerTime) {
            this.qNMsgSerTime = qNMsgSerTime;
        }

        public long getqNRespDeSerTime() {
            return this.qNRespDeSerTime;
        }

        public void setqNRespDeSerTime(long qNRespDeSerTime) {
            this.qNRespDeSerTime = qNRespDeSerTime;
        }
    }

    public static class Member {
        private String gemfireVersion;
        private boolean manager;
        private int totalRegionCount;
        private String host;
        private String hostnameForClients;
        private String bindAddress;
        private long currentHeapSize;
        private long maxHeapSize;
        private int avgHeapUsage;
        private long OffHeapFreeSize;
        private long OffHeapUsedSize;
        private long totalBytesOnDisk;
        private String memberPort;
        private double cpuUsage = 0.0;
        private double hostCpuUsage = 0.0;
        private long uptime;
        private String name;
        private double getsRate;
        private double putsRate;
        private boolean isCache;
        private boolean isGateway;
        private boolean isLocator;
        private boolean isServer;
        private double loadAverage;
        private int numThreads;
        private long totalFileDescriptorOpen;
        private long garbageCollectionCount = 0L;
        private double throughputWrites;
        private double throughputReads;
        private long totalDiskUsage;
        private String queueBacklog;
        private String id;
        private long numSqlfireClients = 0L;
        private List<String> serverGroups = new ArrayList<String>();
        private List<String> redundancyZones = new ArrayList<String>();
        private CircularFifoBuffer cpuUsageSamples = new CircularFifoBuffer(180);
        private CircularFifoBuffer heapUsageSamples = new CircularFifoBuffer(180);
        private HashMap<String, Region> memberRegions = new HashMap();
        private HashMap<String, Client> memberClientsHMap = new HashMap();
        private CircularFifoBuffer totalBytesOnDiskSamples = new CircularFifoBuffer(180);
        private CircularFifoBuffer getsPerSecond = new CircularFifoBuffer(180);
        private CircularFifoBuffer putsPerSecond = new CircularFifoBuffer(180);
        private CircularFifoBuffer throughputWritesTrend = new CircularFifoBuffer(180);
        private CircularFifoBuffer throughputReadsTrend = new CircularFifoBuffer(180);
        private CircularFifoBuffer garbageCollectionSamples = new CircularFifoBuffer(180);
        private long previousJVMPauseCount = 0L;
        private GatewayReceiver gatewayReceiver = null;
        private List<GatewaySender> gatewaySenderList = new ArrayList<GatewaySender>();
        private List<AsyncEventQueue> asyncEventQueueList = new ArrayList<AsyncEventQueue>();
        public static final int MEMBER_STAT_GARBAGE_COLLECTION = 0;
        public static final int MEMBER_STAT_HEAP_USAGE_SAMPLE = 1;
        public static final int MEMBER_STAT_CPU_USAGE_SAMPLE = 2;
        public static final int MEMBER_STAT_GETS_PER_SECOND = 3;
        public static final int MEMBER_STAT_PUTS_PER_SECOND = 4;
        public static final int MEMBER_STAT_THROUGHPUT_WRITES = 5;
        public static final int MEMBER_STAT_THROUGHPUT_READS = 6;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Region[] getMemberRegionsList() {
            Region[] memberReg = null;
            HashMap<String, Region> hashMap = this.memberRegions;
            synchronized (hashMap) {
                memberReg = new Region[this.memberRegions.size()];
                memberReg = this.memberRegions.values().toArray(memberReg);
            }
            return memberReg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Client[] getMemberClients() {
            Client[] memberClients = null;
            HashMap<String, Client> hashMap = this.memberClientsHMap;
            synchronized (hashMap) {
                memberClients = new Client[this.memberClientsHMap.size()];
                memberClients = this.memberClientsHMap.values().toArray(memberClients);
            }
            return memberClients;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GatewaySender[] getMemberGatewaySenders() {
            GatewaySender[] memberGWS = null;
            List<GatewaySender> list = this.gatewaySenderList;
            synchronized (list) {
                memberGWS = new GatewaySender[this.gatewaySenderList.size()];
                memberGWS = this.gatewaySenderList.toArray(memberGWS);
            }
            return memberGWS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AsyncEventQueue[] getMemberAsyncEventQueueList() {
            AsyncEventQueue[] memberAEQ = null;
            List<AsyncEventQueue> list = this.asyncEventQueueList;
            synchronized (list) {
                memberAEQ = new AsyncEventQueue[this.asyncEventQueueList.size()];
                memberAEQ = this.asyncEventQueueList.toArray(memberAEQ);
            }
            return memberAEQ;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getMemberStatisticTrend(int trendId) {
            Object[] returnArray = null;
            switch (trendId) {
                case 0: {
                    CircularFifoBuffer circularFifoBuffer = this.garbageCollectionSamples;
                    synchronized (circularFifoBuffer) {
                        returnArray = this.garbageCollectionSamples.toArray();
                        break;
                    }
                }
                case 1: {
                    CircularFifoBuffer circularFifoBuffer = this.heapUsageSamples;
                    synchronized (circularFifoBuffer) {
                        returnArray = this.heapUsageSamples.toArray();
                        break;
                    }
                }
                case 2: {
                    CircularFifoBuffer circularFifoBuffer = this.cpuUsageSamples;
                    synchronized (circularFifoBuffer) {
                        returnArray = this.cpuUsageSamples.toArray();
                        break;
                    }
                }
                case 3: {
                    CircularFifoBuffer circularFifoBuffer = this.getsPerSecond;
                    synchronized (circularFifoBuffer) {
                        returnArray = this.getsPerSecond.toArray();
                        break;
                    }
                }
                case 4: {
                    CircularFifoBuffer circularFifoBuffer = this.putsPerSecond;
                    synchronized (circularFifoBuffer) {
                        returnArray = this.putsPerSecond.toArray();
                        break;
                    }
                }
                case 5: {
                    CircularFifoBuffer circularFifoBuffer = this.throughputWritesTrend;
                    synchronized (circularFifoBuffer) {
                        returnArray = this.throughputWritesTrend.toArray();
                        break;
                    }
                }
                case 6: {
                    CircularFifoBuffer circularFifoBuffer = this.throughputReadsTrend;
                    synchronized (circularFifoBuffer) {
                        returnArray = this.throughputReadsTrend.toArray();
                        break;
                    }
                }
            }
            return returnArray;
        }

        public String getGemfireVersion() {
            return this.gemfireVersion;
        }

        public void setGemfireVersion(String gemfireVersion) {
            this.gemfireVersion = gemfireVersion;
        }

        public String getMemberPort() {
            return this.memberPort;
        }

        public void setMemberPort(String memberPort) {
            this.memberPort = memberPort;
        }

        public double getThroughputWrites() {
            return this.throughputWrites;
        }

        public void setThroughputWrites(double throughputWrites) {
            this.throughputWrites = throughputWrites;
        }

        public double getThroughputReads() {
            return this.throughputReads;
        }

        public void setThroughputReads(double throughputReads) {
            this.throughputReads = throughputReads;
        }

        public long getTotalDiskUsage() {
            return this.totalDiskUsage;
        }

        public void setTotalDiskUsage(long totalDiskUsage) {
            this.totalDiskUsage = totalDiskUsage;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public double getLoadAverage() {
            return this.loadAverage;
        }

        public void setLoadAverage(Double loadAverage) {
            this.loadAverage = loadAverage;
        }

        public String getHost() {
            return this.host;
        }

        public String getHostnameForClients() {
            if (StringUtils.isNotBlank((String)this.hostnameForClients)) {
                return this.hostnameForClients;
            }
            if (StringUtils.isNotBlank((String)this.bindAddress)) {
                return this.bindAddress;
            }
            return null;
        }

        public long getUptime() {
            return this.uptime;
        }

        public String getQueueBacklog() {
            return this.queueBacklog;
        }

        public HashMap<String, Region> getMemberRegions() {
            return this.memberRegions;
        }

        public void setMemberRegions(HashMap<String, Region> memberRegions) {
            this.memberRegions = memberRegions;
        }

        public long getCurrentHeapSize() {
            return this.currentHeapSize;
        }

        public void setCurrentHeapSize(long currentHeapSize) {
            this.currentHeapSize = currentHeapSize;
        }

        public long getMaxHeapSize() {
            return this.maxHeapSize;
        }

        public void setMaxHeapSize(long maxHeapSize) {
            this.maxHeapSize = maxHeapSize;
        }

        public boolean isManager() {
            return this.manager;
        }

        public void setManager(boolean manager) {
            this.manager = manager;
        }

        public int getAvgHeapUsage() {
            return this.avgHeapUsage;
        }

        public void setAvgHeapUsage(int avgHeapUsage) {
            this.avgHeapUsage = avgHeapUsage;
        }

        public long getOffHeapFreeSize() {
            return this.OffHeapFreeSize;
        }

        public void setOffHeapFreeSize(long offHeapFreeSize) {
            this.OffHeapFreeSize = offHeapFreeSize;
        }

        public long getOffHeapUsedSize() {
            return this.OffHeapUsedSize;
        }

        public void setOffHeapUsedSize(long offHeapUsedSize) {
            this.OffHeapUsedSize = offHeapUsedSize;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setHostnameForClients(String hostnameForClients) {
            this.hostnameForClients = hostnameForClients;
        }

        public void setBindAddress(String bindAddress) {
            this.bindAddress = bindAddress;
        }

        public void setUptime(long uptime) {
            this.uptime = uptime;
        }

        public void setQueueBacklog(String queueBacklog) {
            this.queueBacklog = queueBacklog;
        }

        public int getTotalRegionCount() {
            return this.totalRegionCount;
        }

        public void setTotalRegionCount(int totalRegionCount) {
            this.totalRegionCount = totalRegionCount;
        }

        public long getTotalBytesOnDisk() {
            return this.totalBytesOnDisk;
        }

        public void setTotalBytesOnDisk(long totalBytesOnDisk) {
            this.totalBytesOnDisk = totalBytesOnDisk;
        }

        public double getCpuUsage() {
            return this.cpuUsage;
        }

        public void setCpuUsage(double cpuUsage) {
            this.cpuUsage = cpuUsage;
        }

        public double getHostCpuUsage() {
            return this.hostCpuUsage;
        }

        public void setHostCpuUsage(double hostCpuUsage) {
            this.hostCpuUsage = hostCpuUsage;
        }

        public double getGetsRate() {
            return this.getsRate;
        }

        public void setGetsRate(double getsRate) {
            this.getsRate = getsRate;
        }

        public double getPutsRate() {
            return this.putsRate;
        }

        public void setPutsRate(double putsRate) {
            this.putsRate = putsRate;
        }

        public HashMap<String, Client> getMemberClientsHMap() {
            return this.memberClientsHMap;
        }

        public void setMemberClientsHMap(HashMap<String, Client> memberClientsHMap) {
            this.memberClientsHMap = memberClientsHMap;
        }

        public boolean isCache() {
            return this.isCache;
        }

        public void setCache(boolean isCache) {
            this.isCache = isCache;
        }

        public boolean isGateway() {
            return this.isGateway;
        }

        public void setGateway(boolean isGateway) {
            this.isGateway = isGateway;
        }

        public int getNumThreads() {
            return this.numThreads;
        }

        public void setNumThreads(int numThreads) {
            this.numThreads = numThreads;
        }

        public long getTotalFileDescriptorOpen() {
            return this.totalFileDescriptorOpen;
        }

        public void setTotalFileDescriptorOpen(long totalFileDescriptorOpen) {
            this.totalFileDescriptorOpen = totalFileDescriptorOpen;
        }

        public long getGarbageCollectionCount() {
            return this.garbageCollectionCount;
        }

        public void setGarbageCollectionCount(long garbageCollectionCount) {
            this.garbageCollectionCount = garbageCollectionCount;
        }

        public boolean isLocator() {
            return this.isLocator;
        }

        public void setLocator(boolean isLocator) {
            this.isLocator = isLocator;
        }

        public GatewayReceiver getGatewayReceiver() {
            return this.gatewayReceiver;
        }

        public void setGatewayReceiver(GatewayReceiver gatewayReceiver) {
            this.gatewayReceiver = gatewayReceiver;
        }

        public List<GatewaySender> getGatewaySenderList() {
            return this.gatewaySenderList;
        }

        public void setGatewaySenderList(List<GatewaySender> gatewaySenderList) {
            this.gatewaySenderList = gatewaySenderList;
        }

        public List<AsyncEventQueue> getAsyncEventQueueList() {
            return this.asyncEventQueueList;
        }

        public void setAsyncEventQueueList(List<AsyncEventQueue> asyncEventQueueList) {
            this.asyncEventQueueList = asyncEventQueueList;
        }

        public boolean isServer() {
            return this.isServer;
        }

        public void setServer(boolean isServer) {
            this.isServer = isServer;
        }

        public List<String> getServerGroups() {
            return this.serverGroups;
        }

        public void setServerGroups(List<String> serverGroups) {
            this.serverGroups = serverGroups;
        }

        public List<String> getRedundancyZones() {
            return this.redundancyZones;
        }

        public void setRedundancyZones(List<String> redundancyZones) {
            this.redundancyZones = redundancyZones;
        }

        public CircularFifoBuffer getCpuUsageSamples() {
            return this.cpuUsageSamples;
        }

        public void setCpuUsageSamples(CircularFifoBuffer cpuUsageSamples) {
            this.cpuUsageSamples = cpuUsageSamples;
        }

        public CircularFifoBuffer getHeapUsageSamples() {
            return this.heapUsageSamples;
        }

        public void setHeapUsageSamples(CircularFifoBuffer heapUsageSamples) {
            this.heapUsageSamples = heapUsageSamples;
        }

        public CircularFifoBuffer getTotalBytesOnDiskSamples() {
            return this.totalBytesOnDiskSamples;
        }

        public void setTotalBytesOnDiskSamples(CircularFifoBuffer totalBytesOnDiskSamples) {
            this.totalBytesOnDiskSamples = totalBytesOnDiskSamples;
        }

        public CircularFifoBuffer getGetsPerSecond() {
            return this.getsPerSecond;
        }

        public void setGetsPerSecond(CircularFifoBuffer getsPerSecond) {
            this.getsPerSecond = getsPerSecond;
        }

        public CircularFifoBuffer getPutsPerSecond() {
            return this.putsPerSecond;
        }

        public void setPutsPerSecond(CircularFifoBuffer putsPerSecond) {
            this.putsPerSecond = putsPerSecond;
        }

        public CircularFifoBuffer getThroughputWritesTrend() {
            return this.throughputWritesTrend;
        }

        public void setThroughputWritesTrend(CircularFifoBuffer throughputWritesTrend) {
            this.throughputWritesTrend = throughputWritesTrend;
        }

        public CircularFifoBuffer getThroughputReadsTrend() {
            return this.throughputReadsTrend;
        }

        public void setThroughputReadsTrend(CircularFifoBuffer throughputReadsTrend) {
            this.throughputReadsTrend = throughputReadsTrend;
        }

        public CircularFifoBuffer getGarbageCollectionSamples() {
            return this.garbageCollectionSamples;
        }

        public void setGarbageCollectionSamples(CircularFifoBuffer garbageCollectionSamples) {
            this.garbageCollectionSamples = garbageCollectionSamples;
        }

        public long getPreviousJVMPauseCount() {
            return this.previousJVMPauseCount;
        }

        public void setPreviousJVMPauseCount(long previousJVMPauseCount) {
            this.previousJVMPauseCount = previousJVMPauseCount;
        }

        public long getNumSqlfireClients() {
            return this.numSqlfireClients;
        }

        public void setNumSqlfireClients(long numSqlfireClients) {
            this.numSqlfireClients = numSqlfireClients;
        }

        public void updateMemberClientsHMap(HashMap<String, Client> memberClientsHM) {
            if (LAST_UPDATE_TIME == 0L) {
                LAST_UPDATE_TIME = System.nanoTime();
            }
            long systemNanoTime = System.nanoTime();
            for (Map.Entry<String, Client> entry : memberClientsHM.entrySet()) {
                String clientId = entry.getKey();
                Client client = entry.getValue();
                if (this.memberClientsHMap.get(clientId) != null) {
                    Client existingClient = this.memberClientsHMap.get(clientId);
                    Client updatedClient = memberClientsHM.get(clientId);
                    existingClient.setConnected(updatedClient.isConnected());
                    existingClient.setGets(updatedClient.getGets());
                    existingClient.setPuts(updatedClient.getPuts());
                    existingClient.setCpus(updatedClient.getCpus());
                    existingClient.setQueueSize(updatedClient.getQueueSize());
                    existingClient.setStatus(updatedClient.getStatus());
                    existingClient.setThreads(updatedClient.getThreads());
                    existingClient.setClientCQCount(updatedClient.getClientCQCount());
                    existingClient.setSubscriptionEnabled(updatedClient.isSubscriptionEnabled());
                    long elapsedTime = updatedClient.getUptime() - existingClient.getUptime();
                    existingClient.setUptime(updatedClient.getUptime());
                    long lastCPUTime = existingClient.getProcessCpuTime();
                    long currCPUTime = updatedClient.getProcessCpuTime();
                    double newCPUTime = (currCPUTime - lastCPUTime) / elapsedTime / 1000000000L;
                    double newCPUUsage = 0.0;
                    int availableCpus = updatedClient.getCpus();
                    if (availableCpus > 0) {
                        newCPUUsage = newCPUTime / (double)availableCpus;
                    }
                    existingClient.setCpuUsage(newCPUUsage);
                    existingClient.setProcessCpuTime(currCPUTime);
                    continue;
                }
                this.memberClientsHMap.put(clientId, client);
            }
            HashMap<String, Client> memberClientsHMapNew = new HashMap<String, Client>();
            for (Map.Entry<String, Client> entry : this.memberClientsHMap.entrySet()) {
                String clientId = entry.getKey();
                if (memberClientsHM.get(clientId) == null) continue;
                memberClientsHMapNew.put(clientId, this.memberClientsHMap.get(clientId));
            }
            this.setMemberClientsHMap(memberClientsHMapNew);
            LAST_UPDATE_TIME = systemNanoTime;
        }
    }
}

