/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.DataSerializable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.management.internal.security.ResourcePermissions;
import org.apache.geode.security.ResourcePermission;

public class TouchReplicatedRegionEntriesFunction
implements Function,
Declarable,
DataSerializable {
    private static final long serialVersionUID = -7424895036162243564L;
    public static final String ID = "touch-replicated-region-entries";

    public void execute(FunctionContext context) {
        Region region;
        Object[] arguments = (Object[])context.getArguments();
        Cache cache = context.getCache();
        String regionName = (String)arguments[0];
        Set keys = (Set)arguments[1];
        if (cache.getLogger().fineEnabled()) {
            String builder = "Function touch-replicated-region-entries received request to touch " + regionName + "->" + String.valueOf(keys);
            cache.getLogger().fine(builder);
        }
        if ((region = cache.getRegion(regionName)) != null) {
            region.getAll((Collection)keys);
        }
        context.getResultSender().lastResult((Object)true);
    }

    public Collection<ResourcePermission> getRequiredPermissions(String regionName) {
        return Collections.singletonList(ResourcePermissions.DATA_READ);
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return false;
    }

    public boolean hasResult() {
        return true;
    }

    public void toData(DataOutput out) {
    }

    public void fromData(DataInput in) {
    }
}

