/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.DataSerializable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.security.ResourcePermission;

public class TouchPartitionedRegionEntriesFunction
implements Function,
Declarable,
DataSerializable {
    private static final long serialVersionUID = -3700389655056961153L;
    public static final String ID = "touch-partitioned-region-entries";

    public void execute(FunctionContext context) {
        RegionFunctionContext rfc = (RegionFunctionContext)context;
        Set keys = rfc.getFilter();
        Cache cache = context.getCache();
        Region primaryDataSet = this.getLocalDataForContextViaRegionHelper(rfc);
        if (cache.getLogger().fineEnabled()) {
            String builder = "Function touch-partitioned-region-entries received request to touch " + primaryDataSet.getFullPath() + "->" + String.valueOf(keys);
            cache.getLogger().fine(builder);
        }
        for (String key : keys) {
            primaryDataSet.get((Object)key);
        }
        context.getResultSender().lastResult((Object)true);
    }

    public Collection<ResourcePermission> getRequiredPermissions(String regionName) {
        return Collections.singletonList(new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName));
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public boolean isHA() {
        return false;
    }

    public boolean hasResult() {
        return true;
    }

    public void toData(DataOutput out) {
    }

    public void fromData(DataInput in) {
    }

    Region getLocalDataForContextViaRegionHelper(RegionFunctionContext rfc) {
        return PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rfc);
    }
}

