/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.gatewaydelta;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.wan.GatewaySenderEventCallbackArgument;
import org.apache.geode.modules.gatewaydelta.GatewayDeltaEvent;

public class GatewayDeltaEventApplicationCacheListener
extends CacheListenerAdapter<String, GatewayDeltaEvent>
implements Declarable {
    private final Cache cache = CacheFactory.getAnyInstance();

    GatewayDeltaEventApplicationCacheListener() {
    }

    public void afterCreate(EntryEvent<String, GatewayDeltaEvent> event) {
        System.out.println("GatewayDeltaApplierCacheListener event: " + String.valueOf(event));
        EntryEventImpl eventImpl = (EntryEventImpl)event;
        if (this.cache.getLogger().fineEnabled()) {
            String builder = "GatewayDeltaApplierCacheListener: Received event for " + (String)event.getKey() + "->" + String.valueOf(event.getNewValue()) + ".";
            this.cache.getLogger().fine(builder);
        }
        Object callbackArgument = eventImpl.getRawCallbackArgument();
        System.out.println("GatewayDeltaApplierCacheListener callbackArgument: " + String.valueOf(callbackArgument));
        if (callbackArgument instanceof GatewaySenderEventCallbackArgument) {
            GatewayDeltaEvent delta = (GatewayDeltaEvent)event.getNewValue();
            delta.apply(this.cache);
            System.out.println("Applied " + String.valueOf(delta));
            if (this.cache.getLogger().fineEnabled()) {
                this.cache.getLogger().fine("GatewayDeltaApplierCacheListener: Applied " + String.valueOf(delta));
            }
        }
    }
}

