/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.util;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class ModuleStatistics {
    private static final StatisticsType type;
    private static final int cacheHitsId;
    private static final int cacheMissesId;
    private static final int hibernateEntityDestroyJobsScheduledId;
    private final Statistics stats;
    private static ModuleStatistics instance;

    private ModuleStatistics(StatisticsFactory factory) {
        this.stats = factory.createAtomicStatistics(type, "PluginStatistics");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleStatistics getInstance(DistributedSystem system) {
        Class<ModuleStatistics> clazz = ModuleStatistics.class;
        synchronized (ModuleStatistics.class) {
            if (instance == null) {
                instance = new ModuleStatistics((StatisticsFactory)system);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void incCacheHit() {
        this.stats.incLong(cacheHitsId, 1L);
    }

    public long getCacheHits() {
        return this.stats.getLong(cacheHitsId);
    }

    public void incCacheMiss() {
        this.stats.incLong(cacheMissesId, 1L);
    }

    public long getCacheMiss() {
        return this.stats.getLong(cacheMissesId);
    }

    public void incHibernateDestroyJobsScheduled() {
        this.stats.incLong(hibernateEntityDestroyJobsScheduledId, 1L);
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        type = f.createType("pluginStats", "statistics for hibernate plugin and hibernate L2 cache", new StatisticDescriptor[]{f.createLongCounter("cacheHits", "number of times an entity was found in L2 cache", "count"), f.createLongCounter("cacheMisses", "number of times an entity was NOT found in l2 cache", "count"), f.createLongCounter("hibernateEntityDestroyJobsScheduled", "number of entities scheduled for destroy because of version conflict with a remote member", "jobs")});
        cacheHitsId = type.nameToId("cacheHits");
        cacheMissesId = type.nameToId("cacheMisses");
        hibernateEntityDestroyJobsScheduledId = type.nameToId("hibernateEntityDestroyJobsScheduled");
    }
}

