/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.util;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.modules.util.CreateRegionFunction;
import org.apache.geode.modules.util.RegionSizeFunction;
import org.apache.geode.modules.util.TouchPartitionedRegionEntriesFunction;
import org.apache.geode.modules.util.TouchReplicatedRegionEntriesFunction;

public class BootstrappingFunction
implements Function,
MembershipListener {
    private static final long serialVersionUID = 1856043174458190605L;
    public static final String ID = "bootstrapping-function";
    private static final int TIME_TO_WAIT_FOR_CACHE = Integer.getInteger("gemfiremodules.timeToWaitForCache", 30000);

    public void execute(FunctionContext context) {
        Cache cache = this.verifyCacheExists();
        this.registerAsMembershipListener(cache);
        this.registerFunctions();
        context.getResultSender().lastResult((Object)Boolean.TRUE);
    }

    private Cache verifyCacheExists() {
        Cache cache = null;
        for (int timeToWait = 0; timeToWait < TIME_TO_WAIT_FOR_CACHE; timeToWait += 250) {
            try {
                cache = CacheFactory.getAnyInstance();
                break;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(250L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        if (cache == null) {
            cache = new CacheFactory().create();
        }
        return cache;
    }

    private void registerAsMembershipListener(Cache cache) {
        DM dm = ((InternalDistributedSystem)cache.getDistributedSystem()).getDistributionManager();
        dm.addMembershipListener((MembershipListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerFunctions() {
        String string = ID;
        synchronized (ID) {
            if (!FunctionService.isRegistered((String)"create-region-function")) {
                FunctionService.registerFunction((Function)new CreateRegionFunction());
            }
            if (!FunctionService.isRegistered((String)"touch-partitioned-region-entries")) {
                FunctionService.registerFunction((Function)new TouchPartitionedRegionEntriesFunction());
            }
            if (!FunctionService.isRegistered((String)"touch-replicated-region-entries")) {
                FunctionService.registerFunction((Function)new TouchReplicatedRegionEntriesFunction());
            }
            if (!FunctionService.isRegistered((String)"region-size-function")) {
                FunctionService.registerFunction((Function)new RegionSizeFunction());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void bootstrapMember(InternalDistributedMember member) {
        Cache cache = CacheFactory.getAnyInstance();
        Execution execution = FunctionService.onMember((DistributedMember)member);
        ResultCollector collector = execution.execute((Function)this);
        try {
            collector.getResult();
        }
        catch (Exception e) {
            cache.getLogger().warning("Caught unexpected exception:", (Throwable)e);
        }
    }

    public String getId() {
        return ID;
    }

    public boolean hasResult() {
        return true;
    }

    public boolean isHA() {
        return false;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public int hashCode() {
        return ID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && obj instanceof BootstrappingFunction;
    }

    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
    }

    public void memberJoined(InternalDistributedMember id) {
        this.bootstrapMember(id);
    }

    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
    }

    public void quorumLost(Set<InternalDistributedMember> internalDistributedMembers, List<InternalDistributedMember> internalDistributedMembers2) {
    }
}

