/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.util;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionEvent;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.modules.util.RegionConfiguration;
import org.apache.geode.modules.util.RegionHelper;

public class RegionConfigurationCacheListener
extends CacheListenerAdapter<String, RegionConfiguration>
implements Declarable {
    private final Cache cache = CacheFactory.getAnyInstance();

    RegionConfigurationCacheListener() {
    }

    public void afterCreate(EntryEvent<String, RegionConfiguration> event) {
        RegionConfiguration configuration = (RegionConfiguration)event.getNewValue();
        if (this.cache.getLogger().fineEnabled()) {
            this.cache.getLogger().fine("RegionConfigurationCacheListener received afterCreate for region " + (String)event.getKey());
        }
        try {
            Region region = RegionHelper.createRegion(this.cache, configuration);
            if (this.cache.getLogger().fineEnabled()) {
                this.cache.getLogger().fine("RegionConfigurationCacheListener created region: " + region);
            }
        }
        catch (RegionExistsException exists) {
            this.cache.getLogger().fine("Region with configuration " + configuration + " existed");
        }
    }

    public void afterUpdate(EntryEvent<String, RegionConfiguration> event) {
        this.afterCreate(event);
    }

    public void afterRegionCreate(RegionEvent<String, RegionConfiguration> event) {
        StringBuilder builder1 = new StringBuilder();
        StringBuilder builder2 = new StringBuilder();
        Region region = event.getRegion();
        if (this.cache.getLogger().fineEnabled()) {
            builder1 = new StringBuilder();
            int regionSize = region.size();
            if (regionSize > 0) {
                builder1.append("RegionConfigurationCacheListener region ").append(region.getName()).append(" has been initialized with the following ").append(regionSize).append(" region configurations:\n");
                builder2 = new StringBuilder();
                builder2.append("RegionConfigurationCacheListener created the following ").append(regionSize).append(" regions:\n");
            } else {
                builder1.append("RegionConfigurationCacheListener region ").append(region.getName()).append(" has been initialized with no region configurations");
            }
        }
        for (RegionConfiguration configuration : region.values()) {
            if (this.cache.getLogger().fineEnabled()) {
                builder1.append("\t").append(configuration);
            }
            try {
                Region createRegion = RegionHelper.createRegion(this.cache, configuration);
                if (!this.cache.getLogger().fineEnabled()) continue;
                builder2.append("\t").append(createRegion);
            }
            catch (RegionExistsException exists) {
                if (!this.cache.getLogger().fineEnabled()) continue;
                builder2.append("\t").append(" region existed");
            }
        }
        if (this.cache.getLogger().fineEnabled()) {
            this.cache.getLogger().fine(builder1.toString());
            if (builder2.length() != 0) {
                this.cache.getLogger().fine(builder2.toString());
            }
        }
    }
}

