/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.ha.session.SerializablePrincipal;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.StandardSession;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.Delta;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.size.Sizeable;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.geode.modules.gatewaydelta.GatewayDelta;
import org.apache.geode.modules.gatewaydelta.GatewayDeltaEvent;
import org.apache.geode.modules.session.catalina.DeltaSessionFacade;
import org.apache.geode.modules.session.catalina.DeltaSessionInterface;
import org.apache.geode.modules.session.catalina.DeltaSessionManager;
import org.apache.geode.modules.session.catalina.SessionManager;
import org.apache.geode.modules.session.catalina.internal.DeltaSessionAttributeEvent;
import org.apache.geode.modules.session.catalina.internal.DeltaSessionAttributeEventBatch;
import org.apache.geode.modules.session.catalina.internal.DeltaSessionDestroyAttributeEvent;
import org.apache.geode.modules.session.catalina.internal.DeltaSessionUpdateAttributeEvent;
import org.apache.juli.logging.Log;

public class DeltaSession
extends StandardSession
implements DataSerializable,
Delta,
GatewayDelta,
Sizeable,
DeltaSessionInterface {
    private transient Region<String, HttpSession> operatingRegion;
    private String sessionRegionName;
    private String contextName;
    private boolean hasDelta;
    private boolean applyRemotely;
    private boolean enableGatewayDeltaReplication;
    private final transient Object changeLock = new Object();
    private final ArrayList<DeltaSessionAttributeEvent> eventQueue = new ArrayList();
    private transient GatewayDeltaEvent currentGatewayDeltaEvent;
    private transient boolean expired = false;
    @Deprecated
    private transient boolean preferDeserializedForm = true;
    private byte[] serializedPrincipal;
    private static final Field cachedField;

    public DeltaSession() {
        super(null);
    }

    public DeltaSession(Manager manager) {
        super(manager);
        this.setOwner(manager);
    }

    public HttpSession getSession() {
        if (this.facade == null) {
            if (this.isPackageProtectionEnabled()) {
                DeltaSession fsession = this;
                this.facade = this.getNewFacade(fsession);
            } else {
                this.facade = new DeltaSessionFacade(this);
            }
        }
        return this.facade;
    }

    public Principal getPrincipal() {
        DeltaSessionManager<?> deltaSessionManager = this.getDeltaSessionManager();
        if (this.principal == null && this.serializedPrincipal != null) {
            SerializablePrincipal sp;
            Log logger = deltaSessionManager.getLogger();
            try {
                sp = (SerializablePrincipal)BlobHelper.deserializeBlob((byte[])this.serializedPrincipal);
            }
            catch (Exception e) {
                logger.warn((Object)(this + ": Serialized principal contains a byte[] that cannot be deserialized due to the following exception"), (Throwable)e);
                return null;
            }
            this.principal = sp.getPrincipal(deltaSessionManager.getTheContext().getRealm());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this + ": Deserialized principal: " + this.principal));
            }
        }
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        super.setPrincipal(principal);
        if (this.getManager() != null) {
            this.getManager().add((Session)this);
            Log logger = this.getDeltaSessionManager().getLogger();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this + ": Cached principal: " + principal));
            }
        }
    }

    private byte[] getSerializedPrincipal() {
        if (this.serializedPrincipal == null && this.principal != null && this.principal instanceof GenericPrincipal) {
            Log logger;
            GenericPrincipal gp = (GenericPrincipal)this.principal;
            SerializablePrincipal sp = SerializablePrincipal.createPrincipal((GenericPrincipal)gp);
            this.serializedPrincipal = this.serialize(sp);
            if (this.manager != null && (logger = this.getDeltaSessionManager().getLogger()).isDebugEnabled()) {
                logger.debug((Object)(this + ": Serialized principal: " + sp));
            }
        }
        return this.serializedPrincipal;
    }

    private Region<String, HttpSession> getOperatingRegion() {
        return this.operatingRegion;
    }

    boolean isCommitEnabled() {
        return this.getDeltaSessionManager().isCommitValveEnabled();
    }

    @Override
    public GatewayDeltaEvent getCurrentGatewayDeltaEvent() {
        return this.currentGatewayDeltaEvent;
    }

    @Override
    public void setCurrentGatewayDeltaEvent(GatewayDeltaEvent currentGatewayDeltaEvent) {
        this.currentGatewayDeltaEvent = currentGatewayDeltaEvent;
    }

    @Override
    public void setOwner(Object manager) {
        DeltaSessionManager sessionManager;
        if (manager instanceof DeltaSessionManager) {
            sessionManager = (DeltaSessionManager)manager;
            this.manager = sessionManager;
            this.initializeRegion(sessionManager);
            this.hasDelta = false;
            this.applyRemotely = false;
            this.enableGatewayDeltaReplication = sessionManager.getEnableGatewayDeltaReplication();
            this.setOwnerDeprecated(sessionManager);
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            if (this.notes == null) {
                this.notes = new Hashtable();
            }
        } else {
            throw new IllegalArgumentException(this + ": The Manager must be an AbstractManager");
        }
        this.contextName = sessionManager.getContextName();
    }

    private void setOwnerDeprecated(DeltaSessionManager<?> sessionManager) {
        this.preferDeserializedForm = sessionManager.getPreferDeserializedForm();
    }

    private void checkBackingCacheAvailable() {
        if (!((SessionManager)this.getManager()).isBackingCacheAvailable()) {
            throw new IllegalStateException("No backing cache server is available.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value, boolean notify) {
        this.checkBackingCacheAvailable();
        Object object = this.changeLock;
        synchronized (object) {
            byte[] serializedValue = this.serialize(value);
            if (this.preferDeserializedForm) {
                if (notify) {
                    this.deserializeAttributeInternal(name);
                }
                super.setAttribute(name, value, true);
            } else {
                super.setAttribute(name, (Object)serializedValue, true);
            }
            if (serializedValue == null) {
                return;
            }
            DeltaSessionUpdateAttributeEvent event = new DeltaSessionUpdateAttributeEvent(name, serializedValue);
            this.queueAttributeEvent(event, true);
            if (!this.isCommitEnabled()) {
                this.putInRegion(this.getOperatingRegion(), true, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name, boolean notify) {
        this.checkBackingCacheAvailable();
        if (this.expired) {
            return;
        }
        Object object = this.changeLock;
        synchronized (object) {
            if (notify && this.preferDeserializedForm) {
                this.deserializeAttributeInternal(name);
            }
            super.removeAttribute(name, notify);
            DeltaSessionDestroyAttributeEvent event = new DeltaSessionDestroyAttributeEvent(name);
            this.queueAttributeEvent(event, true);
            if (!this.isCommitEnabled()) {
                this.putInRegion(this.getOperatingRegion(), true, null);
            }
        }
    }

    protected void removeAttributeInternal(String name, boolean notify) {
        if (notify && this.preferDeserializedForm) {
            this.deserializeAttributeInternal(name);
        }
        super.removeAttributeInternal(name, notify);
    }

    protected Object getAttributeInternal(String name) {
        if (null == name) {
            return null;
        }
        return this.getAttributes().get(name);
    }

    protected void setAttributeInternal(String name, Object value) {
        if (null == name) {
            return;
        }
        this.getAttributes().put(name, value);
    }

    public Object getAttribute(String name) {
        this.checkBackingCacheAvailable();
        Object value = this.deserializeAttribute(name, super.getAttribute(name), this.preferDeserializedForm);
        this.getDeltaSessionManager().addSessionToTouch(this.getId());
        return value;
    }

    protected void deserializeAttributeInternal(String name) {
        this.deserializeAttribute(name, this.getAttributeInternal(name), true);
    }

    private Object deserializeAttribute(String name, Object value, boolean store) {
        if (value instanceof byte[]) {
            try {
                Object deserialized = BlobHelper.deserializeBlob((byte[])((byte[])value));
                if (store) {
                    this.setAttributeInternal(name, deserialized);
                }
                return deserialized;
            }
            catch (Exception e) {
                this.getDeltaSessionManager().getLogger().warn((Object)(this + ": Attribute named " + name + " contains a byte[] that cannot be deserialized due to the following exception"), (Throwable)e);
            }
        }
        return value;
    }

    private DeltaSessionManager<?> getDeltaSessionManager() {
        return (DeltaSessionManager)this.getManager();
    }

    Object getAttributeWithoutDeserialize(String name) {
        return super.getAttribute(name);
    }

    public void invalidate() {
        super.invalidate();
        this.getDeltaSessionManager().getStatistics().incSessionsInvalidated();
    }

    @Override
    public void processExpired() {
        DeltaSessionManager<?> manager = this.getDeltaSessionManager();
        if (manager != null && manager.getLogger() != null && manager.getLogger().isDebugEnabled()) {
            this.getDeltaSessionManager().getLogger().debug((Object)(this + ": Expired"));
        }
        this.setExpired(true);
        super.expire(true);
        if (manager != null) {
            manager.getStatistics().incSessionsExpired();
        }
    }

    public void expire(boolean notify) {
        if (notify) {
            this.getOperatingRegion().destroy((Object)this.getId(), (Object)this);
        } else {
            super.expire(false);
        }
    }

    public void setMaxInactiveInterval(int interval) {
        super.setMaxInactiveInterval(interval);
        if (!this.isCommitEnabled() && this.id != null) {
            this.putInRegion(this.getOperatingRegion(), true, null);
        }
    }

    @Override
    public void localUpdateAttribute(String name, Object value) {
        if (this.manager == null) {
            if (name == null) {
                throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.namenull"));
            }
            if (value == null) {
                this.removeAttribute(name);
                return;
            }
            if (!this.isValidInternal()) {
                throw new IllegalStateException(sm.getString("standardSession.setAttribute.ise", (Object)this.getIdInternal()));
            }
            this.getAttributes().put(name, value);
        } else {
            super.setAttribute(name, value, false);
        }
    }

    @Override
    public void localDestroyAttribute(String name) {
        super.removeAttribute(name, false);
    }

    @Override
    public void applyAttributeEvents(Region<String, DeltaSessionInterface> region, List<DeltaSessionAttributeEvent> events) {
        for (DeltaSessionAttributeEvent event : events) {
            event.apply(this);
            this.queueAttributeEvent(event, false);
        }
        this.putInRegion(region, false, true);
    }

    private void initializeRegion(DeltaSessionManager<?> sessionManager) {
        this.sessionRegionName = sessionManager.getRegionName();
        this.operatingRegion = sessionManager.getSessionCache().getOperatingRegion();
        if (sessionManager.getLogger().isDebugEnabled()) {
            sessionManager.getLogger().debug((Object)(this + ": Set operating region: " + this.operatingRegion));
        }
    }

    private void queueAttributeEvent(DeltaSessionAttributeEvent event, boolean checkAddToCurrentGatewayDelta) {
        if (checkAddToCurrentGatewayDelta && this.enableGatewayDeltaReplication && this.getDeltaSessionManager().isPeerToPeer() && !this.isCommitEnabled()) {
            ArrayList<DeltaSessionAttributeEvent> events = new ArrayList<DeltaSessionAttributeEvent>();
            events.add(event);
            this.currentGatewayDeltaEvent = new DeltaSessionAttributeEventBatch(this.sessionRegionName, this.id, events);
        }
        this.addEventToEventQueue(event);
    }

    private void putInRegion(Region region, boolean applyRemotely, Object callbackArgument) {
        this.hasDelta = true;
        this.applyRemotely = applyRemotely;
        region.put((Object)this.id, (Object)this, callbackArgument);
        this.eventQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        if (!this.isValidInternal()) {
            throw new IllegalStateException("commit: Session " + this.getId() + " already invalidated");
        }
        Object object = this.changeLock;
        synchronized (object) {
            if (this.enableGatewayDeltaReplication && this.getDeltaSessionManager().isPeerToPeer()) {
                this.setCurrentGatewayDeltaEvent(new DeltaSessionAttributeEventBatch(this.sessionRegionName, this.id, this.eventQueue));
            }
            this.hasDelta = true;
            this.applyRemotely = true;
            this.putInRegion(this.getOperatingRegion(), true, null);
            this.eventQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        Object object = this.changeLock;
        synchronized (object) {
            this.eventQueue.clear();
        }
    }

    private void setExpired(boolean expired) {
        this.expired = expired;
    }

    @Override
    public boolean getExpired() {
        return this.expired;
    }

    @Override
    public String getContextName() {
        return this.contextName;
    }

    public boolean hasDelta() {
        return this.hasDelta;
    }

    public void toDelta(DataOutput out) throws IOException {
        out.writeBoolean(this.applyRemotely);
        DataSerializer.writeArrayList(this.eventQueue, (DataOutput)out);
        out.writeLong(this.lastAccessedTime);
        out.writeInt(this.maxInactiveInterval);
    }

    public void fromDelta(DataInput in) throws IOException, InvalidDeltaException {
        ArrayList events;
        this.applyRemotely = in.readBoolean();
        try {
            events = DataSerializer.readArrayList((DataInput)in);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidDeltaException((Throwable)e);
        }
        if (((InputStream)((Object)in)).available() > 0) {
            this.lastAccessedTime = in.readLong();
            this.maxInactiveInterval = in.readInt();
        }
        for (DeltaSessionAttributeEvent event : events) {
            event.apply(this);
        }
        if (this.enableGatewayDeltaReplication && this.applyRemotely) {
            this.setCurrentGatewayDeltaEvent(new DeltaSessionAttributeEventBatch(this.sessionRegionName, this.id, events));
        }
        this.access();
        this.endAccess();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.id, (DataOutput)out);
        out.writeLong(this.creationTime);
        out.writeLong(this.lastAccessedTime);
        out.writeLong(this.thisAccessedTime);
        out.writeInt(this.maxInactiveInterval);
        out.writeBoolean(this.isNew);
        out.writeBoolean(this.isValid);
        DataSerializer.writeObject(this.getSerializedAttributes(), (DataOutput)out);
        DataSerializer.writeByteArray((byte[])this.getSerializedPrincipal(), (DataOutput)out);
        out.writeBoolean(this.enableGatewayDeltaReplication);
        DataSerializer.writeString((String)this.sessionRegionName, (DataOutput)out);
        DataSerializer.writeString((String)this.contextName, (DataOutput)out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.id = DataSerializer.readString((DataInput)in);
        this.creationTime = in.readLong();
        this.lastAccessedTime = in.readLong();
        this.thisAccessedTime = in.readLong();
        this.maxInactiveInterval = in.readInt();
        this.isNew = in.readBoolean();
        this.isValid = in.readBoolean();
        this.readInAttributes(in);
        this.serializedPrincipal = DataSerializer.readByteArray((DataInput)in);
        this.enableGatewayDeltaReplication = in.readBoolean();
        this.sessionRegionName = DataSerializer.readString((DataInput)in);
        if (((InputStream)((Object)in)).available() > 0) {
            this.contextName = DataSerializer.readString((DataInput)in);
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (this.notes == null) {
            this.notes = new Hashtable();
        }
    }

    private void readInAttributes(DataInput in) throws IOException, ClassNotFoundException {
        ConcurrentHashMap map = (ConcurrentHashMap)DataSerializer.readObject((DataInput)in);
        try {
            Field field = this.getAttributesFieldObject();
            field.set(this, map);
        }
        catch (IllegalAccessException e) {
            this.logError(e);
            throw new IllegalStateException(e);
        }
    }

    private Field getAttributesFieldObject() {
        return cachedField;
    }

    private void logError(Exception e) {
        DeltaSessionManager<?> deltaSessionManager = this.getDeltaSessionManager();
        if (deltaSessionManager != null) {
            deltaSessionManager.getLogger().error((Object)e);
        }
    }

    public int getSizeInBytes() {
        int size = 0;
        Enumeration attributeNames = this.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            Object value = this.getAttributeWithoutDeserialize((String)attributeNames.nextElement());
            if (!(value instanceof byte[])) continue;
            size += ((byte[])value).length;
        }
        return size;
    }

    private Map<String, byte[]> getSerializedAttributes() {
        ConcurrentHashMap<String, byte[]> serializedAttributes = new ConcurrentHashMap<String, byte[]>();
        for (Map.Entry o : this.getAttributes().entrySet()) {
            Map.Entry entry = o;
            Object value = entry.getValue();
            byte[] serializedValue = value instanceof byte[] ? (byte[])value : this.serialize(value);
            serializedAttributes.put((String)entry.getKey(), serializedValue);
        }
        return serializedAttributes;
    }

    protected Map getAttributes() {
        try {
            Field field = this.getAttributesFieldObject();
            return (Map)field.get(this);
        }
        catch (IllegalAccessException e) {
            this.logError(e);
            throw new IllegalStateException("Unable to access attributes field");
        }
    }

    byte[] serialize(Object obj) {
        byte[] serializedValue = null;
        try {
            serializedValue = this.serializeViaBlobHelper(obj);
        }
        catch (IOException e) {
            String builder = this + ": Object " + obj + " cannot be serialized due to the following exception";
            this.getDeltaSessionManager().getLogger().warn((Object)builder, (Throwable)e);
        }
        return serializedValue;
    }

    byte[] serializeViaBlobHelper(Object obj) throws IOException {
        return BlobHelper.serializeToBlob((Object)obj);
    }

    public String toString() {
        return "DeltaSession[id=" + this.getId() + "; context=" + this.contextName + "; sessionRegionName=" + this.sessionRegionName + "; operatingRegionName=" + (this.getOperatingRegion() == null ? "unset" : this.getOperatingRegion().getFullPath()) + "]";
    }

    DeltaSessionFacade getNewFacade(DeltaSessionInterface fSession) {
        return AccessController.doPrivileged(() -> new DeltaSessionFacade(fSession));
    }

    boolean isPackageProtectionEnabled() {
        return SecurityUtil.isPackageProtectionEnabled();
    }

    void addEventToEventQueue(DeltaSessionAttributeEvent event) {
        this.eventQueue.add(event);
    }

    static {
        try {
            cachedField = StandardSession.class.getDeclaredField("attributes");
            cachedField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }
}

