/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.modules.session.catalina;

import com.gemstone.gemfire.modules.session.catalina.DeltaSessionFacade;
import com.gemstone.gemfire.modules.session.catalina.DeltaSessionManager;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Manager;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class CommitSessionValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(CommitSessionValve.class);
    protected static final String info = "com.gemstone.gemfire.modules.session.catalina.CommitSessionValve/1.0";

    public CommitSessionValve() {
        log.info((Object)"Initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Manager manager = request.getContext().getManager();
        DeltaSessionFacade session = null;
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            if (manager instanceof DeltaSessionManager && (session = (DeltaSessionFacade)request.getSession(false)) != null) {
                if (session.isValid()) {
                    ((DeltaSessionManager)manager).removeTouchedSession(session.getId());
                    session.commit();
                    if (manager.getContainer().getLogger().isDebugEnabled()) {
                        manager.getContainer().getLogger().debug((Object)((Object)((Object)session) + ": Committed."));
                    }
                } else if (manager.getContainer().getLogger().isDebugEnabled()) {
                    manager.getContainer().getLogger().debug((Object)((Object)((Object)session) + ": Not valid so not committing."));
                }
            }
        }
    }
}

