/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.catalina;

import java.io.IOException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.session.StandardSession;
import org.apache.geode.modules.session.catalina.DeltaSession8;
import org.apache.geode.modules.session.catalina.DeltaSessionManager;

public class Tomcat8DeltaSessionManager
extends DeltaSessionManager {
    public void startInternal() throws LifecycleException {
        super.startInternal();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)((Object)((Object)this) + ": Starting"));
        }
        if (this.started.get()) {
            return;
        }
        this.fireLifecycleEvent("start", null);
        this.registerJvmRouteBinderValve();
        if (this.isCommitValveEnabled()) {
            this.registerCommitSessionValve();
        }
        this.initializeSessionCache();
        try {
            this.load();
        }
        catch (ClassNotFoundException e) {
            throw new LifecycleException("Exception starting manager", (Throwable)e);
        }
        catch (IOException e) {
            throw new LifecycleException("Exception starting manager", (Throwable)e);
        }
        this.scheduleTimerTasks();
        this.started.set(true);
        this.setState(LifecycleState.STARTING);
    }

    public void stopInternal() throws LifecycleException {
        super.stopInternal();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)((Object)((Object)this) + ": Stopping"));
        }
        try {
            this.unload();
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Unable to unload sessions", (Throwable)e);
        }
        this.started.set(false);
        this.fireLifecycleEvent("stop", null);
        super.destroyInternal();
        this.getSessionsToTouch().clear();
        this.cancelTimer();
        this.unregisterJvmRouteBinderValve();
        if (this.isCommitValveEnabled()) {
            this.unregisterCommitSessionValve();
        }
        this.setState(LifecycleState.STOPPING);
    }

    public int getMaxInactiveInterval() {
        return this.getContext().getSessionTimeout();
    }

    protected Pipeline getPipeline() {
        return this.getTheContext().getPipeline();
    }

    public Context getTheContext() {
        return this.getContext();
    }

    public void setMaxInactiveInterval(int interval) {
        this.getContext().setSessionTimeout(interval);
    }

    protected StandardSession getNewSession() {
        return new DeltaSession8((Manager)this);
    }
}

