/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.memcached;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.apache.geode.LogWriter;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.internal.memcached.Command;
import org.apache.geode.internal.memcached.RequestReader;
import org.apache.geode.internal.memcached.commands.ClientError;
import org.apache.geode.memcached.GemFireMemcachedServer;

public class ConnectionHandler
implements Runnable {
    private final Socket socket;
    private final Cache cache;
    private final GemFireMemcachedServer.Protocol protocol;
    @MakeNotStatic
    private static LogWriter logger;

    public ConnectionHandler(Socket socket, Cache cache, GemFireMemcachedServer.Protocol protocol) {
        this.socket = socket;
        this.cache = cache;
        this.protocol = protocol;
        if (logger == null) {
            logger = this.cache.getLogger();
        }
    }

    @Override
    public void run() {
        RequestReader request = new RequestReader(this.socket, this.protocol);
        while (!Thread.currentThread().isInterrupted()) {
            try {
                ByteBuffer reply;
                Command command = request.readCommand();
                if (logger.fineEnabled()) {
                    logger.fine("processing command:" + String.valueOf((Object)command));
                }
                if ((reply = command.getCommandProcessor().processCommand(request, this.protocol, this.cache)) != null) {
                    request.sendReply(reply);
                }
                if (command != Command.QUIT && command != Command.QUITQ) continue;
                this.socket.close();
                break;
            }
            catch (ClientError e) {
                request.sendException(e);
            }
            catch (IllegalArgumentException e) {
                request.sendException(e);
            }
            catch (CacheClosedException cc) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                Thread.currentThread().interrupt();
            }
        }
        logger.fine("Connection handler " + Thread.currentThread().getName() + " terminating");
    }

    protected static LogWriter getLogger() {
        return logger;
    }
}

