/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.memcached;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;

public class KeyWrapper
implements DataSerializable {
    private static final long serialVersionUID = -3241981993525734772L;
    private byte[] key;

    public KeyWrapper() {
    }

    private KeyWrapper(byte[] key) {
        this.key = key;
    }

    public static KeyWrapper getWrappedKey(byte[] key) {
        return new KeyWrapper(key);
    }

    public byte[] getKey() {
        return this.key;
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeByteArray((byte[])this.key, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.key = DataSerializer.readByteArray((DataInput)in);
    }

    public boolean equals(Object obj) {
        if (obj instanceof KeyWrapper) {
            KeyWrapper other = (KeyWrapper)obj;
            return Arrays.equals(this.key, other.key);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.key);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getCanonicalName()).append("@").append(System.identityHashCode(this));
        str.append(" key:").append(Arrays.toString(this.key));
        str.append(" hashCode:").append(this.hashCode());
        return str.toString();
    }
}

