/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.gms.GMSMembershipView;
import org.apache.geode.distributed.internal.membership.gms.messages.AbstractGMSMessage;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;

public class ViewAckMessage<ID extends MemberIdentifier>
extends AbstractGMSMessage<ID> {
    int viewId;
    boolean preparing;
    GMSMembershipView<ID> alternateView;

    public ViewAckMessage(ID recipient, int viewId, boolean preparing) {
        this.setRecipient(recipient);
        this.viewId = viewId;
        this.preparing = preparing;
    }

    public ViewAckMessage(int viewId, ID recipient, GMSMembershipView<ID> alternateView) {
        this.setRecipient(recipient);
        this.viewId = viewId;
        this.alternateView = alternateView;
        this.preparing = true;
    }

    public ViewAckMessage() {
    }

    public int getViewId() {
        return this.viewId;
    }

    public GMSMembershipView<ID> getAlternateView() {
        return this.alternateView;
    }

    public boolean isPrepareAck() {
        return this.preparing;
    }

    public int getDSFID() {
        return -151;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        out.writeInt(this.viewId);
        out.writeBoolean(this.preparing);
        context.getSerializer().writeObject(this.alternateView, out);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.viewId = in.readInt();
        this.preparing = in.readBoolean();
        this.alternateView = (GMSMembershipView)context.getDeserializer().readObject(in);
    }

    public String toString() {
        Object s = this.getSender() == null ? this.getRecipients().toString() : String.valueOf(this.getSender());
        return "ViewAckMessage(" + (String)s + "; " + this.viewId + "; preparing=" + this.preparing + "; altview=" + String.valueOf(this.alternateView) + ")";
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }
}

