/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.locator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.gms.locator.PeerLocatorRequest;
import org.apache.geode.distributed.internal.membership.gms.messages.AbstractGMSMessage;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;

public class FindCoordinatorRequest<ID extends MemberIdentifier>
extends AbstractGMSMessage<ID>
implements PeerLocatorRequest {
    private ID memberID;
    private Collection<ID> rejectedCoordinators;
    private int lastViewId;
    private byte[] myPublicKey;
    private int requestId;
    private String dhalgo;

    public FindCoordinatorRequest(ID myId) {
        this.memberID = myId;
        this.dhalgo = "";
    }

    public FindCoordinatorRequest(ID myId, Collection<ID> rejectedCoordinators, int lastViewId, byte[] pk, int requestId, String dhalgo) {
        this.memberID = myId;
        this.rejectedCoordinators = rejectedCoordinators;
        this.lastViewId = lastViewId;
        this.myPublicKey = pk;
        this.requestId = requestId;
        this.dhalgo = dhalgo;
    }

    public FindCoordinatorRequest() {
    }

    public ID getMemberID() {
        return this.memberID;
    }

    public byte[] getMyPublicKey() {
        return this.myPublicKey;
    }

    public String getDHAlgo() {
        return this.dhalgo;
    }

    public Collection<ID> getRejectedCoordinators() {
        return this.rejectedCoordinators;
    }

    public int getLastViewId() {
        return this.lastViewId;
    }

    public String toString() {
        if (this.rejectedCoordinators != null) {
            return "FindCoordinatorRequest(memberID=" + String.valueOf(this.memberID) + ", rejected=" + String.valueOf(this.rejectedCoordinators) + ", lastViewId=" + this.lastViewId + ")";
        }
        return "FindCoordinatorRequest(memberID=" + String.valueOf(this.memberID) + ")";
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    public int getDSFID() {
        return -145;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        context.getSerializer().writeObject(this.memberID, out);
        if (this.rejectedCoordinators != null) {
            out.writeInt(this.rejectedCoordinators.size());
            for (MemberIdentifier mbr : this.rejectedCoordinators) {
                context.getSerializer().writeObject((Object)mbr, out);
            }
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.lastViewId);
        out.writeInt(this.requestId);
        StaticSerialization.writeString((String)this.dhalgo, (DataOutput)out);
        StaticSerialization.writeByteArray((byte[])this.myPublicKey, (DataOutput)out);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.memberID = (MemberIdentifier)context.getDeserializer().readObject(in);
        int size = in.readInt();
        this.rejectedCoordinators = new ArrayList<ID>(size);
        for (int i = 0; i < size; ++i) {
            this.rejectedCoordinators.add((MemberIdentifier)context.getDeserializer().readObject(in));
        }
        this.lastViewId = in.readInt();
        this.requestId = in.readInt();
        this.dhalgo = StaticSerialization.readString((DataInput)in);
        this.myPublicKey = StaticSerialization.readByteArray((DataInput)in);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lastViewId;
        result = 31 * result + (this.dhalgo == null ? 0 : this.dhalgo.hashCode());
        result = 31 * result + (this.memberID == null ? 0 : this.memberID.hashCode());
        result = 31 * result + (this.rejectedCoordinators == null ? 0 : this.rejectedCoordinators.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FindCoordinatorRequest other = (FindCoordinatorRequest)obj;
        if (this.lastViewId != other.lastViewId) {
            return false;
        }
        if (!this.dhalgo.equals(other.dhalgo)) {
            return false;
        }
        if (this.memberID == null ? other.memberID != null : !this.memberID.equals(other.memberID)) {
            return false;
        }
        if (this.rejectedCoordinators == null) {
            return other.rejectedCoordinators == null;
        }
        return this.rejectedCoordinators.equals(other.rejectedCoordinators);
    }
}

