/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.gms.messages.AbstractGMSMessage;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;

public class HeartbeatRequestMessage<ID extends MemberIdentifier>
extends AbstractGMSMessage<ID> {
    int requestId;
    ID target;

    public HeartbeatRequestMessage(ID neighbour, int id) {
        this.requestId = id;
        this.target = neighbour;
    }

    public HeartbeatRequestMessage() {
    }

    public ID getTarget() {
        return this.target;
    }

    public void clearRequestId() {
        this.requestId = -1;
    }

    public int getDSFID() {
        return -154;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [requestId=" + this.requestId + "]";
    }

    public int getRequestId() {
        return this.requestId;
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        out.writeInt(this.requestId);
        context.getSerializer().writeObject(this.target, out);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.requestId = in.readInt();
        this.target = (MemberIdentifier)context.getDeserializer().readObject(in);
    }

    @Override
    public boolean isHighPriority() {
        return true;
    }
}

