/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms;

import org.apache.geode.distributed.internal.membership.api.Authenticator;
import org.apache.geode.distributed.internal.membership.api.LifecycleListener;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifierFactory;
import org.apache.geode.distributed.internal.membership.api.Membership;
import org.apache.geode.distributed.internal.membership.api.MembershipBuilder;
import org.apache.geode.distributed.internal.membership.api.MembershipConfig;
import org.apache.geode.distributed.internal.membership.api.MembershipConfigurationException;
import org.apache.geode.distributed.internal.membership.api.MembershipListener;
import org.apache.geode.distributed.internal.membership.api.MembershipLocator;
import org.apache.geode.distributed.internal.membership.api.MembershipStatistics;
import org.apache.geode.distributed.internal.membership.api.MessageListener;
import org.apache.geode.distributed.internal.membership.gms.AuthenticatorNoOp;
import org.apache.geode.distributed.internal.membership.gms.GMSMembership;
import org.apache.geode.distributed.internal.membership.gms.LifecycleListenerNoOp;
import org.apache.geode.distributed.internal.membership.gms.MembershipListenerNoOp;
import org.apache.geode.distributed.internal.membership.gms.MembershipStatisticsNoOp;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.locator.MembershipLocatorImpl;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.internal.serialization.DSFIDSerializer;

public class MembershipBuilderImpl<ID extends MemberIdentifier>
implements MembershipBuilder<ID> {
    private final TcpSocketCreator socketCreator;
    private final TcpClient locatorClient;
    private MembershipListener<ID> membershipListener = new MembershipListenerNoOp();
    private MessageListener<ID> messageListener = message -> {};
    private MembershipStatistics statistics = new MembershipStatisticsNoOp();
    private Authenticator<ID> authenticator = new AuthenticatorNoOp();
    private MembershipConfig membershipConfig = new MembershipConfig(){};
    private final DSFIDSerializer serializer;
    private final MemberIdentifierFactory<ID> memberFactory;
    private LifecycleListener<ID> lifecycleListener = new LifecycleListenerNoOp();
    private MembershipLocatorImpl<ID> membershipLocator;

    public MembershipBuilderImpl(TcpSocketCreator socketCreator, TcpClient locatorClient, DSFIDSerializer serializer, MemberIdentifierFactory<ID> memberFactory) {
        this.socketCreator = socketCreator;
        this.locatorClient = locatorClient;
        this.serializer = serializer;
        this.memberFactory = memberFactory;
    }

    @Override
    public MembershipBuilder<ID> setAuthenticator(Authenticator<ID> authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    @Override
    public MembershipBuilder<ID> setStatistics(MembershipStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    @Override
    public MembershipBuilder<ID> setMembershipListener(MembershipListener<ID> membershipListener) {
        this.membershipListener = membershipListener;
        return this;
    }

    @Override
    public MembershipBuilder<ID> setMembershipLocator(MembershipLocator<ID> membershipLocator) {
        this.membershipLocator = (MembershipLocatorImpl)membershipLocator;
        return this;
    }

    @Override
    public MembershipBuilder<ID> setMessageListener(MessageListener<ID> messageListener) {
        this.messageListener = messageListener;
        return this;
    }

    @Override
    public MembershipBuilder<ID> setConfig(MembershipConfig membershipConfig) {
        this.membershipConfig = membershipConfig;
        return this;
    }

    @Override
    public MembershipBuilder<ID> setLifecycleListener(LifecycleListener<ID> lifecycleListener) {
        this.lifecycleListener = lifecycleListener;
        return this;
    }

    @Override
    public Membership<ID> create() throws MembershipConfigurationException {
        GMSMembership<ID> gmsMembership = new GMSMembership<ID>(this.membershipListener, this.messageListener, this.lifecycleListener);
        Services<ID> services = new Services<ID>(gmsMembership.getGMSManager(), this.statistics, this.authenticator, this.membershipConfig, this.serializer, this.memberFactory, this.locatorClient, this.socketCreator);
        if (this.membershipLocator != null) {
            services.setLocators(this.membershipLocator.getGMSLocator(), this.membershipLocator);
        }
        services.init();
        return gmsMembership;
    }
}

