/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.api;

import org.apache.geode.annotations.internal.MakeImmutable;

public interface MembershipConfig {
    public static final long MEMBER_REQUEST_COLLECTION_INTERVAL = Long.getLong("gemfire.member-request-collection-interval", 300L);
    public static final int SMALL_CLUSTER_SIZE = 9;
    @MakeImmutable
    public static final int[] DEFAULT_MEMBERSHIP_PORT_RANGE = new int[]{41000, 61000};
    public static final int DEFAULT_LOCATOR_WAIT_TIME = 0;
    public static final String DEFAULT_SECURITY_UDP_DHALGO = "";
    public static final int DEFAULT_UDP_FRAGMENT_SIZE = 60000;
    public static final String DEFAULT_START_LOCATOR = "";
    public static final int DEFAULT_MEMBER_TIMEOUT = 5000;
    public static final int DEFAULT_LOSS_THRESHOLD = 51;
    public static final int DEFAULT_MEMBER_WEIGHT = 0;
    public static final boolean DEFAULT_ENABLE_NETWORK_PARTITION_DETECTION = true;
    public static final int DEFAULT_MCAST_PORT = 0;
    public static final String DEFAULT_LOCATORS = "";
    public static final String DEFAULT_BIND_ADDRESS = "";
    public static final String DEFAULT_SECURITY_PEER_AUTH_INIT = "";
    public static final boolean DEFAULT_DISABLE_TCP = false;
    public static final String DEFAULT_NAME = "";
    public static final String DEFAULT_ROLES = "";
    public static final String DEFAULT_GROUPS = "";
    public static final String DEFAULT_DURABLE_CLIENT_ID = "";
    public static final int DEFAULT_DURABLE_CLIENT_TIMEOUT = 300;
    public static final String DEFAULT_MCAST_ADDRESS = "239.192.81.1";
    public static final int DEFAULT_MCAST_TTL = 32;
    public static final int DEFAULT_MCAST_SEND_BUFFER_SIZE = 65535;
    public static final int DEFAULT_MCAST_RECV_BUFFER_SIZE = 0x100000;
    public static final int DEFAULT_UDP_RECV_BUFFER_SIZE = 0x100000;
    public static final int DEFAULT_UDP_SEND_BUFFER_SIZE = 65535;
    public static final int DEFAULT_UDP_RECV_BUFFER_SIZE_REDUCED = 65535;
    public static final int DEFAULT_MCAST_BYTE_ALLOWANCE = 0x100000;
    public static final float DEFAULT_MCAST_RECHARGE_THRESHOLD = 0.25f;
    public static final int DEFAULT_MCAST_RECHARGE_BLOCKING_MS = 5000;
    public static final int DEFAULT_ACK_WAIT_THRESHOLD = 15;
    public static final boolean DEFAULT_DISABLE_AUTO_RECONNECT = false;
    public static final int DEFAULT_SECURITY_PEER_VERIFYMEMBER_TIMEOUT = 1000;
    public static final int DEFAULT_ACK_SEVERE_ALERT_THRESHOLD = 0;
    public static final Object DEFAULT_OLD_MEMBERSHIP_INFO = null;
    public static final boolean DEFAULT_IS_RECONNECTING_DS = false;
    public static final int DEFAULT_JOIN_TIMEOUT = 24000;
    public static final String LOCATORS = "locators";
    public static final String START_LOCATOR = "start-locator";

    default public boolean isReconnecting() {
        return false;
    }

    default public int getLocatorWaitTime() {
        return 0;
    }

    default public long getJoinTimeout() {
        return 24000L;
    }

    default public int[] getMembershipPortRange() {
        return DEFAULT_MEMBERSHIP_PORT_RANGE;
    }

    default public long getMemberTimeout() {
        return 5000L;
    }

    default public int getLossThreshold() {
        return 51;
    }

    default public int getMemberWeight() {
        return 0;
    }

    default public boolean isMulticastEnabled() {
        return this.getMcastPort() > 0;
    }

    default public boolean isNetworkPartitionDetectionEnabled() {
        return true;
    }

    default public boolean isUDPSecurityEnabled() {
        return !this.getSecurityUDPDHAlgo().isEmpty();
    }

    default public boolean areLocatorsPreferredAsCoordinators() {
        return this.isNetworkPartitionDetectionEnabled();
    }

    default public String getSecurityUDPDHAlgo() {
        return "";
    }

    default public int getMcastPort() {
        return 0;
    }

    default public String getLocators() {
        return "";
    }

    default public String getStartLocator() {
        return "";
    }

    default public String getBindAddress() {
        return "";
    }

    default public String getSecurityPeerAuthInit() {
        return "";
    }

    default public boolean getDisableTcp() {
        return false;
    }

    default public String getName() {
        return "";
    }

    default public String getRoles() {
        return "";
    }

    default public String getGroups() {
        return "";
    }

    default public String getDurableClientId() {
        return "";
    }

    default public int getDurableClientTimeout() {
        return 300;
    }

    default public String getMcastAddress() {
        return DEFAULT_MCAST_ADDRESS;
    }

    default public int getMcastTtl() {
        return 32;
    }

    default public int getMcastSendBufferSize() {
        return 65535;
    }

    default public int getMcastRecvBufferSize() {
        return 0x100000;
    }

    default public int getUdpFragmentSize() {
        return 60000;
    }

    default public int getUdpRecvBufferSize() {
        return 0x100000;
    }

    default public int getUdpSendBufferSize() {
        return 65535;
    }

    default public int getMcastByteAllowance() {
        return 0x100000;
    }

    default public float getMcastRechargeThreshold() {
        return 0.25f;
    }

    default public int getMcastRechargeBlockMs() {
        return 5000;
    }

    default public long getAckWaitThreshold() {
        return 15L;
    }

    default public boolean getDisableAutoReconnect() {
        return false;
    }

    default public int getSecurityPeerMembershipTimeout() {
        return 1000;
    }

    default public long getAckSevereAlertThreshold() {
        return 0L;
    }

    default public int getVmKind() {
        return 10;
    }

    default public Object getOldDSMembershipInfo() {
        return DEFAULT_OLD_MEMBERSHIP_INFO;
    }

    default public boolean getIsReconnectingDS() {
        return false;
    }

    default public boolean getHasLocator() {
        return false;
    }
}

