/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.locator;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.MembershipConfigurationException;
import org.apache.geode.distributed.internal.membership.api.MembershipLocatorStatistics;
import org.apache.geode.distributed.internal.membership.gms.GMSMembershipView;
import org.apache.geode.distributed.internal.membership.gms.GMSUtil;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.interfaces.Locator;
import org.apache.geode.distributed.internal.membership.gms.locator.FindCoordinatorRequest;
import org.apache.geode.distributed.internal.membership.gms.locator.FindCoordinatorResponse;
import org.apache.geode.distributed.internal.membership.gms.locator.GetViewRequest;
import org.apache.geode.distributed.internal.membership.gms.locator.GetViewResponse;
import org.apache.geode.distributed.internal.membership.gms.membership.HostAddress;
import org.apache.geode.distributed.internal.membership.gms.messenger.GMSMemberWrapper;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.distributed.internal.tcpserver.TcpHandler;
import org.apache.geode.distributed.internal.tcpserver.TcpServer;
import org.apache.geode.internal.serialization.ObjectDeserializer;
import org.apache.geode.internal.serialization.ObjectSerializer;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class GMSLocator<ID extends MemberIdentifier>
implements Locator<ID>,
TcpHandler {
    static final int LOCATOR_FILE_STAMP = 2072835905;
    private static final Logger logger = LogService.getLogger();
    private final boolean usePreferredCoordinators;
    private final boolean networkPartitionDetectionEnabled;
    private final String securityUDPDHAlgo;
    private final String locatorString;
    private final List<HostAddress> locators;
    private final MembershipLocatorStatistics locatorStats;
    private final Set<ID> registrants = new HashSet<ID>();
    private final Map<GMSMemberWrapper, byte[]> publicKeys = new ConcurrentHashMap<GMSMemberWrapper, byte[]>();
    private final Path workingDirectory;
    private final ObjectSerializer objectSerializer;
    private final ObjectDeserializer objectDeserializer;
    private volatile boolean isCoordinator;
    private Services<ID> services;
    private ID localAddress;
    private GMSMembershipView<ID> view;
    private GMSMembershipView<ID> recoveredView;
    private File viewFile;
    private final TcpClient locatorClient;

    public GMSLocator(InetAddress bindAddress, String locatorString, boolean usePreferredCoordinators, boolean networkPartitionDetectionEnabled, MembershipLocatorStatistics locatorStats, String securityUDPDHAlgo, Path workingDirectory, TcpClient locatorClient, ObjectSerializer objectSerializer, ObjectDeserializer objectDeserializer) throws MembershipConfigurationException {
        this.usePreferredCoordinators = usePreferredCoordinators;
        this.networkPartitionDetectionEnabled = networkPartitionDetectionEnabled;
        this.securityUDPDHAlgo = securityUDPDHAlgo;
        this.locatorString = locatorString;
        this.locators = this.locatorString == null || this.locatorString.isEmpty() ? new ArrayList<HostAddress>(0) : GMSUtil.parseLocators(locatorString, bindAddress);
        this.locatorStats = locatorStats;
        this.workingDirectory = workingDirectory;
        this.locatorClient = locatorClient;
        this.objectSerializer = objectSerializer;
        this.objectDeserializer = objectDeserializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean setServices(Services<ID> services) {
        if (this.services == null || this.services.isStopped()) {
            this.services = services;
            this.localAddress = this.services.getMessenger().getMemberID();
            Objects.requireNonNull(this.localAddress, "member address should have been established");
            logger.info("Peer locator is connecting to local membership services with ID {}", this.localAddress);
            GMSMembershipView<ID> newView = this.services.getJoinLeave().getView();
            if (newView != null) {
                this.view = newView;
                this.recoveredView = null;
            } else {
                if (this.view != null) {
                    this.view.setViewId(-100);
                    this.recoveredView = this.view;
                    this.view = null;
                }
                if (this.localAddress != null) {
                    if (this.recoveredView != null) {
                        this.recoveredView.remove(this.localAddress);
                    }
                    Set<ID> set = this.registrants;
                    synchronized (set) {
                        this.registrants.add(this.localAddress);
                    }
                }
            }
            this.notifyAll();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    File setViewFile(File file) {
        this.viewFile = file.getAbsoluteFile();
        return this.viewFile;
    }

    @VisibleForTesting
    File getViewFile() {
        return this.viewFile;
    }

    public void init(TcpServer server) {
        String persistentFileIdentifier = "" + server.getPort();
        if (this.viewFile == null) {
            this.viewFile = this.workingDirectory.resolve("locator" + persistentFileIdentifier + "view.dat").toFile();
        }
        logger.info("GemFire peer location service starting.  Other locators: {}  Locators preferred as coordinators: {}  Network partition detection enabled: {}  View persistence file: {}", (Object)this.locatorString, (Object)this.usePreferredCoordinators, (Object)this.networkPartitionDetectionEnabled, (Object)this.viewFile);
        this.recover();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installView(GMSMembershipView<ID> view) {
        Set<ID> set = this.registrants;
        synchronized (set) {
            this.registrants.clear();
        }
        logger.info("Peer locator received new membership view: {}", view);
        this.view = view;
        this.recoveredView = null;
        this.saveView(view);
    }

    @Override
    public void setIsCoordinator(boolean isCoordinator) {
        if (isCoordinator) {
            logger.info("Location services has received notification that this node is becoming membership coordinator");
        }
        this.isCoordinator = isCoordinator;
    }

    public Object processRequest(Object request) {
        if (logger.isDebugEnabled()) {
            logger.debug("Peer locator processing {}", request);
        }
        if (this.localAddress == null && this.services != null) {
            this.localAddress = this.services.getMessenger().getMemberID();
        }
        Object response = null;
        if (request instanceof GetViewRequest) {
            if (this.view != null) {
                response = new GetViewResponse<ID>(this.view);
            }
        } else if (request instanceof FindCoordinatorRequest) {
            response = this.processFindCoordinatorRequest((FindCoordinatorRequest)request);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Peer locator returning {}", response);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FindCoordinatorResponse<ID> processFindCoordinatorRequest(FindCoordinatorRequest<ID> findRequest) {
        if (!findRequest.getDHAlgo().equals(this.securityUDPDHAlgo)) {
            return new FindCoordinatorResponse("Rejecting findCoordinatorRequest, as member not configured same udp security(" + findRequest.getDHAlgo() + ") as locator (" + this.securityUDPDHAlgo + ")");
        }
        if (this.services == null) {
            if (findRequest.getMyPublicKey() != null) {
                this.publicKeys.put(new GMSMemberWrapper((MemberIdentifier)findRequest.getMemberID()), findRequest.getMyPublicKey());
            }
            logger.debug("Rejecting a request to find the coordinator - membership services are still initializing");
            return null;
        }
        if (findRequest.getMemberID() == null) {
            return null;
        }
        this.services.getMessenger().setPublicKey(findRequest.getMyPublicKey(), findRequest.getMemberID());
        if (this.view == null && this.services == null) {
            return null;
        }
        GMSMembershipView<Object> responseView = this.view;
        if (responseView == null) {
            responseView = this.recoveredView;
        }
        Set<ID> set = this.registrants;
        synchronized (set) {
            this.registrants.add(findRequest.getMemberID());
            if (this.recoveredView != null) {
                this.recoveredView.remove(findRequest.getMemberID());
            }
        }
        MemberIdentifier coordinator = null;
        boolean fromView = false;
        if (responseView != null) {
            ID requestingMemberID = findRequest.getMemberID();
            for (MemberIdentifier id : responseView.getMembers()) {
                if (requestingMemberID.getMemberData().compareTo(id.getMemberData(), false) != 0) continue;
                GMSMembershipView<MemberIdentifier> newView = new GMSMembershipView<MemberIdentifier>(responseView, responseView.getViewId());
                newView.remove(id);
                responseView = newView;
                break;
            }
            coordinator = responseView.getViewId() > findRequest.getLastViewId() ? (MemberIdentifier)responseView.getCoordinator(Collections.emptyList()) : (MemberIdentifier)responseView.getCoordinator(findRequest.getRejectedCoordinators());
            logger.info("Peer locator: coordinator from view is {}", coordinator);
            fromView = true;
        }
        if (coordinator == null) {
            Collection<ID> rejections = findRequest.getRejectedCoordinators();
            if (rejections == null) {
                rejections = Collections.emptyList();
            }
            Set<ID> set2 = this.registrants;
            synchronized (set2) {
                coordinator = (MemberIdentifier)this.services.getJoinLeave().getMemberID();
                for (MemberIdentifier mbr : this.registrants) {
                    if (mbr == coordinator || coordinator != null && Objects.compare(mbr, coordinator, this.services.getMemberFactory().getComparator()) >= 0 || rejections.contains(mbr) || !mbr.preferredForCoordinator() && mbr.isNetworkPartitionDetectionEnabled()) continue;
                    coordinator = mbr;
                }
                logger.info("Peer locator: coordinator from registrations is {}", coordinator);
            }
        }
        Set<ID> set3 = this.registrants;
        synchronized (set3) {
            if (this.isCoordinator) {
                coordinator = (MemberIdentifier)this.localAddress;
                if (responseView != null && this.localAddress != null && !this.localAddress.equals(responseView.getCoordinator())) {
                    responseView = null;
                    fromView = false;
                }
            }
            byte[] coordinatorPublicKey = null;
            if (responseView != null) {
                coordinatorPublicKey = (byte[])responseView.getPublicKey(coordinator);
            }
            if (coordinatorPublicKey == null) {
                coordinatorPublicKey = this.services.getMessenger().getPublicKey(coordinator);
            }
            return new FindCoordinatorResponse<Object>(coordinator, this.localAddress, fromView, (GMSMembershipView<Object>)responseView, (HashSet<Object>)new HashSet<ID>(this.registrants), this.networkPartitionDetectionEnabled, this.usePreferredCoordinators, coordinatorPublicKey);
        }
    }

    private void saveView(GMSMembershipView<ID> view) {
        if (this.viewFile == null) {
            return;
        }
        if (!this.viewFile.delete() && this.viewFile.exists()) {
            logger.warn("Peer locator is unable to delete persistent membership information in {}", (Object)this.viewFile.getAbsolutePath());
        }
        try (FileOutputStream fileStream = new FileOutputStream(this.viewFile);
             ObjectOutputStream oos = new ObjectOutputStream(fileStream);){
            oos.writeInt(2072835905);
            oos.writeInt(Version.getCurrentVersion().ordinal());
            oos.flush();
            DataOutputStream dataOutputStream = new DataOutputStream(oos);
            this.objectSerializer.writeObject(view, (DataOutput)dataOutputStream);
        }
        catch (Exception e) {
            logger.warn("Peer locator encountered an error writing current membership to disk.  Disabling persistence.  Care should be taken when bouncing this locator as it will not be able to recover knowledge of the running distributed system", (Throwable)e);
            this.viewFile = null;
        }
    }

    public void endRequest(Object request, long startTime) {
        this.locatorStats.endLocatorRequest(startTime);
    }

    public void endResponse(Object request, long startTime) {
        this.locatorStats.endLocatorResponse(startTime);
    }

    public byte[] getPublicKey(MemberIdentifier member) {
        return this.publicKeys.get(new GMSMemberWrapper(member));
    }

    public void shutDown() {
        this.publicKeys.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public List<ID> getMembers() {
        if (this.view != null) {
            return new ArrayList<ID>(this.view.getMembers());
        }
        Set<ID> set = this.registrants;
        synchronized (set) {
            return new ArrayList<ID>(this.registrants);
        }
    }

    private void recover() {
        if (!this.recoverFromOtherLocators()) {
            this.recoverFromFile(this.viewFile);
        }
    }

    private boolean recoverFromOtherLocators() {
        for (HostAddress other : this.locators) {
            if (!this.recover(other.getSocketInetAddress())) continue;
            logger.info("Peer locator recovered state from {}", (Object)other);
            return true;
        }
        return false;
    }

    private boolean recover(InetSocketAddress other) {
        try {
            logger.info("Peer locator attempting to recover from {}", (Object)other);
            Object response = this.locatorClient.requestToServer(other.getAddress(), other.getPort(), (Object)new GetViewRequest(), 20000, true);
            if (response instanceof GetViewResponse) {
                this.view = ((GetViewResponse)response).getView();
                logger.info("Peer locator recovered initial membership of {}", this.view);
                return true;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            logger.debug("Peer locator could not recover membership view from {}: {}", (Object)other, (Object)e.getMessage());
        }
        logger.info("Peer locator was unable to recover state from this locator");
        return false;
    }

    /*
     * Exception decompiling
     */
    boolean recoverFromFile(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

