/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.EnumActionDestroyOverflow;
import org.apache.geode.cache.configuration.ObjectType;
import org.apache.geode.cache.configuration.RegionAttributesDataPolicy;
import org.apache.geode.cache.configuration.RegionAttributesScope;
import org.apache.geode.cache.configuration.RegionAttributesType;
import org.apache.geode.management.api.RestfulEndpoint;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="region-type", namespace="http://geode.apache.org/schema/cache", propOrder={"regionAttributes", "indexes", "entries", "regionElements", "regions"})
@Experimental
public class RegionConfig
implements CacheElement,
RestfulEndpoint {
    @XmlElement(name="region-attributes", namespace="http://geode.apache.org/schema/cache")
    protected RegionAttributesType regionAttributes;
    @XmlElement(name="index", namespace="http://geode.apache.org/schema/cache")
    protected List<Index> indexes;
    @XmlElement(name="entry", namespace="http://geode.apache.org/schema/cache")
    protected List<Entry> entries;
    @XmlAnyElement(lax=true)
    protected List<CacheElement> regionElements;
    @XmlElement(name="region", namespace="http://geode.apache.org/schema/cache")
    protected List<RegionConfig> regions;
    @XmlAttribute(name="name", required=true)
    protected String name;
    @XmlAttribute(name="refid")
    protected String type;

    public RegionConfig() {
    }

    public RegionConfig(String name, String refid) {
        this.name = name;
        this.type = refid;
    }

    @Override
    public String getEndpoint() {
        return "/regions";
    }

    public RegionAttributesType getRegionAttributes() {
        return this.regionAttributes;
    }

    public void setRegionAttributes(RegionAttributesType regionAttributes) {
        this.regionAttributes = regionAttributes;
    }

    public List<Index> getIndexes() {
        if (this.indexes == null) {
            this.indexes = new ArrayList<Index>();
        }
        return this.indexes;
    }

    public List<Entry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<Entry>();
        }
        return this.entries;
    }

    public List<CacheElement> getCustomRegionElements() {
        if (this.regionElements == null) {
            this.regionElements = new ArrayList<CacheElement>();
        }
        return this.regionElements;
    }

    public List<RegionConfig> getRegions() {
        if (this.regions == null) {
            this.regions = new ArrayList<RegionConfig>();
        }
        return this.regions;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) throws IllegalArgumentException {
        boolean hasSubRegions;
        if (value == null) {
            throw new IllegalArgumentException("Region name cannot be null");
        }
        boolean regionPrefixedWithSlash = value.startsWith("/");
        String[] regionSplit = value.split("/");
        boolean bl = regionPrefixedWithSlash ? regionSplit.length > 2 : (hasSubRegions = regionSplit.length > 1);
        if (hasSubRegions) {
            throw new IllegalArgumentException("Sub-regions are unsupported");
        }
        this.name = regionPrefixedWithSlash ? regionSplit[1] : value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(RegionShortcut regionShortcut) {
        if (regionShortcut != null) {
            this.type = regionShortcut.name();
            this.setShortcutAttributes();
        }
    }

    private void setShortcutAttributes() {
        if (this.regionAttributes == null) {
            this.regionAttributes = new RegionAttributesType();
        }
        switch (this.type) {
            case "PARTITION": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PARTITION);
                break;
            }
            case "PARTITION_REDUNDANT": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PARTITION);
                this.regionAttributes.setRedundantCopy("1");
                break;
            }
            case "PARTITION_PERSISTENT": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PERSISTENT_PARTITION);
                break;
            }
            case "PARTITION_REDUNDANT_PERSISTENT": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PERSISTENT_PARTITION);
                this.regionAttributes.setRedundantCopy("1");
                break;
            }
            case "PARTITION_OVERFLOW": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PARTITION);
                this.regionAttributes.setLruHeapPercentage(EnumActionDestroyOverflow.OVERFLOW_TO_DISK);
                break;
            }
            case "PARTITION_REDUNDANT_OVERFLOW": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PARTITION);
                this.regionAttributes.setRedundantCopy("1");
                this.regionAttributes.setLruHeapPercentage(EnumActionDestroyOverflow.OVERFLOW_TO_DISK);
                break;
            }
            case "PARTITION_PERSISTENT_OVERFLOW": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PERSISTENT_PARTITION);
                this.regionAttributes.setLruHeapPercentage(EnumActionDestroyOverflow.OVERFLOW_TO_DISK);
                break;
            }
            case "PARTITION_REDUNDANT_PERSISTENT_OVERFLOW": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PERSISTENT_PARTITION);
                this.regionAttributes.setRedundantCopy("1");
                this.regionAttributes.setLruHeapPercentage(EnumActionDestroyOverflow.OVERFLOW_TO_DISK);
                break;
            }
            case "PARTITION_HEAP_LRU": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PARTITION);
                this.regionAttributes.setLruHeapPercentage(EnumActionDestroyOverflow.LOCAL_DESTROY);
                break;
            }
            case "PARTITION_REDUNDANT_HEAP_LRU": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PARTITION);
                this.regionAttributes.setRedundantCopy("1");
                this.regionAttributes.setLruHeapPercentage(EnumActionDestroyOverflow.LOCAL_DESTROY);
                break;
            }
            case "REPLICATE": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.REPLICATE);
                this.regionAttributes.setScope(RegionAttributesScope.DISTRIBUTED_ACK);
                break;
            }
            case "REPLICATE_PERSISTENT": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PERSISTENT_REPLICATE);
                this.regionAttributes.setScope(RegionAttributesScope.DISTRIBUTED_ACK);
                break;
            }
            case "REPLICATE_OVERFLOW": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.REPLICATE);
                this.regionAttributes.setScope(RegionAttributesScope.DISTRIBUTED_ACK);
                this.regionAttributes.setLruHeapPercentage(EnumActionDestroyOverflow.OVERFLOW_TO_DISK);
                break;
            }
            case "REPLICATE_PERSISTENT_OVERFLOW": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PERSISTENT_REPLICATE);
                this.regionAttributes.setScope(RegionAttributesScope.DISTRIBUTED_ACK);
                this.regionAttributes.setLruHeapPercentage(EnumActionDestroyOverflow.OVERFLOW_TO_DISK);
                break;
            }
            case "REPLICATE_HEAP_LRU": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PRELOADED);
                this.regionAttributes.setScope(RegionAttributesScope.DISTRIBUTED_ACK);
                this.regionAttributes.setInterestPolicy("all");
                this.regionAttributes.setLruHeapPercentage(EnumActionDestroyOverflow.LOCAL_DESTROY);
                break;
            }
            case "LOCAL": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.NORMAL);
                this.regionAttributes.setScope(RegionAttributesScope.LOCAL);
                break;
            }
            case "LOCAL_PERSISTENT": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PERSISTENT_REPLICATE);
                this.regionAttributes.setScope(RegionAttributesScope.LOCAL);
                break;
            }
            case "LOCAL_HEAP_LRU": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.NORMAL);
                this.regionAttributes.setScope(RegionAttributesScope.LOCAL);
                this.regionAttributes.setLruHeapPercentage(EnumActionDestroyOverflow.LOCAL_DESTROY);
                break;
            }
            case "LOCAL_OVERFLOW": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.NORMAL);
                this.regionAttributes.setScope(RegionAttributesScope.LOCAL);
                this.regionAttributes.setLruHeapPercentage(EnumActionDestroyOverflow.OVERFLOW_TO_DISK);
                break;
            }
            case "LOCAL_PERSISTENT_OVERFLOW": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PERSISTENT_REPLICATE);
                this.regionAttributes.setScope(RegionAttributesScope.LOCAL);
                this.regionAttributes.setLruHeapPercentage(EnumActionDestroyOverflow.OVERFLOW_TO_DISK);
                break;
            }
            case "PARTITION_PROXY": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PARTITION);
                this.regionAttributes.setLocalMaxMemory("0");
                break;
            }
            case "PARTITION_PROXY_REDUNDANT": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PARTITION);
                this.regionAttributes.setLocalMaxMemory("0");
                this.regionAttributes.setRedundantCopy("1");
                break;
            }
            case "REPLICATE_PROXY": {
                this.regionAttributes.setDataPolicy(RegionAttributesDataPolicy.EMPTY);
                this.regionAttributes.setScope(RegionAttributesScope.DISTRIBUTED_ACK);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type " + this.type);
            }
        }
    }

    public String getId() {
        return this.getName();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Index
    implements CacheElement,
    Serializable {
        @XmlAttribute(name="name", required=true)
        protected String name;
        @XmlAttribute(name="expression")
        protected String expression;
        @XmlAttribute(name="from-clause")
        protected String fromClause;
        @XmlAttribute(name="imports")
        protected String imports;
        @XmlAttribute(name="key-index")
        protected Boolean keyIndex;
        @XmlAttribute(name="type")
        protected String type;

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String value) {
            this.expression = value;
        }

        public String getFromClause() {
            return this.fromClause;
        }

        public void setFromClause(String value) {
            this.fromClause = value;
        }

        public String getImports() {
            return this.imports;
        }

        public void setImports(String value) {
            this.imports = value;
        }

        public Boolean isKeyIndex() {
            return this.keyIndex;
        }

        public void setKeyIndex(Boolean value) {
            this.keyIndex = value;
        }

        public String getType() {
            if (this.type == null) {
                return "range";
            }
            return this.type;
        }

        public void setType(String value) {
            if (!("range".equalsIgnoreCase(value) || "hash".equalsIgnoreCase(value) || "key".equalsIgnoreCase(value))) {
                throw new IllegalArgumentException("Invalid index type " + value);
            }
            this.type = value.toLowerCase();
            this.setKeyIndex("key".equalsIgnoreCase(value));
        }

        public String getId() {
            return this.getName();
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"key", "value"})
    public static class Entry
    implements Serializable {
        @XmlElement(namespace="http://geode.apache.org/schema/cache", required=true)
        protected ObjectType key;
        @XmlElement(namespace="http://geode.apache.org/schema/cache", required=true)
        protected ObjectType value;

        public Entry() {
        }

        public Entry(String key, String value) {
            this.key = new ObjectType(key);
            this.value = new ObjectType(value);
        }

        public Entry(ObjectType key, ObjectType value) {
            this.key = key;
            this.value = value;
        }

        public ObjectType getKey() {
            return this.key;
        }

        public void setKey(ObjectType value) {
            this.key = value;
        }

        public ObjectType getValue() {
            return this.value;
        }

        public void setValue(ObjectType value) {
            this.value = value;
        }
    }
}

