/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.geode.management.configuration.GroupableConfiguration;
import org.apache.geode.management.configuration.Links;
import org.apache.geode.management.configuration.RegionType;
import org.apache.geode.management.runtime.RuntimeRegionInfo;

public class Region
extends GroupableConfiguration<RuntimeRegionInfo> {
    public static final String REGION_CONFIG_ENDPOINT = "/regions";
    private String name;
    private RegionType type;
    private String keyConstraint;
    private String valueConstraint;
    private String diskStoreName;
    private Integer redundantCopies;
    private List<Expiration> expirations;

    @Override
    public boolean isGlobalRuntime() {
        return true;
    }

    @Override
    public Links getLinks() {
        Links links = new Links(this.getId(), REGION_CONFIG_ENDPOINT);
        links.addLink("indexes", links.getSelf() + "/indexes");
        return links;
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        boolean hasSubRegions;
        if (value == null) {
            this.name = null;
            return;
        }
        boolean regionPrefixedWithSlash = value.startsWith("/");
        String[] regionSplit = value.split("/");
        boolean bl = regionPrefixedWithSlash ? regionSplit.length > 2 : (hasSubRegions = regionSplit.length > 1);
        if (hasSubRegions) {
            throw new IllegalArgumentException("Sub-regions are unsupported");
        }
        this.name = regionPrefixedWithSlash ? regionSplit[1] : value;
    }

    public RegionType getType() {
        return this.type;
    }

    public void setType(RegionType type) {
        this.type = type;
    }

    public Integer getRedundantCopies() {
        return this.redundantCopies;
    }

    public void setRedundantCopies(Integer redundantCopies) {
        this.redundantCopies = redundantCopies;
    }

    public String getKeyConstraint() {
        return this.keyConstraint;
    }

    public void setKeyConstraint(String keyConstraint) {
        this.keyConstraint = keyConstraint;
    }

    public String getValueConstraint() {
        return this.valueConstraint;
    }

    public void setValueConstraint(String valueConstraint) {
        this.valueConstraint = valueConstraint;
    }

    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    public void setDiskStoreName(String diskStoreName) {
        this.diskStoreName = diskStoreName;
    }

    public List<Expiration> getExpirations() {
        return this.expirations;
    }

    public void setExpirations(List<Expiration> expirations) {
        if (expirations == null) {
            this.expirations = null;
            return;
        }
        this.expirations = expirations.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void addExpiry(ExpirationType type, Integer timeout, ExpirationAction action) {
        if (this.expirations == null) {
            this.expirations = new ArrayList<Expiration>();
        }
        this.expirations.add(new Expiration(type, timeout, action));
    }

    public static class Expiration
    implements Serializable {
        private ExpirationType type;
        private Integer timeInSeconds;
        private ExpirationAction action;

        public Expiration() {
        }

        public Expiration(ExpirationType type, Integer timeInSeconds, ExpirationAction action) {
            this.setType(type);
            this.timeInSeconds = timeInSeconds;
            this.action = action;
        }

        public ExpirationType getType() {
            return this.type;
        }

        public void setType(ExpirationType type) {
            this.type = type;
        }

        public Integer getTimeInSeconds() {
            return this.timeInSeconds;
        }

        public void setTimeInSeconds(Integer timeInSeconds) {
            this.timeInSeconds = timeInSeconds;
        }

        public ExpirationAction getAction() {
            return this.action;
        }

        public void setAction(ExpirationAction action) {
            this.action = action;
        }
    }

    public static enum ExpirationAction {
        DESTROY,
        INVALIDATE,
        LEGACY;

    }

    public static enum ExpirationType {
        ENTRY_TIME_TO_LIVE,
        ENTRY_IDLE_TIME,
        LEGACY;

    }
}

