/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.configuration.GroupableConfiguration;
import org.apache.geode.management.configuration.Links;
import org.apache.geode.management.runtime.RuntimeInfo;

public class Index
extends GroupableConfiguration<RuntimeInfo> {
    private String name;
    private String expression;
    private String regionPath;
    private Boolean keyIndex;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    public void setRegionPath(String regionPath) {
        this.regionPath = regionPath;
    }

    public Boolean getKeyIndex() {
        return this.keyIndex;
    }

    public void setKeyIndex(Boolean keyIndex) {
        this.keyIndex = keyIndex;
    }

    @JsonIgnore
    public String getRegionName() {
        if (this.regionPath == null) {
            return null;
        }
        String regionName = this.regionPath.trim().split(" ")[0];
        if ((regionName = StringUtils.removeStart((String)regionName, (String)"/")).contains(".")) {
            regionName = regionName.substring(0, regionName.indexOf(46));
        }
        return regionName;
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.getName();
    }

    @Override
    public Links getLinks() {
        String regionName = this.getRegionName();
        if (StringUtils.isBlank((CharSequence)regionName)) {
            return new Links(this.getId(), "/indexes");
        }
        Links links = new Links(this.getId(), "/regions/" + regionName + "/indexes");
        links.addLink("region", "/regions/" + regionName);
        return links;
    }
}

